#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Monday 24 November 2008 18:08:42 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Examples/NBCR/ScreeningADT_net.py,v 1.7 2008/11/25 03:03:21 lclement Exp $
#
# $Id: ScreeningADT_net.py,v 1.7 2008/11/25 03:03:21 lclement Exp $
#


if __name__=='__main__':
    from sys import argv
    if '-h' in argv or '-w' in argv: # run without Vision
        withoutVision = True
        from Vision.VPE import NoGuiExec
        ed = NoGuiExec()
        from NetworkEditor.net import Network
        import os
        masterNet = Network("process-"+str(os.getpid()))
        ed.addNetwork(masterNet)
    else: # run as a stand alone application while vision is hidden
        withoutVision = False
        from Vision import launchVisionToRunNetworkAsApplication, mainLoopVisionToRunNetworkAsApplication
        masterNet = launchVisionToRunNetworkAsApplication()
        import os
        masterNet.filename = os.path.abspath(__file__)
from traceback import print_exc

## loading libraries ##
from Pmv.VisionInterface.PmvNodes import pmvlib
from WebServices.VisionInterface.WSNodes import wslib
from Vision.StandardNodes import stdlib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

masterNet.getEditor().addLibraryInstance(pmvlib,"Pmv.VisionInterface.PmvNodes", "pmvlib")

masterNet.getEditor().addLibraryInstance(wslib,"WebServices.VisionInterface.WSNodes", "wslib")

masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

from WebServices.VisionInterface.WSNodes import addOpalServerAsCategory
addOpalServerAsCategory("http://ws.nbcr.net/opal")
addOpalServerAsCategory("http://kryptonite.nbcr.net/opal2")
try:
    ## saving node Receptor File ##
    from Vision.StandardNodes import FileBrowserNE
    Receptor_File_0 = FileBrowserNE(constrkw={}, name='Receptor File', library=stdlib)
    masterNet.addNode(Receptor_File_0,17,9)
    apply(Receptor_File_0.configure, (), {'specialPortsVisible': True})
    Receptor_File_0.inputPortByName['filename'].widget.set(r"2HU4-chain_B.pdb", run=False)
    apply(Receptor_File_0.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore FileBrowserNE named Receptor File in network masterNet"
    print_exc()
    Receptor_File_0=None

try:
    ## saving node ReceptorPDBQT ##
    from Vision.StandardNodes import FileBrowserNE
    ReceptorPDBQT_1 = FileBrowserNE(constrkw={}, name='ReceptorPDBQT', library=stdlib)
    masterNet.addNode(ReceptorPDBQT_1,254,195)
    apply(ReceptorPDBQT_1.configure, (), {'specialPortsVisible': True})
    ReceptorPDBQT_1.inputPortByName['filename'].rebindWidget()
    ReceptorPDBQT_1.inputPortByName['filename'].widget.set(r"3ptb_rec.pdbqt", run=False)
    ReceptorPDBQT_1.inputPortByName['filename'].unbindWidget()
    apply(ReceptorPDBQT_1.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore FileBrowserNE named ReceptorPDBQT in network masterNet"
    print_exc()
    ReceptorPDBQT_1=None

try:
    ## saving node GPFFile ##
    from Vision.StandardNodes import FileBrowserNE
    GPFFile_2 = FileBrowserNE(constrkw={}, name='GPFFile', library=stdlib)
    masterNet.addNode(GPFFile_2,184,269)
    apply(GPFFile_2.configure, (), {'specialPortsVisible': True})
    GPFFile_2.inputPortByName['filename'].rebindWidget()
    GPFFile_2.inputPortByName['filename'].widget.set(r"3ptb_test.gpf", run=False)
    GPFFile_2.inputPortByName['filename'].unbindWidget()
    apply(GPFFile_2.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore FileBrowserNE named GPFFile in network masterNet"
    print_exc()
    GPFFile_2=None

try:
    ## saving node autodock-screening ##
    from NetworkEditor.macros import MacroNode
    autodock_screening_3 = MacroNode(name='autodock-screening')
    masterNet.addNode(autodock_screening_3, 298, 458)
    input_Ports_4 = autodock_screening_3.macroNetwork.ipNode
    apply(input_Ports_4.configure, (), {'paramPanelImmediate': 1})
    input_Ports_4.move(340, 4)
    output_Ports_5 = autodock_screening_3.macroNetwork.opNode
    apply(output_Ports_5.configure, (), {'paramPanelImmediate': 1})
    output_Ports_5.move(308, 455)
    from Vision.StandardNodes import Index
    Index_7 = Index(constrkw={}, name='Index', library=stdlib)
    autodock_screening_3.macroNetwork.addNode(Index_7,334,135)
    apply(Index_7.outputPortByName['data'].configure, (), {'datatype': 'string'})
    apply(Index_7.inputPortByName['index'].widget.configure, (), {'max': 25, 'min': -26})
    Index_7.inputPortByName['index'].widget.set(0, run=False)
    apply(Index_7.configure, (), {'paramPanelImmediate': 1})
    from NetworkEditor.items import FunctionNode
    autodock_kryptonite_nbcr_net_11 = FunctionNode(functionOrString='autodock_kryptonite_nbcr_net', host="http://kryptonite.nbcr.net/opal2", importString='', namedArgs={'ga_run': '', 'lib': '', 'ga_num_generations': '', 'ga_num_evals': '', 'u': '', 'ga_pop_size': '', 'localRun': False, 'email': '', 'execPath': ''}, constrkw={'functionOrString': "'autodock_kryptonite_nbcr_net'", 'host': '"http://kryptonite.nbcr.net/opal2"', 'importString': "''", 'namedArgs': {'ga_run': '', 'lib': '', 'ga_num_generations': '', 'ga_num_evals': '', 'u': '', 'ga_pop_size': '', 'localRun': False, 'email': '', 'execPath': ''}}, name='autodock_kryptonite_nbcr_net', library=wslib)
    autodock_screening_3.macroNetwork.addNode(autodock_kryptonite_nbcr_net_11,334,78)
    autodock_kryptonite_nbcr_net_11.inputPortByName['ga_run'].widget.set(r"7", run=False)
    autodock_kryptonite_nbcr_net_11.inputPortByName['lib'].rebindWidget()
    autodock_kryptonite_nbcr_net_11.inputPortByName['lib'].widget.set(r"sample", run=False)
    autodock_kryptonite_nbcr_net_11.inputPortByName['lib'].unbindWidget()
    autodock_kryptonite_nbcr_net_11.inputPortByName['ga_num_generations'].widget.set(r"2700", run=False)
    autodock_kryptonite_nbcr_net_11.inputPortByName['ga_num_evals'].widget.set(r"250000", run=False)
    autodock_kryptonite_nbcr_net_11.inputPortByName['u'].rebindWidget()
    autodock_kryptonite_nbcr_net_11.inputPortByName['u'].widget.set(r"", run=False)
    autodock_kryptonite_nbcr_net_11.inputPortByName['u'].unbindWidget()
    autodock_kryptonite_nbcr_net_11.inputPortByName['ga_pop_size'].widget.set(r"100", run=False)
    autodock_kryptonite_nbcr_net_11.inputPortByName['localRun'].widget.set(0, run=False)
    autodock_kryptonite_nbcr_net_11.inputPortByName['email'].widget.set(r"", run=False)
    autodock_kryptonite_nbcr_net_11.inputPortByName['execPath'].widget.set(r"", run=False)
    apply(autodock_kryptonite_nbcr_net_11.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import Generic
    Download4Summarize_107 = Generic(constrkw={}, name='Download4Summarize', library=stdlib)
    autodock_screening_3.macroNetwork.addNode(Download4Summarize_107,338,222)
    apply(Download4Summarize_107.addInputPort, (), {'singleConnection': True, 'name': 'in1', 'cast': True, 'datatype': 'string', 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(Download4Summarize_107.addOutputPort, (), {'name': 'out1', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    apply(Download4Summarize_107.addOutputPort, (), {'name': 'out11', 'datatype': 'None', 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    apply(Download4Summarize_107.configure, (), {'specialPortsVisible': True})
    code = """def doit(self, in1):
        maindir = 'vision_work'
        if os.name == 'dos' or os.name == 'nt':
            downloadcmd = 'md ' + maindir + ' && cd vision_work && wget -r ' + in1 + '/..'
        else:
            downloadcmd = 'mkdir -p ' + maindir + '; cd vision_work; wget -r ' + in1 + '/..'

        os.system(downloadcmd)
        d1, d2, d3, d4, d5 = in1.split('/')
        dir = os.getcwd() + '/' + maindir + '/' + d3 + '/' + d4
        sum = dir + '/' + 'summarize_results.txt'
        dir = os.path.normpath(dir)
        sum = os.path.normpath(sum)
    
	pass

        self.outputData(out1=sum, out11=dir)

## to ouput data on port out1 use
## self.outputData(out1=data)





















## to ouput data on port out11 use
## self.outputData(out11=data)


"""
    Download4Summarize_107.configure(function=code)
    apply(Download4Summarize_107.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
    from Vision.StandardNodes import Generic
    OpenFile_108 = Generic(constrkw={}, name='OpenFile', library=stdlib)
    autodock_screening_3.macroNetwork.addNode(OpenFile_108,243,309)
    apply(OpenFile_108.addInputPort, (), {'singleConnection': True, 'name': 'in0', 'cast': True, 'datatype': 'string', 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    code = """def doit(self, in0):
        if os.name == 'nt' or os.name == 'dos':
            open_prog = 'explorer'
        elif os.name == 'posix':
            if os.uname()[0] == 'Darwin':
                open_prog = 'open'
            else:
                open_prog = 'gnome-open'
        else:
            open_prog = ''

        cmd = open_prog + ' ' + in0
        os.system(cmd)
            
	pass











"""
    OpenFile_108.configure(function=code)
    apply(OpenFile_108.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import Generic
    OpenFile_109 = Generic(constrkw={}, name='OpenFile', library=stdlib)
    autodock_screening_3.macroNetwork.addNode(OpenFile_109,362,332)
    apply(OpenFile_109.addInputPort, (), {'singleConnection': True, 'name': 'in0', 'cast': True, 'datatype': 'string', 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    code = """def doit(self, in0):
        if os.name == 'nt' or os.name == 'dos':
            open_prog = 'explorer'
        elif os.name == 'posix':
            if os.uname()[0] == 'Darwin':
                open_prog = 'open'
            else:
                open_prog = 'gnome-open'
        else:
            open_prog = ''

        cmd = open_prog + ' ' + in0
        os.system(cmd)
            
	pass











"""
    OpenFile_109.configure(function=code)
    apply(OpenFile_109.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import Generic
    OpenFile_110 = Generic(constrkw={}, name='OpenFile', library=stdlib)
    autodock_screening_3.macroNetwork.addNode(OpenFile_110,568,277)
    apply(OpenFile_110.addInputPort, (), {'singleConnection': True, 'name': 'in0', 'cast': True, 'datatype': 'string', 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    code = """def doit(self, in0):
        if os.name == 'nt' or os.name == 'dos':
            open_prog = 'explorer'
        elif os.name == 'posix':
            if os.uname()[0] == 'Darwin':
                open_prog = 'open'
            else:
                open_prog = 'gnome-open'
        else:
            open_prog = ''

        cmd = open_prog + ' ' + in0
        os.system(cmd)
            
	pass











"""
    OpenFile_110.configure(function=code)
    apply(OpenFile_110.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import Eval
    eval__in1_______111 = Eval(constrkw={}, name='eval: in1 + /..', library=stdlib)
    autodock_screening_3.macroNetwork.addNode(eval__in1_______111,570,195)
    eval__in1_______111.inputPortByName['command'].widget.set(r"in1 + '/..'", run=False)
    eval__in1_______111.inputPortByName['importString'].widget.set(r"", run=False)
    apply(eval__in1_______111.configure, (), {'paramPanelImmediate': 1})

    ## saving connections for network autodock-screening ##
    autodock_screening_3.macroNetwork.freeze()
    if autodock_kryptonite_nbcr_net_11 is not None and Index_7 is not None:
        try:
            autodock_screening_3.macroNetwork.connectNodes(
                autodock_kryptonite_nbcr_net_11, Index_7, "result", "data", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between autodock_kryptonite_nbcr_net_11 and Index_7 in network autodock_screening_3.macroNetwork"
    input_Ports_4 = autodock_screening_3.macroNetwork.ipNode
    if input_Ports_4 is not None and autodock_kryptonite_nbcr_net_11 is not None:
        try:
            autodock_screening_3.macroNetwork.connectNodes(
                input_Ports_4, autodock_kryptonite_nbcr_net_11, "new", "u", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between input_Ports_4 and autodock_kryptonite_nbcr_net_11 in network autodock_screening_3.macroNetwork"
    if input_Ports_4 is not None and autodock_kryptonite_nbcr_net_11 is not None:
        try:
            autodock_screening_3.macroNetwork.connectNodes(
                input_Ports_4, autodock_kryptonite_nbcr_net_11, "new", "lib", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between input_Ports_4 and autodock_kryptonite_nbcr_net_11 in network autodock_screening_3.macroNetwork"
    if Index_7 is not None and Download4Summarize_107 is not None:
        try:
            autodock_screening_3.macroNetwork.connectNodes(
                Index_7, Download4Summarize_107, "data", "in1", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between Index_7 and Download4Summarize_107 in network autodock_screening_3.macroNetwork"
    if Download4Summarize_107 is not None and OpenFile_108 is not None:
        try:
            autodock_screening_3.macroNetwork.connectNodes(
                Download4Summarize_107, OpenFile_108, "out1", "in0", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between Download4Summarize_107 and OpenFile_108 in network autodock_screening_3.macroNetwork"
    if Download4Summarize_107 is not None and OpenFile_109 is not None:
        try:
            autodock_screening_3.macroNetwork.connectNodes(
                Download4Summarize_107, OpenFile_109, "out11", "in0", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between Download4Summarize_107 and OpenFile_109 in network autodock_screening_3.macroNetwork"
    if Index_7 is not None and eval__in1_______111 is not None:
        try:
            autodock_screening_3.macroNetwork.connectNodes(
                Index_7, eval__in1_______111, "data", "in1", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between Index_7 and eval__in1_______111 in network autodock_screening_3.macroNetwork"
    if eval__in1_______111 is not None and OpenFile_110 is not None:
        try:
            autodock_screening_3.macroNetwork.connectNodes(
                eval__in1_______111, OpenFile_110, "result", "in0", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between eval__in1_______111 and OpenFile_110 in network autodock_screening_3.macroNetwork"
    autodock_screening_3.macroNetwork.unfreeze()
    autodock_screening_3.shrink()
    apply(autodock_screening_3.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore MacroNode named autodock-screening in network masterNet"
    print_exc()
    autodock_screening_3=None

try:
    ## saving node autogrid ##
    from NetworkEditor.macros import MacroNode
    autogrid_12 = MacroNode(name='autogrid')
    masterNet.addNode(autogrid_12, 237, 377)
    output_Ports_14 = autogrid_12.macroNetwork.opNode
    apply(output_Ports_14.configure, (), {'paramPanelImmediate': 1})
    output_Ports_14.move(198, 350)
    from Vision.StandardNodes import Eval
    eval__in1_____15 = Eval(constrkw={}, name='eval: in1+/..', library=stdlib)
    autogrid_12.macroNetwork.addNode(eval__in1_____15,216,218)
    apply(eval__in1_____15.inputPortByName['in1'].configure, (), {'datatype': 'string', 'originalDatatype': 'None'})
    eval__in1_____15.inputPortByName['command'].widget.set(r"in1+'/..'", run=False)
    eval__in1_____15.inputPortByName['importString'].widget.set(r"", run=False)
    apply(eval__in1_____15.configure, (), {'paramPanelImmediate': 1, 'expanded': True})
    from Vision.StandardNodes import Index
    Index_16 = Index(constrkw={}, name='Index', library=stdlib)
    autogrid_12.macroNetwork.addNode(Index_16,216,145)
    apply(Index_16.outputPortByName['data'].configure, (), {'datatype': 'string'})
    apply(Index_16.inputPortByName['index'].widget.configure, (), {'max': 14, 'min': -15})
    Index_16.inputPortByName['index'].widget.set(0, run=False)
    apply(Index_16.configure, (), {'paramPanelImmediate': 1})
    from NetworkEditor.items import FunctionNode
    autogrid_kryptonite_nbcr_net_17 = FunctionNode(functionOrString='autogrid_kryptonite_nbcr_net', host="http://kryptonite.nbcr.net/opal2", importString='', namedArgs={'l': 'otuput.glg', 'o': False, 'p': '', 'localRun': False, 'inFile': '', 'execPath': ''}, constrkw={'functionOrString': "'autogrid_kryptonite_nbcr_net'", 'host': '"http://kryptonite.nbcr.net/opal2"', 'importString': "''", 'namedArgs': {'l': 'otuput.glg', 'o': False, 'p': '', 'localRun': False, 'inFile': '', 'execPath': ''}}, name='autogrid_kryptonite_nbcr_net', library=wslib)
    autogrid_12.macroNetwork.addNode(autogrid_kryptonite_nbcr_net_17,217,86)
    autogrid_kryptonite_nbcr_net_17.inputPortByName['l'].widget.set(r"output.glg", run=False)
    autogrid_kryptonite_nbcr_net_17.inputPortByName['o'].widget.set(0, run=False)
    autogrid_kryptonite_nbcr_net_17.inputPortByName['p'].rebindWidget()
    autogrid_kryptonite_nbcr_net_17.inputPortByName['p'].widget.set(r"", run=False)
    autogrid_kryptonite_nbcr_net_17.inputPortByName['p'].unbindWidget()
    autogrid_kryptonite_nbcr_net_17.inputPortByName['localRun'].widget.set(0, run=False)
    autogrid_kryptonite_nbcr_net_17.inputPortByName['inFile'].rebindWidget()
    autogrid_kryptonite_nbcr_net_17.inputPortByName['inFile'].widget.set(r"", run=False)
    autogrid_kryptonite_nbcr_net_17.inputPortByName['inFile'].unbindWidget()
    autogrid_kryptonite_nbcr_net_17.inputPortByName['execPath'].widget.set(r"", run=False)
    apply(autogrid_kryptonite_nbcr_net_17.configure, (), {'paramPanelImmediate': 1})

    ## saving connections for network autogrid ##
    autogrid_12.macroNetwork.freeze()
    if Index_16 is not None and eval__in1_____15 is not None:
        try:
            autogrid_12.macroNetwork.connectNodes(
                Index_16, eval__in1_____15, "data", "in1", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between Index_16 and eval__in1_____15 in network autogrid_12.macroNetwork"
    if autogrid_kryptonite_nbcr_net_17 is not None and Index_16 is not None:
        try:
            autogrid_12.macroNetwork.connectNodes(
                autogrid_kryptonite_nbcr_net_17, Index_16, "result", "data", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between autogrid_kryptonite_nbcr_net_17 and Index_16 in network autogrid_12.macroNetwork"
    input_Ports_13 = autogrid_12.macroNetwork.ipNode
    if input_Ports_13 is not None and autogrid_kryptonite_nbcr_net_17 is not None:
        try:
            autogrid_12.macroNetwork.connectNodes(
                input_Ports_13, autogrid_kryptonite_nbcr_net_17, "new", "p", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between input_Ports_13 and autogrid_kryptonite_nbcr_net_17 in network autogrid_12.macroNetwork"
    if input_Ports_13 is not None and autogrid_kryptonite_nbcr_net_17 is not None:
        try:
            autogrid_12.macroNetwork.connectNodes(
                input_Ports_13, autogrid_kryptonite_nbcr_net_17, "new", "inFile", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between input_Ports_13 and autogrid_kryptonite_nbcr_net_17 in network autogrid_12.macroNetwork"
    output_Ports_14 = autogrid_12.macroNetwork.opNode
    if eval__in1_____15 is not None and output_Ports_14 is not None:
        try:
            autogrid_12.macroNetwork.connectNodes(
                eval__in1_____15, output_Ports_14, "result", "new", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between eval__in1_____15 and output_Ports_14 in network autogrid_12.macroNetwork"
    autogrid_12.macroNetwork.unfreeze()
    autogrid_12.shrink()
    apply(autogrid_12.configure, (), {'frozen': True, 'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore MacroNode named autogrid in network masterNet"
    print_exc()
    autogrid_12=None

try:
    ## saving node ADTloadmolecule ##
    from NetworkEditor.macros import MacroNode
    ADTloadmolecule_18 = MacroNode(name='ADTloadmolecule')
    masterNet.addNode(ADTloadmolecule_18, 18, 268)
    input_Ports_19 = ADTloadmolecule_18.macroNetwork.ipNode
    apply(input_Ports_19.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
    input_Ports_19.move(229, 11)
    output_Ports_20 = ADTloadmolecule_18.macroNetwork.opNode
    apply(output_Ports_20.configure, (), {'paramPanelImmediate': 1})
    output_Ports_20.move(272, 411)
    from Pmv.VisionInterface.PmvNodes import PmvRunCommand
    Run_readPDBQT_21 = PmvRunCommand(command=masterNet.editor.vf.readPDBQT, namedArgs={'topCommand': True, 'redraw': True, 'setupUndo': True, 'log': True}, posArgsNames=['filename'], constrkw={'command': 'masterNet.editor.vf.readPDBQT', 'namedArgs': "{'topCommand': True, 'redraw': True, 'setupUndo': True, 'log': True}", 'posArgsNames': "['filename']"}, name='Run readPDBQT', library=pmvlib)
    ADTloadmolecule_18.macroNetwork.addNode(Run_readPDBQT_21,108,272)
    apply(Run_readPDBQT_21.inputPortByName['command'].configure, (), {'datatype': 'PmvCmd', 'originalDatatype': 'None'})
    apply(Run_readPDBQT_21.addInputPort, (), {'singleConnection': True, 'name': 'filename', 'cast': True, 'datatype': 'string', 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(Run_readPDBQT_21.addInputPort, (), {'singleConnection': True, 'name': 'topCommand', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_readPDBQT_21.addInputPort, (), {'singleConnection': True, 'name': 'redraw', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_readPDBQT_21.addInputPort, (), {'singleConnection': True, 'name': 'setupUndo', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_readPDBQT_21.addInputPort, (), {'singleConnection': True, 'name': 'log', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_readPDBQT_21.configure, (), {'specialPortsVisible': True})
    Run_readPDBQT_21.inputPortByName['command'].rebindWidget()
    Run_readPDBQT_21.inputPortByName['command'].widget.set(r"", run=False)
    Run_readPDBQT_21.inputPortByName['command'].unbindWidget()
    Run_readPDBQT_21.inputPortByName['importString'].widget.set(r"", run=False)
    apply(Run_readPDBQT_21.inputPortByName['topCommand'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 1, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 1}, 'labelCfg': {'text': 'topCommand'}, 'class': 'NECheckButton'}})
    Run_readPDBQT_21.inputPortByName['topCommand'].widget.set(1, run=False)
    apply(Run_readPDBQT_21.inputPortByName['redraw'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 3, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 3}, 'labelCfg': {'text': 'redraw'}, 'class': 'NECheckButton'}})
    Run_readPDBQT_21.inputPortByName['redraw'].widget.set(1, run=False)
    apply(Run_readPDBQT_21.inputPortByName['setupUndo'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 5, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 5}, 'labelCfg': {'text': 'setupUndo'}, 'class': 'NECheckButton'}})
    Run_readPDBQT_21.inputPortByName['setupUndo'].widget.set(1, run=False)
    apply(Run_readPDBQT_21.inputPortByName['log'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 7, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 7}, 'labelCfg': {'text': 'log'}, 'class': 'NECheckButton'}})
    Run_readPDBQT_21.inputPortByName['log'].widget.set(1, run=False)
    apply(Run_readPDBQT_21.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
    from Pmv.VisionInterface.PmvNodes import PmvNode
    Pmv_22 = PmvNode(vf=masterNet.editor.vf, constrkw={'vf': 'masterNet.editor.vf'}, name='Pmv', library=pmvlib)
    ADTloadmolecule_18.macroNetwork.addNode(Pmv_22,28,105)
    apply(Pmv_22.configure, (), {'specialPortsVisible': True})
    Pmv_22.inputPortByName['cmdName'].widget.set(r"readPDBQT", run=False)
    Pmv_22.inputPortByName['molecule'].widget.set(r"", run=False)
    apply(Pmv_22.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
    from Pmv.VisionInterface.PmvNodes import PmvNode
    Pmv_23 = PmvNode(vf=masterNet.editor.vf, constrkw={'vf': 'masterNet.editor.vf'}, name='Pmv', library=pmvlib)
    ADTloadmolecule_18.macroNetwork.addNode(Pmv_23,247,194)
    apply(Pmv_23.configure, (), {'specialPortsVisible': True})
    Pmv_23.inputPortByName['cmdName'].widget.set(r"computeMSMS", run=False)
    Pmv_23.inputPortByName['molecule'].widget.set(r"", run=False)
    apply(Pmv_23.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
    from Pmv.VisionInterface.PmvNodes import PmvRunCommand
    Run_computeMSMS_24 = PmvRunCommand(command=masterNet.editor.vf.computeMSMS, namedArgs={'hdensity': 6.0, 'hdset': 'None', 'topCommand': True, 'setupUndo': True, 'surfName': 'MSMS-MOL', 'density': 3.0, 'log': True, 'perMol': True, 'redraw': True, 'display': True, 'pRadius': 1.5}, posArgsNames=['nodes'], constrkw={'command': 'masterNet.editor.vf.computeMSMS', 'namedArgs': "{'hdensity': 6.0, 'hdset': 'None', 'topCommand': True, 'setupUndo': True, 'surfName': 'MSMS-MOL', 'density': 3.0, 'log': True, 'perMol': True, 'redraw': True, 'display': True, 'pRadius': 1.5}", 'posArgsNames': "['nodes']"}, name='Run computeMSMS', library=pmvlib)
    ADTloadmolecule_18.macroNetwork.addNode(Run_computeMSMS_24,338,282)
    apply(Run_computeMSMS_24.inputPortByName['command'].configure, (), {'datatype': 'PmvCmd', 'originalDatatype': 'None'})
    apply(Run_computeMSMS_24.addInputPort, (), {'singleConnection': True, 'name': 'nodes', 'cast': True, 'datatype': 'None', 'required': True, 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    apply(Run_computeMSMS_24.addInputPort, (), {'singleConnection': True, 'name': 'hdensity', 'cast': True, 'datatype': 'float', 'balloon': 'Defaults to6.0', 'required': False, 'height': 12, 'width': 12, 'shape': 'circle', 'color': 'green'})
    apply(Run_computeMSMS_24.addInputPort, (), {'singleConnection': True, 'name': 'hdset', 'cast': True, 'datatype': 'string', 'balloon': 'Defaults toNone', 'required': False, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    apply(Run_computeMSMS_24.addInputPort, (), {'singleConnection': True, 'name': 'topCommand', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_computeMSMS_24.addInputPort, (), {'singleConnection': True, 'name': 'setupUndo', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_computeMSMS_24.addInputPort, (), {'singleConnection': True, 'name': 'surfName', 'cast': True, 'datatype': 'string', 'balloon': 'Defaults toMSMS-MOL', 'required': False, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    apply(Run_computeMSMS_24.addInputPort, (), {'singleConnection': True, 'name': 'density', 'cast': True, 'datatype': 'float', 'balloon': 'Defaults to3.0', 'required': False, 'height': 12, 'width': 12, 'shape': 'circle', 'color': 'green'})
    apply(Run_computeMSMS_24.addInputPort, (), {'singleConnection': True, 'name': 'log', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_computeMSMS_24.addInputPort, (), {'singleConnection': True, 'name': 'perMol', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_computeMSMS_24.addInputPort, (), {'singleConnection': True, 'name': 'redraw', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_computeMSMS_24.addInputPort, (), {'singleConnection': True, 'name': 'display', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_computeMSMS_24.addInputPort, (), {'singleConnection': True, 'name': 'pRadius', 'cast': True, 'datatype': 'float', 'balloon': 'Defaults to1.5', 'required': False, 'height': 12, 'width': 12, 'shape': 'circle', 'color': 'green'})
    apply(Run_computeMSMS_24.configure, (), {'specialPortsVisible': True})
    Run_computeMSMS_24.inputPortByName['command'].rebindWidget()
    Run_computeMSMS_24.inputPortByName['command'].widget.set(r"", run=False)
    Run_computeMSMS_24.inputPortByName['command'].unbindWidget()
    Run_computeMSMS_24.inputPortByName['importString'].widget.set(r"", run=False)
    apply(Run_computeMSMS_24.inputPortByName['hdensity'].createWidget, (), {'descr':{'initialValue': 6.0, 'labelGridCfg': {'column': 0, 'row': 1, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 1}, 'labelCfg': {'text': 'hdensity'}, 'class': 'NEDial', 'oneTurn': 1}})
    Run_computeMSMS_24.inputPortByName['hdensity'].widget.set(6.0, run=False)
    apply(Run_computeMSMS_24.inputPortByName['hdset'].createWidget, (), {'descr':{'initialValue': 'None', 'labelGridCfg': {'column': 0, 'row': 3, 'sticky': 'w'}, 'width': 10, 'master': 'ParamPanel', 'widgetGridCfg': {'labelSide': 'left', 'column': 1, 'row': 3}, 'labelCfg': {'text': 'hdset'}, 'class': 'NEEntry'}})
    Run_computeMSMS_24.inputPortByName['hdset'].widget.set(r"None", run=False)
    apply(Run_computeMSMS_24.inputPortByName['topCommand'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 5, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 5}, 'labelCfg': {'text': 'topCommand'}, 'class': 'NECheckButton'}})
    Run_computeMSMS_24.inputPortByName['topCommand'].widget.set(1, run=False)
    apply(Run_computeMSMS_24.inputPortByName['setupUndo'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 7, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 7}, 'labelCfg': {'text': 'setupUndo'}, 'class': 'NECheckButton'}})
    Run_computeMSMS_24.inputPortByName['setupUndo'].widget.set(1, run=False)
    apply(Run_computeMSMS_24.inputPortByName['surfName'].createWidget, (), {'descr':{'initialValue': 'MSMS-MOL', 'labelGridCfg': {'column': 0, 'row': 9, 'sticky': 'w'}, 'width': 10, 'master': 'ParamPanel', 'widgetGridCfg': {'labelSide': 'left', 'column': 1, 'row': 9}, 'labelCfg': {'text': 'surfName'}, 'class': 'NEEntry'}})
    Run_computeMSMS_24.inputPortByName['surfName'].widget.set(r"MSMS-MOL", run=False)
    apply(Run_computeMSMS_24.inputPortByName['density'].createWidget, (), {'descr':{'initialValue': 3.0, 'labelGridCfg': {'column': 0, 'row': 11, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 11}, 'labelCfg': {'text': 'density'}, 'class': 'NEDial', 'oneTurn': 1}})
    Run_computeMSMS_24.inputPortByName['density'].widget.set(3.0, run=False)
    apply(Run_computeMSMS_24.inputPortByName['log'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 13, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 13}, 'labelCfg': {'text': 'log'}, 'class': 'NECheckButton'}})
    Run_computeMSMS_24.inputPortByName['log'].widget.set(1, run=False)
    apply(Run_computeMSMS_24.inputPortByName['perMol'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 15, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 15}, 'labelCfg': {'text': 'perMol'}, 'class': 'NECheckButton'}})
    Run_computeMSMS_24.inputPortByName['perMol'].widget.set(1, run=False)
    apply(Run_computeMSMS_24.inputPortByName['redraw'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 17, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 17}, 'labelCfg': {'text': 'redraw'}, 'class': 'NECheckButton'}})
    Run_computeMSMS_24.inputPortByName['redraw'].widget.set(1, run=False)
    apply(Run_computeMSMS_24.inputPortByName['display'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 19, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 19}, 'labelCfg': {'text': 'display'}, 'class': 'NECheckButton'}})
    Run_computeMSMS_24.inputPortByName['display'].widget.set(1, run=False)
    apply(Run_computeMSMS_24.inputPortByName['pRadius'].createWidget, (), {'descr':{'initialValue': 1.5, 'labelGridCfg': {'column': 0, 'row': 21, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 21}, 'labelCfg': {'text': 'pRadius'}, 'class': 'NEDial', 'oneTurn': 1}})
    Run_computeMSMS_24.inputPortByName['pRadius'].widget.set(1.5, run=False)
    apply(Run_computeMSMS_24.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
    from Pmv.VisionInterface.PmvNodes import PmvNode
    Pmv_25 = PmvNode(vf=masterNet.editor.vf, constrkw={'vf': 'masterNet.editor.vf'}, name='Pmv', library=pmvlib)
    ADTloadmolecule_18.macroNetwork.addNode(Pmv_25,586,162)
    apply(Pmv_25.configure, (), {'specialPortsVisible': True})
    Pmv_25.inputPortByName['cmdName'].widget.set(r"AD4gpf_readGPF", run=False)
    Pmv_25.inputPortByName['molecule'].widget.set(r"", run=False)
    apply(Pmv_25.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
    from Pmv.VisionInterface.PmvNodes import PmvRunCommand
    Run_AD4gpf_readGPF_26 = PmvRunCommand(command=masterNet.editor.vf.AD4gpf_readGPF, namedArgs={'topCommand': True, 'redraw': True, 'setupUndo': True, 'log': True}, posArgsNames=['gpffile'], constrkw={'command': 'masterNet.editor.vf.AD4gpf_readGPF', 'namedArgs': "{'topCommand': True, 'redraw': True, 'setupUndo': True, 'log': True}", 'posArgsNames': "['gpffile']"}, name='Run AD4gpf_readGPF', library=pmvlib)
    ADTloadmolecule_18.macroNetwork.addNode(Run_AD4gpf_readGPF_26,686,221)
    apply(Run_AD4gpf_readGPF_26.inputPortByName['command'].configure, (), {'datatype': 'PmvCmd', 'originalDatatype': 'None'})
    apply(Run_AD4gpf_readGPF_26.addInputPort, (), {'singleConnection': True, 'name': 'gpffile', 'cast': True, 'datatype': 'string', 'required': True, 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white', 'originalDatatype': 'None'})
    apply(Run_AD4gpf_readGPF_26.addInputPort, (), {'singleConnection': True, 'name': 'topCommand', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_AD4gpf_readGPF_26.addInputPort, (), {'singleConnection': True, 'name': 'redraw', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_AD4gpf_readGPF_26.addInputPort, (), {'singleConnection': True, 'name': 'setupUndo', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_AD4gpf_readGPF_26.addInputPort, (), {'singleConnection': True, 'name': 'log', 'cast': True, 'datatype': 'boolean', 'balloon': 'Defaults toTrue', 'required': False, 'height': 8, 'width': 12, 'shape': 'rect', 'color': 'yellow'})
    apply(Run_AD4gpf_readGPF_26.configure, (), {'specialPortsVisible': True})
    Run_AD4gpf_readGPF_26.inputPortByName['command'].rebindWidget()
    Run_AD4gpf_readGPF_26.inputPortByName['command'].widget.set(r"", run=False)
    Run_AD4gpf_readGPF_26.inputPortByName['command'].unbindWidget()
    Run_AD4gpf_readGPF_26.inputPortByName['importString'].widget.set(r"", run=False)
    apply(Run_AD4gpf_readGPF_26.inputPortByName['topCommand'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 3, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 3}, 'labelCfg': {'text': 'topCommand'}, 'class': 'NECheckButton'}})
    Run_AD4gpf_readGPF_26.inputPortByName['topCommand'].widget.set(1, run=False)
    apply(Run_AD4gpf_readGPF_26.inputPortByName['redraw'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 5, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 5}, 'labelCfg': {'text': 'redraw'}, 'class': 'NECheckButton'}})
    Run_AD4gpf_readGPF_26.inputPortByName['redraw'].widget.set(1, run=False)
    apply(Run_AD4gpf_readGPF_26.inputPortByName['setupUndo'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 7, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 7}, 'labelCfg': {'text': 'setupUndo'}, 'class': 'NECheckButton'}})
    Run_AD4gpf_readGPF_26.inputPortByName['setupUndo'].widget.set(1, run=False)
    apply(Run_AD4gpf_readGPF_26.inputPortByName['log'].createWidget, (), {'descr':{'initialValue': True, 'labelGridCfg': {'column': 0, 'row': 9, 'sticky': 'w'}, 'master': 'ParamPanel', 'widgetGridCfg': {'column': 1, 'labelSide': 'left', 'row': 9}, 'labelCfg': {'text': 'log'}, 'class': 'NECheckButton'}})
    Run_AD4gpf_readGPF_26.inputPortByName['log'].widget.set(1, run=False)
    apply(Run_AD4gpf_readGPF_26.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
    from Vision.StandardNodes import Eval
    eval__in1_replace______27 = Eval(constrkw={}, name='eval: in1.replace(-...', library=stdlib)
    ADTloadmolecule_18.macroNetwork.addNode(eval__in1_replace______27,348,192)
    eval__in1_replace______27.inputPortByName['command'].widget.set(r"in1.replace('-','_')", run=False)
    eval__in1_replace______27.inputPortByName['importString'].widget.set(r"", run=False)
    apply(eval__in1_replace______27.configure, (), {'paramPanelImmediate': 1})

    ## saving connections for network ADTloadmolecule ##
    ADTloadmolecule_18.macroNetwork.freeze()
    if Pmv_22 is not None and Run_readPDBQT_21 is not None:
        try:
            ADTloadmolecule_18.macroNetwork.connectNodes(
                Pmv_22, Run_readPDBQT_21, "cmd", "command", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between Pmv_22 and Run_readPDBQT_21 in network ADTloadmolecule_18.macroNetwork"
    if Pmv_23 is not None and Run_computeMSMS_24 is not None:
        try:
            ADTloadmolecule_18.macroNetwork.connectNodes(
                Pmv_23, Run_computeMSMS_24, "cmd", "command", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between Pmv_23 and Run_computeMSMS_24 in network ADTloadmolecule_18.macroNetwork"
    if Pmv_25 is not None and Run_AD4gpf_readGPF_26 is not None:
        try:
            ADTloadmolecule_18.macroNetwork.connectNodes(
                Pmv_25, Run_AD4gpf_readGPF_26, "cmd", "command", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between Pmv_25 and Run_AD4gpf_readGPF_26 in network ADTloadmolecule_18.macroNetwork"
    input_Ports_19 = ADTloadmolecule_18.macroNetwork.ipNode
    if input_Ports_19 is not None and Run_readPDBQT_21 is not None:
        try:
            ADTloadmolecule_18.macroNetwork.connectNodes(
                input_Ports_19, Run_readPDBQT_21, "new", "filename", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between input_Ports_19 and Run_readPDBQT_21 in network ADTloadmolecule_18.macroNetwork"
    if input_Ports_19 is not None and Run_AD4gpf_readGPF_26 is not None:
        try:
            ADTloadmolecule_18.macroNetwork.connectNodes(
                input_Ports_19, Run_AD4gpf_readGPF_26, "new", "gpffile", blocking=True
                , splitratio=[1.0, 0.47837837837837838])
        except:
            print "WARNING: failed to restore connection between input_Ports_19 and Run_AD4gpf_readGPF_26 in network ADTloadmolecule_18.macroNetwork"
    if Run_readPDBQT_21 is not None and Run_computeMSMS_24 is not None:
        try:
            ADTloadmolecule_18.macroNetwork.specialConnectNodes(
                Run_readPDBQT_21, Run_computeMSMS_24, "trigger", "runNode", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between Run_readPDBQT_21 and Run_computeMSMS_24 in network ADTloadmolecule_18.macroNetwork"
    if Run_computeMSMS_24 is not None and Run_AD4gpf_readGPF_26 is not None:
        try:
            ADTloadmolecule_18.macroNetwork.specialConnectNodes(
                Run_computeMSMS_24, Run_AD4gpf_readGPF_26, "trigger", "runNode", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between Run_computeMSMS_24 and Run_AD4gpf_readGPF_26 in network ADTloadmolecule_18.macroNetwork"
    if input_Ports_19 is not None and eval__in1_replace______27 is not None:
        try:
            ADTloadmolecule_18.macroNetwork.connectNodes(
                input_Ports_19, eval__in1_replace______27, "new", "in1", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between input_Ports_19 and eval__in1_replace______27 in network ADTloadmolecule_18.macroNetwork"
    if eval__in1_replace______27 is not None and Run_computeMSMS_24 is not None:
        try:
            ADTloadmolecule_18.macroNetwork.connectNodes(
                eval__in1_replace______27, Run_computeMSMS_24, "result", "nodes", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between eval__in1_replace______27 and Run_computeMSMS_24 in network ADTloadmolecule_18.macroNetwork"
    ADTloadmolecule_18.macroNetwork.unfreeze()
    ADTloadmolecule_18.shrink()
    apply(ADTloadmolecule_18.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore MacroNode named ADTloadmolecule in network masterNet"
    print_exc()
    ADTloadmolecule_18=None

try:
    ## saving node prepareGPF ##
    from NetworkEditor.macros import MacroNode
    prepareGPF_28 = MacroNode(name='prepareGPF')
    masterNet.addNode(prepareGPF_28, 82, 194)
    output_Ports_30 = prepareGPF_28.macroNetwork.opNode
    apply(output_Ports_30.configure, (), {'paramPanelImmediate': 1})
    output_Ports_30.move(78, 383)
    from WebServices.VisionInterface.WSNodes import DownloadNode
    Download_31 = DownloadNode(constrkw={}, name='Download', library=wslib)
    prepareGPF_28.macroNetwork.addNode(Download_31,95,247)
    Download_31.inputPortByName['url'].rebindWidget()
    Download_31.inputPortByName['url'].widget.set(r"", run=False)
    Download_31.inputPortByName['url'].unbindWidget()
    apply(Download_31.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import Split
    Split_32 = Split(constrkw={}, name='Split', library=stdlib)
    prepareGPF_28.macroNetwork.addNode(Split_32,95,184)
    apply(Split_32.addOutputPort, (), {'name': '3', 'datatype': 'None', 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    apply(Split_32.addOutputPort, (), {'name': '0', 'datatype': 'None', 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    apply(Split_32.addOutputPort, (), {'name': '1', 'datatype': 'None', 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    apply(Split_32.addOutputPort, (), {'name': '2', 'datatype': 'None', 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    code = """def doit(self, data):
    # we remove all the not connected output ports
    lOutputPorts = self.outputPorts[:]
    for port in lOutputPorts:
        if len(port.connections) == 0:
            self.deletePort(port)

    # we add all the missing output ports
    if data is not None and len(data) > 0:
        for lValueIndex in range(len(data)):
            lPortName = str(lValueIndex)
            for p in self.outputPorts:
                if p.name == lPortName:
                    break
            else: # we didn't break
                self.addOutputPort(name=lPortName)
            lPort = self.getOutputPortByName(lPortName)
            lPort.outputData(data[lValueIndex])
## to ouput data on port 3 use
## self.outputData(3=data)
## to ouput data on port 0 use
## self.outputData(0=data)
## to ouput data on port 1 use
## self.outputData(1=data)
## to ouput data on port 2 use
## self.outputData(2=data)
"""
    Split_32.configure(function=code)
    apply(Split_32.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import SaveLines
    Save_Lines_33 = SaveLines(constrkw={}, name='Save Lines', library=stdlib)
    prepareGPF_28.macroNetwork.addNode(Save_Lines_33,95,312)
    apply(Save_Lines_33.configure, (), {'specialPortsVisible': True})
    Save_Lines_33.inputPortByName['filename'].rebindWidget()
    Save_Lines_33.inputPortByName['filename'].widget.set(r"3ptb_rec.gpf", run=False)
    Save_Lines_33.inputPortByName['filename'].unbindWidget()
    apply(Save_Lines_33.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
    from NetworkEditor.items import FunctionNode
    prepareGPF_kryptonite_nbcr_net_34 = FunctionNode(functionOrString='prepareGPF_kryptonite_nbcr_net', host="http://kryptonite.nbcr.net/opal2", importString='', namedArgs={'lib': '', 'o': '', 'p': '', 'r': '', 'v': False, 'localRun': False, 'execPath': ''}, constrkw={'functionOrString': "'prepareGPF_kryptonite_nbcr_net'", 'host': '"http://kryptonite.nbcr.net/opal2"', 'importString': "''", 'namedArgs': {'lib': '', 'o': '', 'p': '', 'r': '', 'v': False, 'localRun': False, 'execPath': ''}}, name='prepareGPF_kryptonite_nbcr_net', library=wslib)
    prepareGPF_28.macroNetwork.addNode(prepareGPF_kryptonite_nbcr_net_34,101,124)
    prepareGPF_kryptonite_nbcr_net_34.inputPortByName['lib'].rebindWidget()
    prepareGPF_kryptonite_nbcr_net_34.inputPortByName['lib'].widget.set(r"sample", run=False)
    prepareGPF_kryptonite_nbcr_net_34.inputPortByName['lib'].unbindWidget()
    prepareGPF_kryptonite_nbcr_net_34.inputPortByName['o'].widget.set(r"", run=False)
    prepareGPF_kryptonite_nbcr_net_34.inputPortByName['p'].widget.set(r"", run=False)
    prepareGPF_kryptonite_nbcr_net_34.inputPortByName['r'].rebindWidget()
    prepareGPF_kryptonite_nbcr_net_34.inputPortByName['r'].widget.set(r"", run=False)
    prepareGPF_kryptonite_nbcr_net_34.inputPortByName['r'].unbindWidget()
    prepareGPF_kryptonite_nbcr_net_34.inputPortByName['v'].widget.set(0, run=False)
    prepareGPF_kryptonite_nbcr_net_34.inputPortByName['localRun'].widget.set(0, run=False)
    prepareGPF_kryptonite_nbcr_net_34.inputPortByName['execPath'].widget.set(r"", run=False)
    apply(prepareGPF_kryptonite_nbcr_net_34.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import Eval
    GPFFileName_35 = Eval(constrkw={}, name='GPFFileName', library=stdlib)
    prepareGPF_28.macroNetwork.addNode(GPFFileName_35,338,125)
    GPFFileName_35.inputPortByName['command'].widget.set(r"in1 + '.gpf'", run=False)
    GPFFileName_35.inputPortByName['importString'].widget.set(r"", run=False)
    apply(GPFFileName_35.configure, (), {'paramPanelImmediate': 1})

    ## saving connections for network prepareGPF ##
    prepareGPF_28.macroNetwork.freeze()
    if Download_31 is not None and Save_Lines_33 is not None:
        try:
            prepareGPF_28.macroNetwork.connectNodes(
                Download_31, Save_Lines_33, "output", "data", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between Download_31 and Save_Lines_33 in network prepareGPF_28.macroNetwork"
    if prepareGPF_kryptonite_nbcr_net_34 is not None and Split_32 is not None:
        try:
            prepareGPF_28.macroNetwork.connectNodes(
                prepareGPF_kryptonite_nbcr_net_34, Split_32, "result", "data", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between prepareGPF_kryptonite_nbcr_net_34 and Split_32 in network prepareGPF_28.macroNetwork"
    if Split_32 is not None and Download_31 is not None:
        try:
            prepareGPF_28.macroNetwork.connectNodes(
                Split_32, Download_31, "3", "url", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between Split_32 and Download_31 in network prepareGPF_28.macroNetwork"
    input_Ports_29 = prepareGPF_28.macroNetwork.ipNode
    if input_Ports_29 is not None and prepareGPF_kryptonite_nbcr_net_34 is not None:
        try:
            prepareGPF_28.macroNetwork.connectNodes(
                input_Ports_29, prepareGPF_kryptonite_nbcr_net_34, "new", "r", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between input_Ports_29 and prepareGPF_kryptonite_nbcr_net_34 in network prepareGPF_28.macroNetwork"
    output_Ports_30 = prepareGPF_28.macroNetwork.opNode
    if Save_Lines_33 is not None and output_Ports_30 is not None:
        try:
            prepareGPF_28.macroNetwork.connectNodes(
                Save_Lines_33, output_Ports_30, "filename", "new", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between Save_Lines_33 and output_Ports_30 in network prepareGPF_28.macroNetwork"
    if input_Ports_29 is not None and prepareGPF_kryptonite_nbcr_net_34 is not None:
        try:
            prepareGPF_28.macroNetwork.connectNodes(
                input_Ports_29, prepareGPF_kryptonite_nbcr_net_34, "new", "lib", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between input_Ports_29 and prepareGPF_kryptonite_nbcr_net_34 in network prepareGPF_28.macroNetwork"
    if input_Ports_29 is not None and GPFFileName_35 is not None:
        try:
            prepareGPF_28.macroNetwork.connectNodes(
                input_Ports_29, GPFFileName_35, "new", "in1", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between input_Ports_29 and GPFFileName_35 in network prepareGPF_28.macroNetwork"
    if GPFFileName_35 is not None and Save_Lines_33 is not None:
        try:
            prepareGPF_28.macroNetwork.connectNodes(
                GPFFileName_35, Save_Lines_33, "result", "filename", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between GPFFileName_35 and Save_Lines_33 in network prepareGPF_28.macroNetwork"
    prepareGPF_28.macroNetwork.unfreeze()
    prepareGPF_28.shrink()
    apply(prepareGPF_28.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore MacroNode named prepareGPF in network masterNet"
    print_exc()
    prepareGPF_28=None

try:
    ## saving node prepareReceptor ##
    from NetworkEditor.macros import MacroNode
    prepareReceptor_36 = MacroNode(name='prepareReceptor')
    masterNet.addNode(prepareReceptor_36, 17, 111)
    input_Ports_37 = prepareReceptor_36.macroNetwork.ipNode
    apply(input_Ports_37.configure, (), {'paramPanelImmediate': 1})
    input_Ports_37.move(94, 13)
    output_Ports_38 = prepareReceptor_36.macroNetwork.opNode
    apply(output_Ports_38.configure, (), {'paramPanelImmediate': 1})
    output_Ports_38.move(288, 652)
    from NetworkEditor.items import FunctionNode
    Pdb2pqrOpalService_ws_nbcr_net_39 = FunctionNode(functionOrString='Pdb2pqrOpalService_ws_nbcr_net', host="http://ws.nbcr.net/opal", importString='', namedArgs={'noopt': False, 'phi': False, 'psi': False, 'verbose': True, 'chain': False, 'nodebump': False, 'chi': False, 'output_file': '', 'ligand': '', 'hbond': False, 'inFile': '', 'with_ph': '', 'forcefield': 'AMBER', 'clean': False, 'inId': '', 'apbs_input': False, 'ffout': '', 'localRun': False, 'rama': False, 'execPath': '', 'assign_only': False}, constrkw={'functionOrString': "'Pdb2pqrOpalService_ws_nbcr_net'", 'host': '"http://ws.nbcr.net/opal"', 'importString': "''", 'namedArgs': {'noopt': False, 'phi': False, 'psi': False, 'verbose': True, 'chain': False, 'nodebump': False, 'chi': False, 'output_file': '', 'ligand': '', 'hbond': False, 'inFile': '', 'with_ph': '', 'forcefield': 'AMBER', 'clean': False, 'inId': '', 'apbs_input': False, 'ffout': '', 'localRun': False, 'rama': False, 'execPath': '', 'assign_only': False}}, name='Pdb2pqrOpalService_ws_nbcr_net', library=wslib)
    prepareReceptor_36.macroNetwork.addNode(Pdb2pqrOpalService_ws_nbcr_net_39,70,169)
    Pdb2pqrOpalService_ws_nbcr_net_39.inputPortByName['noopt'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_39.inputPortByName['phi'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_39.inputPortByName['psi'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_39.inputPortByName['verbose'].widget.set(1, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_39.inputPortByName['chain'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_39.inputPortByName['nodebump'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_39.inputPortByName['chi'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_39.inputPortByName['output_file'].rebindWidget()
    Pdb2pqrOpalService_ws_nbcr_net_39.inputPortByName['output_file'].widget.set(r"", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_39.inputPortByName['output_file'].unbindWidget()
    Pdb2pqrOpalService_ws_nbcr_net_39.inputPortByName['ligand'].widget.set(r"", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_39.inputPortByName['hbond'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_39.inputPortByName['inFile'].rebindWidget()
    Pdb2pqrOpalService_ws_nbcr_net_39.inputPortByName['inFile'].widget.set(r"", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_39.inputPortByName['inFile'].unbindWidget()
    Pdb2pqrOpalService_ws_nbcr_net_39.inputPortByName['with_ph'].widget.set(r"6.5", run=False)
    apply(Pdb2pqrOpalService_ws_nbcr_net_39.inputPortByName['forcefield'].widget.configure, (), {'choices': ('AMBER', 'CHARMM', 'PARSE', 'TYL06')})
    Pdb2pqrOpalService_ws_nbcr_net_39.inputPortByName['forcefield'].widget.set(r"AMBER", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_39.inputPortByName['clean'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_39.inputPortByName['inId'].widget.set(r"", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_39.inputPortByName['apbs_input'].widget.set(0, run=False)
    apply(Pdb2pqrOpalService_ws_nbcr_net_39.inputPortByName['ffout'].widget.configure, (), {'choices': ('AMBER', 'CHARMM', 'PARSE', 'TYL06')})
    Pdb2pqrOpalService_ws_nbcr_net_39.inputPortByName['ffout'].widget.set(r"AMBER", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_39.inputPortByName['localRun'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_39.inputPortByName['rama'].widget.set(0, run=False)
    Pdb2pqrOpalService_ws_nbcr_net_39.inputPortByName['execPath'].widget.set(r"", run=False)
    Pdb2pqrOpalService_ws_nbcr_net_39.inputPortByName['assign_only'].widget.set(0, run=False)
    apply(Pdb2pqrOpalService_ws_nbcr_net_39.configure, (), {'paramPanelImmediate': 1})
    from NetworkEditor.items import FunctionNode
    PrepareReceptorOpalService_ws_nbcr_net_40 = FunctionNode(functionOrString='PrepareReceptorOpalService_ws_nbcr_net', host="http://ws.nbcr.net/opal", importString='', namedArgs={'C': False, 'o': '', 'r': '', 'v': False, 'localRun': False, 'execPath': '/home/clem/MGLTools-1.5.1/bin/pythonsh'}, constrkw={'functionOrString': "'PrepareReceptorOpalService_ws_nbcr_net'", 'host': '"http://ws.nbcr.net/opal"', 'importString': "''", 'namedArgs': {'C': False, 'o': '', 'r': '', 'v': False, 'localRun': False, 'execPath': '/home/clem/MGLTools-1.5.1/bin/pythonsh'}}, name='PrepareReceptorOpalService_ws_nbcr_net', library=wslib)
    prepareReceptor_36.macroNetwork.addNode(PrepareReceptorOpalService_ws_nbcr_net_40,128,414)
    PrepareReceptorOpalService_ws_nbcr_net_40.inputPortByName['C'].widget.set(0, run=False)
    PrepareReceptorOpalService_ws_nbcr_net_40.inputPortByName['o'].widget.set(r"", run=False)
    PrepareReceptorOpalService_ws_nbcr_net_40.inputPortByName['r'].rebindWidget()
    PrepareReceptorOpalService_ws_nbcr_net_40.inputPortByName['r'].widget.set(r"", run=False)
    PrepareReceptorOpalService_ws_nbcr_net_40.inputPortByName['r'].unbindWidget()
    PrepareReceptorOpalService_ws_nbcr_net_40.inputPortByName['v'].widget.set(0, run=False)
    PrepareReceptorOpalService_ws_nbcr_net_40.inputPortByName['localRun'].widget.set(0, run=False)
    PrepareReceptorOpalService_ws_nbcr_net_40.inputPortByName['execPath'].widget.set(r"", run=False)
    apply(PrepareReceptorOpalService_ws_nbcr_net_40.configure, (), {'paramPanelImmediate': 1})
    from WebServices.VisionInterface.WSNodes import DownloadNode
    Download_41 = DownloadNode(constrkw={}, name='Download', library=wslib)
    prepareReceptor_36.macroNetwork.addNode(Download_41,70,293)
    Download_41.inputPortByName['url'].rebindWidget()
    Download_41.inputPortByName['url'].widget.set(r"", run=False)
    Download_41.inputPortByName['url'].unbindWidget()
    apply(Download_41.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import SaveLines
    Save_Lines_42 = SaveLines(constrkw={}, name='Save Lines', library=stdlib)
    prepareReceptor_36.macroNetwork.addNode(Save_Lines_42,128,352)
    Save_Lines_42.inputPortByName['filename'].rebindWidget()
    Save_Lines_42.inputPortByName['filename'].widget.set(r"", run=False)
    Save_Lines_42.inputPortByName['filename'].unbindWidget()
    apply(Save_Lines_42.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import Eval
    output_file_name_43 = Eval(constrkw={}, name='output_file_name', library=stdlib)
    prepareReceptor_36.macroNetwork.addNode(output_file_name_43,143,105)
    apply(output_file_name_43.inputPortByName['in1'].configure, (), {'datatype': 'string', 'originalDatatype': 'None'})
    output_file_name_43.inputPortByName['command'].widget.set(r"(os.path.basename(in1)).replace('.pdb','.pqr')", run=False)
    output_file_name_43.inputPortByName['importString'].widget.set(r"os", run=False)
    apply(output_file_name_43.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import Generic
    get_PQR_file_44 = Generic(constrkw={}, name='get_PQR_file', library=stdlib)
    prepareReceptor_36.macroNetwork.addNode(get_PQR_file_44,70,228)
    apply(get_PQR_file_44.addInputPort, (), {'singleConnection': True, 'name': 'in1', 'cast': True, 'datatype': 'None', 'required': True, 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    apply(get_PQR_file_44.addOutputPort, (), {'name': 'out1', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    apply(get_PQR_file_44.configure, (), {'specialPortsVisible': True})
    code = """def doit(self, in1):
    for i in in1:
        if i.endswith('.pqr'):
            self.outputData(out1=i)
            return

## to ouput data on port out1 use
## self.outputData(out1=data)

"""
    get_PQR_file_44.configure(function=code)
    apply(get_PQR_file_44.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
    from Vision.StandardNodes import Generic
    get_PQR_file_45 = Generic(constrkw={}, name='get_PQR_file', library=stdlib)
    prepareReceptor_36.macroNetwork.addNode(get_PQR_file_45,128,470)
    apply(get_PQR_file_45.addInputPort, (), {'singleConnection': True, 'name': 'in1', 'cast': True, 'datatype': 'None', 'required': True, 'height': 8, 'width': 12, 'shape': 'diamond', 'color': 'white'})
    apply(get_PQR_file_45.addOutputPort, (), {'name': 'out1', 'datatype': 'string', 'height': 8, 'width': 12, 'shape': 'oval', 'color': 'white'})
    apply(get_PQR_file_45.configure, (), {'specialPortsVisible': True})
    code = """def doit(self, in1):
    for i in in1:
        if i.endswith('.pdbqt'):
            self.outputData(out1=i)
            return

## to ouput data on port out1 use
## self.outputData(out1=data)


"""
    get_PQR_file_45.configure(function=code)
    apply(get_PQR_file_45.configure, (), {'specialPortsVisible': True, 'paramPanelImmediate': 1})
    from WebServices.VisionInterface.WSNodes import DownloadNode
    Download_46 = DownloadNode(constrkw={}, name='Download', library=wslib)
    prepareReceptor_36.macroNetwork.addNode(Download_46,129,530)
    Download_46.inputPortByName['url'].rebindWidget()
    Download_46.inputPortByName['url'].widget.set(r"", run=False)
    Download_46.inputPortByName['url'].unbindWidget()
    apply(Download_46.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import SaveLines
    Save_Lines_47 = SaveLines(constrkw={}, name='Save Lines', library=stdlib)
    prepareReceptor_36.macroNetwork.addNode(Save_Lines_47,195,593)
    Save_Lines_47.inputPortByName['filename'].rebindWidget()
    Save_Lines_47.inputPortByName['filename'].widget.set(r"", run=False)
    Save_Lines_47.inputPortByName['filename'].unbindWidget()
    apply(Save_Lines_47.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import Eval
    Molecule_basename_48 = Eval(constrkw={}, name='Molecule_basename', library=stdlib)
    prepareReceptor_36.macroNetwork.addNode(Molecule_basename_48,222,529)
    apply(Molecule_basename_48.inputPortByName['in1'].configure, (), {'datatype': 'string', 'originalDatatype': 'None'})
    Molecule_basename_48.inputPortByName['command'].widget.set(r"os.path.basename(in1)", run=False)
    Molecule_basename_48.inputPortByName['importString'].widget.set(r"os", run=False)
    apply(Molecule_basename_48.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import Eval
    moleculeName_49 = Eval(constrkw={}, name='moleculeName', library=stdlib)
    prepareReceptor_36.macroNetwork.addNode(moleculeName_49,322,91)
    moleculeName_49.inputPortByName['command'].widget.set(r"in1.rstrip('.pdb')", run=False)
    moleculeName_49.inputPortByName['importString'].widget.set(r"", run=False)
    apply(moleculeName_49.configure, (), {'paramPanelImmediate': 1, 'expanded': True})

    ## saving connections for network prepareReceptor ##
    prepareReceptor_36.macroNetwork.freeze()
    if Download_41 is not None and Save_Lines_42 is not None:
        try:
            prepareReceptor_36.macroNetwork.connectNodes(
                Download_41, Save_Lines_42, "output", "data", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between Download_41 and Save_Lines_42 in network prepareReceptor_36.macroNetwork"
    if Save_Lines_42 is not None and PrepareReceptorOpalService_ws_nbcr_net_40 is not None:
        try:
            prepareReceptor_36.macroNetwork.connectNodes(
                Save_Lines_42, PrepareReceptorOpalService_ws_nbcr_net_40, "filename", "r", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between Save_Lines_42 and PrepareReceptorOpalService_ws_nbcr_net_40 in network prepareReceptor_36.macroNetwork"
    if output_file_name_43 is not None and Pdb2pqrOpalService_ws_nbcr_net_39 is not None:
        try:
            prepareReceptor_36.macroNetwork.connectNodes(
                output_file_name_43, Pdb2pqrOpalService_ws_nbcr_net_39, "result", "output_file", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between output_file_name_43 and Pdb2pqrOpalService_ws_nbcr_net_39 in network prepareReceptor_36.macroNetwork"
    if output_file_name_43 is not None and Save_Lines_42 is not None:
        try:
            prepareReceptor_36.macroNetwork.connectNodes(
                output_file_name_43, Save_Lines_42, "result", "filename", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between output_file_name_43 and Save_Lines_42 in network prepareReceptor_36.macroNetwork"
    if Pdb2pqrOpalService_ws_nbcr_net_39 is not None and get_PQR_file_44 is not None:
        try:
            prepareReceptor_36.macroNetwork.connectNodes(
                Pdb2pqrOpalService_ws_nbcr_net_39, get_PQR_file_44, "result", "in1", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between Pdb2pqrOpalService_ws_nbcr_net_39 and get_PQR_file_44 in network prepareReceptor_36.macroNetwork"
    if get_PQR_file_44 is not None and Download_41 is not None:
        try:
            prepareReceptor_36.macroNetwork.connectNodes(
                get_PQR_file_44, Download_41, "out1", "url", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between get_PQR_file_44 and Download_41 in network prepareReceptor_36.macroNetwork"
    if PrepareReceptorOpalService_ws_nbcr_net_40 is not None and get_PQR_file_45 is not None:
        try:
            prepareReceptor_36.macroNetwork.connectNodes(
                PrepareReceptorOpalService_ws_nbcr_net_40, get_PQR_file_45, "result", "in1", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between PrepareReceptorOpalService_ws_nbcr_net_40 and get_PQR_file_45 in network prepareReceptor_36.macroNetwork"
    if Download_46 is not None and Save_Lines_47 is not None:
        try:
            prepareReceptor_36.macroNetwork.connectNodes(
                Download_46, Save_Lines_47, "output", "data", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between Download_46 and Save_Lines_47 in network prepareReceptor_36.macroNetwork"
    if get_PQR_file_45 is not None and Download_46 is not None:
        try:
            prepareReceptor_36.macroNetwork.connectNodes(
                get_PQR_file_45, Download_46, "out1", "url", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between get_PQR_file_45 and Download_46 in network prepareReceptor_36.macroNetwork"
    if get_PQR_file_45 is not None and Molecule_basename_48 is not None:
        try:
            prepareReceptor_36.macroNetwork.connectNodes(
                get_PQR_file_45, Molecule_basename_48, "out1", "in1", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between get_PQR_file_45 and Molecule_basename_48 in network prepareReceptor_36.macroNetwork"
    if Molecule_basename_48 is not None and Save_Lines_47 is not None:
        try:
            prepareReceptor_36.macroNetwork.connectNodes(
                Molecule_basename_48, Save_Lines_47, "result", "filename", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between Molecule_basename_48 and Save_Lines_47 in network prepareReceptor_36.macroNetwork"
    input_Ports_37 = prepareReceptor_36.macroNetwork.ipNode
    if input_Ports_37 is not None and output_file_name_43 is not None:
        try:
            prepareReceptor_36.macroNetwork.connectNodes(
                input_Ports_37, output_file_name_43, "new", "in1", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between input_Ports_37 and output_file_name_43 in network prepareReceptor_36.macroNetwork"
    output_Ports_38 = prepareReceptor_36.macroNetwork.opNode
    if Save_Lines_47 is not None and output_Ports_38 is not None:
        try:
            prepareReceptor_36.macroNetwork.connectNodes(
                Save_Lines_47, output_Ports_38, "filename", "new", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between Save_Lines_47 and output_Ports_38 in network prepareReceptor_36.macroNetwork"
    if input_Ports_37 is not None and Pdb2pqrOpalService_ws_nbcr_net_39 is not None:
        try:
            prepareReceptor_36.macroNetwork.connectNodes(
                input_Ports_37, Pdb2pqrOpalService_ws_nbcr_net_39, "output_file_name_in1", "inFile", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between input_Ports_37 and Pdb2pqrOpalService_ws_nbcr_net_39 in network prepareReceptor_36.macroNetwork"
    if input_Ports_37 is not None and moleculeName_49 is not None:
        try:
            prepareReceptor_36.macroNetwork.connectNodes(
                input_Ports_37, moleculeName_49, "output_file_name_in1", "in1", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between input_Ports_37 and moleculeName_49 in network prepareReceptor_36.macroNetwork"
    if moleculeName_49 is not None and output_Ports_38 is not None:
        try:
            prepareReceptor_36.macroNetwork.connectNodes(
                moleculeName_49, output_Ports_38, "result", "new", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between moleculeName_49 and output_Ports_38 in network prepareReceptor_36.macroNetwork"
    prepareReceptor_36.macroNetwork.unfreeze()
    prepareReceptor_36.shrink()
    apply(prepareReceptor_36.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore MacroNode named prepareReceptor in network masterNet"
    print_exc()
    prepareReceptor_36=None

try:
    ## saving node LibraryName ##
    from Vision.StandardNodes import ComboBoxNE
    LibraryName_50 = ComboBoxNE(constrkw={}, name='LibraryName', library=stdlib)
    masterNet.addNode(LibraryName_50,315,77)
    apply(LibraryName_50.inputPortByName['selection'].widget.configure, (), {'choices': ['sample', 'NCIDiversity']})
    LibraryName_50.inputPortByName['selection'].widget.set(r"sample", run=False)
    apply(LibraryName_50.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore ComboBoxNE named LibraryName in network masterNet"
    print_exc()
    LibraryName_50=None

try:
    ## saving node Available Libraries ##
    from Vision.StandardNodes import Eval
    Available_Libraries_51 = Eval(constrkw={}, name='Available Libraries', library=stdlib)
    masterNet.addNode(Available_Libraries_51,314,20)
    Available_Libraries_51.inputPortByName['command'].widget.set(r"['sample', 'NCIDiversity', 'NCIDS_SC']", run=False)
    Available_Libraries_51.inputPortByName['importString'].widget.set(r"", run=False)
    apply(Available_Libraries_51.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore Eval named Available Libraries in network masterNet"
    print_exc()
    Available_Libraries_51=None

#masterNet.run()
masterNet.freeze()

## saving connections for network ScreeningADT ##
autogrid_12 = masterNet.nodes[4]
autodock_screening_3 = masterNet.nodes[3]
if autogrid_12 is not None and autodock_screening_3 is not None:
    try:
        masterNet.connectNodes(
            autogrid_12, autodock_screening_3, "eval: in1+/.._result", "autodock_kryptonite_nbcr_net_u", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between autogrid_12 and autodock_screening_3 in network masterNet"
prepareGPF_28 = masterNet.nodes[6]
ADTloadmolecule_18 = masterNet.nodes[5]
if prepareGPF_28 is not None and ADTloadmolecule_18 is not None:
    try:
        masterNet.connectNodes(
            prepareGPF_28, ADTloadmolecule_18, "Save Lines_filename", "Run AD4gpf_readGPF_gpffile", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between prepareGPF_28 and ADTloadmolecule_18 in network masterNet"
prepareReceptor_36 = masterNet.nodes[7]
if prepareReceptor_36 is not None and prepareGPF_28 is not None:
    try:
        masterNet.connectNodes(
            prepareReceptor_36, prepareGPF_28, "Save Lines_filename", "prepareGPF_kryptonite_nbcr_net_r", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between prepareReceptor_36 and prepareGPF_28 in network masterNet"
if prepareReceptor_36 is not None and ADTloadmolecule_18 is not None:
    try:
        masterNet.connectNodes(
            prepareReceptor_36, ADTloadmolecule_18, "Save Lines_filename", "Run readPDBQT_filename", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between prepareReceptor_36 and ADTloadmolecule_18 in network masterNet"
if Receptor_File_0 is not None and prepareReceptor_36 is not None:
    try:
        masterNet.connectNodes(
            Receptor_File_0, prepareReceptor_36, "filename", "output_file_name_in1", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Receptor_File_0 and prepareReceptor_36 in network masterNet"
if prepareReceptor_36 is not None and ReceptorPDBQT_1 is not None:
    try:
        masterNet.connectNodes(
            prepareReceptor_36, ReceptorPDBQT_1, "Save Lines_filename", "filename", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between prepareReceptor_36 and ReceptorPDBQT_1 in network masterNet"
if prepareGPF_28 is not None and GPFFile_2 is not None:
    try:
        masterNet.connectNodes(
            prepareGPF_28, GPFFile_2, "Save Lines_filename", "filename", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between prepareGPF_28 and GPFFile_2 in network masterNet"
if Available_Libraries_51 is not None and LibraryName_50 is not None:
    try:
        masterNet.connectNodes(
            Available_Libraries_51, LibraryName_50, "result", "valueList", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Available_Libraries_51 and LibraryName_50 in network masterNet"
if LibraryName_50 is not None and prepareGPF_28 is not None:
    try:
        masterNet.connectNodes(
            LibraryName_50, prepareGPF_28, "selection", "prepareGPF_kryptonite_nbcr_net_lib", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between LibraryName_50 and prepareGPF_28 in network masterNet"
if LibraryName_50 is not None and autodock_screening_3 is not None:
    try:
        masterNet.connectNodes(
            LibraryName_50, autodock_screening_3, "selection", "autodock_kryptonite_nbcr_net_lib", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between LibraryName_50 and autodock_screening_3 in network masterNet"
if ReceptorPDBQT_1 is not None and autogrid_12 is not None:
    try:
        masterNet.connectNodes(
            ReceptorPDBQT_1, autogrid_12, "filename", "autogrid_kryptonite_nbcr_net_inFile", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between ReceptorPDBQT_1 and autogrid_12 in network masterNet"
if GPFFile_2 is not None and autogrid_12 is not None:
    try:
        masterNet.connectNodes(
            GPFFile_2, autogrid_12, "filename", "autogrid_kryptonite_nbcr_net_p", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between GPFFile_2 and autogrid_12 in network masterNet"
if prepareReceptor_36 is not None and prepareGPF_28 is not None:
    try:
        masterNet.connectNodes(
            prepareReceptor_36, prepareGPF_28, "moleculeName_result", "GPFFileName_in1", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between prepareReceptor_36 and prepareGPF_28 in network masterNet"
if prepareReceptor_36 is not None and ADTloadmolecule_18 is not None:
    try:
        masterNet.connectNodes(
            prepareReceptor_36, ADTloadmolecule_18, "moleculeName_result", "eval: in1.replace(-..._in1", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between prepareReceptor_36 and ADTloadmolecule_18 in network masterNet"
masterNet.runOnNewData.value = True

if __name__=='__main__':
    from sys import argv

    if '-h' in argv: # show help
        argv.remove('-h')
        masterNet.helpForNetworkAsApplication(locals())

    elif '-w' in argv: # run without Vision and exit
        argv.remove('-w')
        masterNet.handleCmdLineArgs(argv[1:], locals())

 	# create communicator
        from NetworkEditor.net import Communicator
        masterNet.communicator = Communicator(masterNet)
        print 'Communicator listening on port:', masterNet.communicator.port

        import socket
        f = open(argv[0]+'.sock', 'w')
        f.write("%s %i"%(socket.gethostbyname(socket.gethostname()),
                         masterNet.communicator.port))
        f.close()

## 	# create communication socket
## 	import socket

## 	HOST = ''                 # Symbolic name meaning the local host
## 	PORT = 50010              # Arbitrary non-privileged port
## 	s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
## 	s.bind((HOST, PORT))
## 	s.listen(5)
## 	s.setblocking(0)
## 	masterNet.socket = s
## 	masterNet.socketConnections = []
##         masterNet.HOST = HOST
##         masterNet.PORT = PORT

        masterNet.run()

    else: # stand alone application while vision is hidden
        if '-e' in argv: # run and exit
            argv.remove('-e')
            masterNet.run()
        elif '-r' in argv: # run
            argv.remove('-r')
            masterNet.run()
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)
        elif len(masterNet.userPanels) == 0: # no user panel => run
            masterNet.run()
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)
        else: # user panel
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

