#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Thursday 07 August 2008 12:58:12 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Tutorial/cartoon/cartoon0b_net.py,v 1.1 2008/08/08 01:35:56 vareille Exp $
#
# $Id: cartoon0b_net.py,v 1.1 2008/08/08 01:35:56 vareille Exp $
#

from traceback import print_exc

## loading libraries ##
from Vision.PILNodes import imagelib
from Vision.StandardNodes import stdlib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

if __name__!='__main__' or withoutVision is False:
    pass
    masterNet.getEditor().addLibraryInstance(imagelib,"Vision.PILNodes", "imagelib")

    masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

try:
    ## saving node Show Image ##
    from Vision.PILNodes import ShowImage
    Show_Image_6 = ShowImage(constrkw={}, name='Show Image', library=imagelib)
    masterNet.addNode(Show_Image_6,36,318)
    apply(Show_Image_6.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore ShowImage named Show Image in network masterNet"
    print_exc()
    Show_Image_6=None

try:
    ## saving node Scale ##
    from Vision.PILNodes import ResizeImage
    Scale_7 = ResizeImage(constrkw={}, name='Scale', library=imagelib)
    masterNet.addNode(Scale_7,36,269)
    Scale_7.inputPortByName['scale'].widget.set(1.0, run=False)
    Scale_7.inputPortByName['filter'].widget.set("NEAREST", run=False)
    apply(Scale_7.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore ResizeImage named Scale in network masterNet"
    print_exc()
    Scale_7=None

try:
    ## saving node Read Image ##
    from Vision.PILNodes import ReadImage
    Read_Image_8 = ReadImage(constrkw={}, name='Read Image', library=imagelib)
    masterNet.addNode(Read_Image_8,36,218)
    apply(Read_Image_8.inputPortByName['filename'].configure, (), {'datatype': 'string', 'originalDatatype': 'str'})
    Read_Image_8.inputPortByName['filename'].rebindWidget()
    Read_Image_8.inputPortByName['filename'].widget.set("cartoonMovie/crnCartoon0000.png", run=False)
    Read_Image_8.inputPortByName['filename'].unbindWidget()
    apply(Read_Image_8.configure, (), {'paramPanelImmediate': 1, 'expanded': True})
except:
    print "WARNING: failed to restore ReadImage named Read Image in network masterNet"
    print_exc()
    Read_Image_8=None

try:
    ## saving node Filename ##
    from Vision.StandardNodes import Filename
    Filename_9 = Filename(constrkw={}, name='Filename', library=stdlib)
    masterNet.addNode(Filename_9,36,135)
    Filename_9.inputPortByName['format'].widget.set("cartoonMovie/crnCartoon%04d.png", run=False)
    apply(Filename_9.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore Filename named Filename in network masterNet"
    print_exc()
    Filename_9=None

try:
    ## saving node DialInt ##
    from Vision.StandardNodes import DialIntNE
    DialInt_10 = DialIntNE(constrkw={}, name='DialInt', library=stdlib)
    masterNet.addNode(DialInt_10,36,11)
    DialInt_10.inputPortByName['dial'].widget.set(6, run=False)
    apply(DialInt_10.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore DialIntNE named DialInt in network masterNet"
    print_exc()
    DialInt_10=None

#masterNet.run()
masterNet.freeze()

## saving connections for network cartoon0 ##
if Read_Image_8 is not None and Scale_7 is not None:
    try:
        masterNet.connectNodes(
            Read_Image_8, Scale_7, "image", "image", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Read_Image_8 and Scale_7 in network masterNet"
if Scale_7 is not None and Show_Image_6 is not None:
    try:
        masterNet.connectNodes(
            Scale_7, Show_Image_6, "scaledImage", "image", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Scale_7 and Show_Image_6 in network masterNet"
if Filename_9 is not None and Read_Image_8 is not None:
    try:
        masterNet.connectNodes(
            Filename_9, Read_Image_8, "filename", "filename", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Filename_9 and Read_Image_8 in network masterNet"
if DialInt_10 is not None and Filename_9 is not None:
    try:
        masterNet.connectNodes(
            DialInt_10, Filename_9, "value", "number", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between DialInt_10 and Filename_9 in network masterNet"
masterNet.runOnNewData.value = True

if __name__=='__main__':
    from sys import argv
    if withoutVision is True: # run without Vision
        masterNet.handleCmdLineArgs(argv[1:], locals())
    else: # run as a stand alone application while vision is hidden
        mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

