########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Wednesday 29 August 2007 12:51:16 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Tutorial/cartoon/cartoon1_net.py,v 1.4 2007/08/29 20:37:16 vareille Exp $
#
# $Id: cartoon1_net.py,v 1.4 2007/08/29 20:37:16 vareille Exp $
#

from traceback import print_exc
## loading libraries ##
from Vision.PILNodes import imagelib
masterNet.getEditor().addLibraryInstance(imagelib,"Vision.PILNodes", "imagelib")

from Vision.StandardNodes import stdlib
masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

try:
    ## saving node Show Image ##
    from Vision.PILNodes import ShowImage
    Show_Image_0 = ShowImage(constrkw = {}, name='Show Image', library=imagelib)
    masterNet.addNode(Show_Image_0,20,342)
except:
    print "WARNING: failed to restore ShowImage named Show Image in network masterNet"
    print_exc()
    Show_Image_0=None

try:
    ## saving node Scale ##
    from Vision.PILNodes import ResizeImage
    Scale_1 = ResizeImage(constrkw = {}, name='Scale', library=imagelib)
    masterNet.addNode(Scale_1,16,285)
except:
    print "WARNING: failed to restore ResizeImage named Scale in network masterNet"
    print_exc()
    Scale_1=None

try:
    ## saving node Read Image ##
    from Vision.PILNodes import ReadImage
    Read_Image_2 = ReadImage(constrkw = {}, name='Read Image', library=imagelib)
    masterNet.addNode(Read_Image_2,15,226)
    apply(Read_Image_2.inputPortByName['filename'].configure, (), {'datatype': 'string', 'originalDatatype': 'str'})
    Read_Image_2.inputPortByName['filename'].widget.set("/home/vareille/dev/Data/crnCartoon0000_movie/crnCartoon0000.png", run=False)
    Read_Image_2.inputPortByName['filename'].unbindWidget()
except:
    print "WARNING: failed to restore ReadImage named Read Image in network masterNet"
    print_exc()
    Read_Image_2=None

try:
    ## saving node Filename ##
    from Vision.StandardNodes import Filename
    Filename_3 = Filename(constrkw = {}, name='Filename', library=stdlib)
    masterNet.addNode(Filename_3,13,136)
    Filename_3.inputPortByName['format'].widget.set("cartoonMovie/crnCartoon%04d.png", run=False)
except:
    print "WARNING: failed to restore Filename named Filename in network masterNet"
    print_exc()
    Filename_3=None

try:
    ## saving node iterate ##
    from Vision.StandardNodes import Iterate
    iterate_4 = Iterate(constrkw = {}, name='iterate', library=stdlib)
    masterNet.addNode(iterate_4,13,77)
except:
    print "WARNING: failed to restore Iterate named iterate in network masterNet"
    print_exc()
    iterate_4=None

try:
    ## saving node range ##
    from Vision.StandardNodes import Range
    range_5 = Range(constrkw = {}, name='range', library=stdlib)
    masterNet.addNode(range_5,18,23)
    apply(range_5.inputPortByName['toInd'].widget.configure, (), {'increment': None})
    range_5.inputPortByName['toInd'].widget.set(99, run=False)
except:
    print "WARNING: failed to restore Range named range in network masterNet"
    print_exc()
    range_5=None

masterNet.run()
masterNet.freeze()

## saving connections for network cartoon1 ##
if Read_Image_2 is not None and Scale_1 is not None:
    try:
        masterNet.connectNodes(
            Read_Image_2, Scale_1, "image", "image", blocking=True)
    except:
        print "WARNING: failed to restore connection between Read_Image_2 and Scale_1 in network masterNet"
if Scale_1 is not None and Show_Image_0 is not None:
    try:
        masterNet.connectNodes(
            Scale_1, Show_Image_0, "scaledImage", "image", blocking=True)
    except:
        print "WARNING: failed to restore connection between Scale_1 and Show_Image_0 in network masterNet"
if Filename_3 is not None and Read_Image_2 is not None:
    try:
        masterNet.connectNodes(
            Filename_3, Read_Image_2, "filename", "filename", blocking=True)
    except:
        print "WARNING: failed to restore connection between Filename_3 and Read_Image_2 in network masterNet"
if iterate_4 is not None and Filename_3 is not None:
    try:
        masterNet.connectNodes(
            iterate_4, Filename_3, "iter", "number", blocking=True)
    except:
        print "WARNING: failed to restore connection between iterate_4 and Filename_3 in network masterNet"
if range_5 is not None and iterate_4 is not None:
    try:
        masterNet.connectNodes(
            range_5, iterate_4, "data", "listToLoopOver", blocking=True)
    except:
        print "WARNING: failed to restore connection between range_5 and iterate_4 in network masterNet"
masterNet.unfreeze()

#masterNet.run()
