#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Thursday 07 August 2008 16:17:16 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Tutorial/cartoon/cartoon2c_net.py,v 1.1 2008/08/08 01:35:56 vareille Exp $
#
# $Id: cartoon2c_net.py,v 1.1 2008/08/08 01:35:56 vareille Exp $
#


if __name__=='__main__':
    from sys import argv
    if "-w" in argv: # run without Vision
        withoutVision = True
        argv.remove('-w')
        from NetworkEditor.net import Network
        masterNet = Network()
    else: # run as a stand alone application while vision is hidden
        withoutVision = False
        from Vision import launchVisionToRunNetworkAsApplication, mainLoopVisionToRunNetworkAsApplication
        masterNet = launchVisionToRunNetworkAsApplication()
        import os
        masterNet.filename = os.path.abspath(__file__)
from traceback import print_exc
masterNet.createUserPanel('MyApp' ,width=191, height=248)

## loading libraries ##
from Vision.PILNodes import imagelib
from Vision.StandardNodes import stdlib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

if __name__!='__main__' or withoutVision is False:
    pass
    masterNet.getEditor().addLibraryInstance(imagelib,"Vision.PILNodes", "imagelib")

    masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

try:
    ## saving node Filelist ##
    from Vision.StandardNodes import Filelist
    Filelist_67 = Filelist(constrkw={}, name='Filelist', library=stdlib)
    masterNet.addNode(Filelist_67,15,8)
    apply(Filelist_67.inputPortByName['match_str'].widget.configure, (), {'master': 'MyApp', 'widgetPlacerCfg': {'rely': '0.7782', 'relx': '0.5654'}})
    Filelist_67.inputPortByName['match_str'].widget.set("cartoonMovie/*.png", run=False)
    code = """def doit(self, match_str):
    import glob
    values = glob.glob(match_str)
    values.sort()
    self.outputData(filelist=values)
"""
    Filelist_67.configure(function=code)
    apply(Filelist_67.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore Filelist named Filelist in network masterNet"
    print_exc()
    Filelist_67=None

try:
    ## saving node Read Image ##
    from Vision.PILNodes import ReadImage
    Read_Image_68 = ReadImage(constrkw={}, name='Read Image', library=imagelib)
    masterNet.addNode(Read_Image_68,15,342)
    apply(Read_Image_68.inputPortByName['filename'].configure, (), {'datatype': 'string', 'originalDatatype': 'str'})
    Read_Image_68.inputPortByName['filename'].rebindWidget()
    Read_Image_68.inputPortByName['filename'].widget.set("", run=False)
    Read_Image_68.inputPortByName['filename'].unbindWidget()
except:
    print "WARNING: failed to restore ReadImage named Read Image in network masterNet"
    print_exc()
    Read_Image_68=None

try:
    ## saving node Scale ##
    from Vision.PILNodes import ResizeImage
    Scale_69 = ResizeImage(constrkw={}, name='Scale', library=imagelib)
    masterNet.addNode(Scale_69,15,390)
    apply(Scale_69.inputPortByName['scale'].widget.configure, (), {'master': 'MyApp', 'widgetPlacerCfg': {'rely': '0.2903', 'relx': '0.4712'}})
    Scale_69.inputPortByName['scale'].widget.set(4.0, run=False)
    Scale_69.inputPortByName['filter'].widget.set("NEAREST", run=False)
    apply(Scale_69.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore ResizeImage named Scale in network masterNet"
    print_exc()
    Scale_69=None

try:
    ## saving node Show Image ##
    from Vision.PILNodes import ShowImage
    Show_Image_70 = ShowImage(constrkw={}, name='Show Image', library=imagelib)
    masterNet.addNode(Show_Image_70,15,445)
except:
    print "WARNING: failed to restore ShowImage named Show Image in network masterNet"
    print_exc()
    Show_Image_70=None

try:
    ## saving node ThumbWheelInt ##
    from Vision.StandardNodes import ThumbWheelIntNE
    ThumbWheelInt_71 = ThumbWheelIntNE(constrkw={}, name='ThumbWheelInt', library=stdlib)
    masterNet.addNode(ThumbWheelInt_71,113,174)
    apply(ThumbWheelInt_71.inputPortByName['thumbwheel'].widget.configure, (), {'min': 0, 'max': 100, 'master': 'MyApp', 'oneTurn': 30.0, 'widgetGridCfgMyApp': {'labelSide': 'top'}, 'widgetGridCfgnode': {'rowspan': 1, 'labelSide': 'top', 'column': 1, 'ipady': 0, 'ipadx': 0, 'columnspan': 1, 'pady': 0, 'padx': 0, 'row': 1}, 'labelCfg': {'text': 'max frame'}, 'widgetPlacerCfg': {'rely': '0.625', 'relx': '0.5288'}})
    ThumbWheelInt_71.inputPortByName['thumbwheel'].widget.set(87, run=False)
    apply(ThumbWheelInt_71.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore ThumbWheelIntNE named ThumbWheelInt in network masterNet"
    print_exc()
    ThumbWheelInt_71=None

try:
    ## saving node DialInt ##
    from Vision.StandardNodes import DialIntNE
    DialInt_72 = DialIntNE(constrkw={}, name='DialInt', library=stdlib)
    masterNet.addNode(DialInt_72,719,121)
    DialInt_72.inputPortByName['dial'].widget.set(0, run=False)
except:
    print "WARNING: failed to restore DialIntNE named DialInt in network masterNet"
    print_exc()
    DialInt_72=None

try:
    ## saving node Index ##
    from Vision.StandardNodes import Index
    Index_73 = Index(constrkw={}, name='Index', library=stdlib)
    masterNet.addNode(Index_73,15,284)
    Index_73.inputPortByName['index'].rebindWidget()
    Index_73.inputPortByName['index'].widget.set(0, run=False)
    Index_73.inputPortByName['index'].unbindWidget()
    apply(Index_73.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore Index named Index in network masterNet"
    print_exc()
    Index_73=None

try:
    ## saving node indexMax ##
    from NetworkEditor.macros import MacroNode
    indexMax_74 = MacroNode(name='indexMax')
    masterNet.addNode(indexMax_74, 130, 106)
    from Vision.StandardNodes import Len
    len_77 = Len(constrkw={}, name='len', library=stdlib)
    indexMax_74.macroNetwork.addNode(len_77,198,86)
    apply(len_77.inputPortByName['in1'].configure, (), {'datatype': 'list', 'originalDatatype': 'None'})
    apply(len_77.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import Operator2
    sub_78 = Operator2(constrkw={}, name='sub', library=stdlib)
    indexMax_74.macroNetwork.addNode(sub_78,202,160)
    apply(sub_78.inputPortByName['data1'].configure, (), {'datatype': 'int', 'originalDatatype': 'None'})
    sub_78.inputPortByName['operation'].widget.set("sub", run=False)
    sub_78.inputPortByName['applyToElements'].widget.set(0, run=False)
    apply(sub_78.configure, (), {'paramPanelImmediate': 1})
    from Vision.StandardNodes import Eval
    _1_79 = Eval(constrkw={}, name='-1', library=stdlib)
    indexMax_74.macroNetwork.addNode(_1_79,259,98)
    _1_79.inputPortByName['command'].widget.set("1", run=False)
    _1_79.inputPortByName['importString'].widget.set("", run=False)
    apply(_1_79.configure, (), {'paramPanelImmediate': 1})

    ## saving connections for network indexMax ##
    indexMax_74.macroNetwork.freeze()
    if len_77 is not None and sub_78 is not None:
        try:
            indexMax_74.macroNetwork.connectNodes(
                len_77, sub_78, "length", "data1", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between len_77 and sub_78 in network indexMax_74.macroNetwork"
    if _1_79 is not None and sub_78 is not None:
        try:
            indexMax_74.macroNetwork.connectNodes(
                _1_79, sub_78, "result", "data2", blocking=True
                , splitratio=[1.0, 0.6875])
        except:
            print "WARNING: failed to restore connection between _1_79 and sub_78 in network indexMax_74.macroNetwork"
    input_Ports_75 = indexMax_74.macroNetwork.ipNode
    if input_Ports_75 is not None and len_77 is not None:
        try:
            indexMax_74.macroNetwork.connectNodes(
                input_Ports_75, len_77, "new", "in1", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between input_Ports_75 and len_77 in network indexMax_74.macroNetwork"
    output_Ports_76 = indexMax_74.macroNetwork.opNode
    if sub_78 is not None and output_Ports_76 is not None:
        try:
            indexMax_74.macroNetwork.connectNodes(
                sub_78, output_Ports_76, "result", "new", blocking=True
                )
        except:
            print "WARNING: failed to restore connection between sub_78 and output_Ports_76 in network indexMax_74.macroNetwork"
    indexMax_74.macroNetwork.unfreeze()
    indexMax_74.shrink()
    apply(indexMax_74.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore MacroNode named indexMax in network masterNet"
    print_exc()
    indexMax_74=None

#masterNet.run()
masterNet.freeze()

## saving connections for network cartoon2c ##
if Read_Image_68 is not None and Scale_69 is not None:
    try:
        masterNet.connectNodes(
            Read_Image_68, Scale_69, "image", "image", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Read_Image_68 and Scale_69 in network masterNet"
if Scale_69 is not None and Show_Image_70 is not None:
    try:
        masterNet.connectNodes(
            Scale_69, Show_Image_70, "scaledImage", "image", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Scale_69 and Show_Image_70 in network masterNet"
if ThumbWheelInt_71 is not None and Index_73 is not None:
    try:
        masterNet.connectNodes(
            ThumbWheelInt_71, Index_73, "value", "index", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between ThumbWheelInt_71 and Index_73 in network masterNet"
if Filelist_67 is not None and Index_73 is not None:
    try:
        masterNet.connectNodes(
            Filelist_67, Index_73, "filelist", "data", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Filelist_67 and Index_73 in network masterNet"
if Index_73 is not None and Read_Image_68 is not None:
    try:
        masterNet.connectNodes(
            Index_73, Read_Image_68, "data", "filename", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Index_73 and Read_Image_68 in network masterNet"
indexMax_74 = masterNet.nodes[7]
if Filelist_67 is not None and indexMax_74 is not None:
    try:
        masterNet.connectNodes(
            Filelist_67, indexMax_74, "filelist", "len_in1", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between Filelist_67 and indexMax_74 in network masterNet"
if indexMax_74 is not None and ThumbWheelInt_71 is not None:
    try:
        masterNet.connectNodes(
            indexMax_74, ThumbWheelInt_71, "sub_result", "maxi", blocking=True
            )
    except:
        print "WARNING: failed to restore connection between indexMax_74 and ThumbWheelInt_71 in network masterNet"
masterNet.runOnNewData.value = False

if __name__=='__main__':
    from sys import argv
    if withoutVision is True: # run without Vision
        masterNet.handleCmdLineArgs(argv[1:], locals())
    else: # run as a stand alone application while vision is hidden
        mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

