#include "plugin.h"

#ifndef STATICDECLS
#define STATICDECLS
int DEBUG = 0;
int enable_real;
int enable_qt;
int enable_wm;
int enable_mpeg;

#define MAX_BUF_LEN 255
#define STATE_RESET 0
#define STATE_NEW 1
#define STATE_HAVEURL 3
#define STATE_WINDOWSET 4
#define STATE_READY 5
#define STATE_QUEUED 6
#define STATE_DOWNLOADING 7
#define STATE_DOWNLOADED_ENOUGH 8

#define STATE_CANCELLED 11

#define STATE_NEWINSTANCE 100
#define STATE_GETTING_PLAYLIST 110
#define STATE_STARTED_PLAYER 115
#define STATE_PLAYLIST_COMPLETE 120
#define STATE_PLAYLIST_NEXT 125
#define STATE_PLAYING 130
#define STATE_PLAY_COMPLETE 140
#define STATE_PLAY_CANCELLED 150

// speed options
#define SPEED_LOW 1
#define SPEED_MED 2
#define SPEED_HIGH 3

#endif


char *GetMIMEDescription()
{

    char *ret;
    char MimeTypes[4000], parse[1000], buffer[1000], customline[255];
    FILE *config, *customtypes;
    int i, use_custom_mime_types;

    enable_real = 0;
    enable_qt = 1;
    enable_wm = 1;
    enable_mpeg = 1;
    use_custom_mime_types = 0;

    DEBUG = 0;			//set to 1 when debugging this function
    if (DEBUG)
	printf("Reading config file for codecs\n");
    // clear the buffer
    for (i = 0; i < 4000; i++) {
	MimeTypes[i] = '\0';
    }

    config = NULL;

    if (config == NULL) {
	snprintf(buffer, 1000, "%s", getenv("HOME"));
	strlcat(buffer, "/.mplayer/mplayerplug-in.conf", 1000);
	config = fopen(buffer, "r");
    }

    if (config == NULL) {
	snprintf(buffer, 1000, "%s", getenv("HOME"));
	strlcat(buffer, "/.mozilla/mplayerplug-in.conf", 1000);
	config = fopen(buffer, "r");
    }

    if (config == NULL) {
	config = fopen("/etc/mplayerplug-in.conf", "r");
    }

    if (config == NULL) {
	// no config file
    } else {
	while (fgets(buffer, 1000, config) != NULL) {

	    if (DEBUG)
		printf("Buffer: %s\n", buffer);

	    if (strncasecmp(buffer, "enable-qt", 9) == 0) {
		snprintf(parse, 1000, "%s", strtok(buffer, "="));
		snprintf(parse, 1000, "%s", strtok(NULL, "="));
		sscanf(parse, "%i", &enable_qt);
		if (DEBUG)
		    printf("qt:%i\n", enable_qt);
		continue;
	    }
	    // Windows Media
	    if (strncasecmp(buffer, "enable-wm", 9) == 0) {
		snprintf(parse, 1000, "%s", strtok(buffer, "="));
		snprintf(parse, 1000, "%s", strtok(NULL, "="));
		sscanf(parse, "%i", &enable_wm);
		if (DEBUG)
		    printf("wm:%i\n", enable_wm);
		continue;
	    }
	    // RealMedia
	    if (strncasecmp(buffer, "enable-real", 11) == 0) {
		snprintf(parse, 1000, "%s", strtok(buffer, "="));
		snprintf(parse, 1000, "%s", strtok(NULL, "="));
		sscanf(parse, "%i", &enable_real);
		if (DEBUG)
		    printf("real:%i\n", enable_real);
		continue;
	    }
	    // MPEG
	    if (strncasecmp(buffer, "enable-mpeg", 11) == 0) {
		snprintf(parse, 1000, "%s", strtok(buffer, "="));
		snprintf(parse, 1000, "%s", strtok(NULL, "="));
		sscanf(parse, "%i", &enable_mpeg);
		if (DEBUG)
		    printf("mpeg:%i\n", enable_mpeg);
		continue;
	    }

	    if (strncasecmp(buffer, "use-mimetypes", 13) == 0) {
		snprintf(parse, 1000, "%s", strtok(buffer, "="));
		snprintf(parse, 1000, "%s", strtok(NULL, "="));
		sscanf(parse, "%i", &use_custom_mime_types);
		if (DEBUG)
		    printf("custom mimetypes:%i\n", use_custom_mime_types);
		continue;
	    }


	}
	fclose(config);
    }


    if (use_custom_mime_types == 1) {
	customtypes = NULL;

	if (customtypes == NULL) {
	    snprintf(buffer, 1000, "%s", getenv("HOME"));
	    strlcat(buffer, "/.mplayer/mplayerplug-in.types", 1000);
	    customtypes = fopen(buffer, "r");
	}

	if (customtypes == NULL) {
	    snprintf(buffer, 1000, "%s", getenv("HOME"));
	    strlcat(buffer, "/.mozilla/mplayerplug-in.types", 1000);
	    config = fopen(buffer, "r");
	}

	if (customtypes == NULL) {
	    customtypes = fopen("/etc/mplayerplug-in.types", "r");
	}

	if (customtypes != NULL) {
	    while (fgets(customline, sizeof(customline), customtypes)) {
		strlcat(MimeTypes, customline, sizeof(MimeTypes));
	    }
	    fclose(customtypes);
	}


    } else {

	if (enable_qt == 1) {
	    strlcat(MimeTypes,
		    "video/quicktime:mov:Quicktime;"
		    "video/x-quicktime:mov:Quicktime;"
		    "image/x-quicktime:mov:Quicktime;"
		    "video/quicktime:mp4:Quicktime;"
		    "video/quicktime:sdp:Quicktime - Session Description Protocol;"
		    "application/x-quicktimeplayer:mov:Quicktime;",
		    sizeof(MimeTypes));
	}

	if (enable_wm == 1) {
	    strlcat(MimeTypes,
		    "video/x-ms-asf-plugin:asf,asx:Windows Media;"
		    "video/x-msvideo:avi:AVI;"
		    "video/msvideo:avi:AVI;"
		    "application/x-mplayer2:wmv:WMV;"
		    "video/x-ms-wm:asf:MSNBCPlayer;"
		    "video/x-ms-asf:asf,asx:Windows Media;"
		    "video/x-ms-wmv:wmv:Windows Media;"
		    "video/x-ms-wmp:wmp:Windows Media;"
		    "video/x-ms-wvx:wvx:Windows Media;"
		    "audio/x-ms-wax:wax:Windows Media;"
		    "audio/x-ms-wma:wma:Windows Media;"
		    "application/x-drm-v2:asx:Windows Media;"
		    "audio/wav:wav:Microsoft wave file;"
		    "audio/x-wav:wav:Microsoft wave file;",
		    sizeof(MimeTypes));
	}


	if (enable_real == 1) {
	    strlcat(MimeTypes,
		    "audio/x-pn-realaudio:ram,rm:RealAudio;"
		    "audio/x-pn-realaudio-plugin:rpm:RealAudio;"
		    "application/smil:smil:SMIL;"
		    "audio/x-realaudio:ra:RealAudio;", sizeof(MimeTypes));
	}

	if (enable_mpeg == 1) {
	    strlcat(MimeTypes,
		    "video/mpeg:mpg,mpeg:MPEG;"
		    "audio/mpeg:mpg,mpeg:MPEG;"
		    "video/x-mpeg:mpg,mpeg:MPEG;"
		    "video/x-mpeg2:mpv2,mp2ve:MPEG2;"
		    "audio/mpeg:mpg,mpeg:MPEG;"
		    "audio/x-mpeg:mpg,mpeg:MPEG;"
		    "audio/mpeg2:mp2:MPEG audio;"
		    "audio/x-mpeg2:mp2:MPEG audio;"
		    "audio/mpeg3:mp3:MPEG audio;"
		    "audio/x-mpeg3:mp3:MPEG audio;"
		    "audio/mp3:mp3:MPEG audio;"
		    "video/mp4:mp4:MPEG 4 Video;", sizeof(MimeTypes));
	}
	// FLI
	strlcat(MimeTypes,
		"video/fli:fli,flc:FLI animation;"
		"video/x-fli:fli,flc:FLI animation;", sizeof(MimeTypes));

	// Vivo
	strlcat(MimeTypes, "video/vnd.vivo:viv,vivo:VivoActive;",
		sizeof(MimeTypes));


    }
    ret = strdup(MimeTypes);
    if (DEBUG)
	printf("%s\n", ret);
    DEBUG = 0;
    return ret;
}

NPError GetValue(NPPVariable variable, void *value)
{

    NPError err = NPERR_NO_ERROR;
    FILE *config;
    char buffer[1000], parse[1000];

    config = NULL;
    DEBUG = 0;			// set to 1 when debugging this function

    if (config == NULL) {
	snprintf(buffer, 1000, "%s", getenv("HOME"));
	strlcat(buffer, "/.mplayer/mplayerplug-in.conf", 1000);
	config = fopen(buffer, "r");
    }

    if (config == NULL) {
	snprintf(buffer, 1000, "%s", getenv("HOME"));
	strlcat(buffer, "/.mozilla/mplayerplug-in.conf", 1000);
	config = fopen(buffer, "r");
    }

    if (config == NULL) {
	config = fopen("/etc/mplayerplug-in.conf", "r");
    }

    if (config == NULL) {
	// no config file
    } else {
	while (fgets(buffer, 1000, config) != NULL) {

	    if (DEBUG)
		printf("Buffer: %s\n", buffer);

	    if (strncasecmp(buffer, "enable-qt", 9) == 0) {
		snprintf(parse, 1000, "%s", strtok(buffer, "="));
		snprintf(parse, 1000, "%s", strtok(NULL, "="));
		sscanf(parse, "%i", &enable_qt);
		if (DEBUG)
		    printf("qt:%i\n", enable_qt);
		continue;
	    }
	    // Windows Media
	    if (strncasecmp(buffer, "enable-wm", 9) == 0) {
		snprintf(parse, 1000, "%s", strtok(buffer, "="));
		snprintf(parse, 1000, "%s", strtok(NULL, "="));
		sscanf(parse, "%i", &enable_wm);
		if (DEBUG)
		    printf("wm:%i\n", enable_wm);
		continue;
	    }
	    // RealMedia
	    if (strncasecmp(buffer, "enable-real", 11) == 0) {
		snprintf(parse, 1000, "%s", strtok(buffer, "="));
		snprintf(parse, 1000, "%s", strtok(NULL, "="));
		sscanf(parse, "%i", &enable_real);
		if (DEBUG)
		    printf("real:%i\n", enable_real);
		continue;
	    }
	}
	fclose(config);
    }

    // some sites use this description to figure out what formats can be played. So we have to make sure the 
    // description matches the features

    if (variable == NPPVpluginNameString) {
	if (enable_qt == 1 && enable_wm == 1 && enable_real == 1)
	    *((const char **) value) =
		"QuickTime Plug-in 6.0, RealPlayer 9, Windows Media Player Plugin are supported by mplayerplug-in";
	if (enable_qt == 1 && enable_wm == 1 && enable_real == 0)
	    *((const char **) value) =
		"QuickTime Plug-in 6.0, Windows Media Player Plugin are supported by mplayerplug-in";
	if (enable_qt == 0 && enable_wm == 1 && enable_real == 1)
	    *((const char **) value) =
		"RealPlayer 9, Windows Media Player Plugin are supported by mplayerplug-in";
	if (enable_qt == 1 && enable_wm == 0 && enable_real == 1)
	    *((const char **) value) =
		"QuickTime Plug-in 6.0, RealPlayer 9 are supported by mplayerplug-in";
	if (enable_qt == 1 && enable_wm == 0 && enable_real == 0)
	    *((const char **) value) =
		"QuickTime Plug-in 6.0 is supported by mplayerplug-in";
	if (enable_qt == 0 && enable_wm == 1 && enable_real == 0)
	    *((const char **) value) =
		"Windows Media Player Plugin is supported by mplayerplug-in";
	if (enable_qt == 0 && enable_wm == 0 && enable_real == 1)
	    *((const char **) value) =
		"RealPlayer 9 is supported by mplayerplug-in";

    }
    if (variable == NPPVpluginDescriptionString) {
	*((const char **) value) =
	    "<a href=\"http://mplayerplug-in.sourceforge.net/\">mplayerplug-in</a> "
	    PACKAGE_VERSION
	    "<br><br>Video Player Plug-in for QuickTime, RealPlayer and Windows Media Player streams using <a href=\"http://mplayerhq.hu\">MPlayer</a> <br>"
	    "JavaScript Enabled<br>";
    }
    if ((variable != NPPVpluginNameString)
	&& (variable != NPPVpluginDescriptionString)) {
	err = NPERR_GENERIC_ERROR;
    }

    DEBUG = 0;
    return err;

}

void New(nsPluginInstance * instance, nsPluginCreateData * parameters)
{
    int i;
    char parse[1000];
    char *cp;

    instance->mode = parameters->mode;
    instance->mInstance = parameters->instance;

    if (parameters->mode == NP_EMBED) {

	if (DEBUG)
	    printf("Embedded mode\n");
	for (i = 0; i < parameters->argc; i++) {

	    if (DEBUG) {
		printf("Argument Name: %s\n", parameters->argn[i]);
		printf("Argument Value: %s\n", parameters->argv[i]);
	    }

	    if (strncasecmp(parameters->argn[i], "src", 3) == 0) {
		instance->url = strdup(parameters->argv[i]);
		instance->state = STATE_HAVEURL;
	    }

	    if (strncasecmp(parameters->argn[i], "type", 4) == 0) {
		instance->mimetype = strdup(parameters->argv[i]);
	    }

	    if ((strncasecmp(parameters->argn[i], "filename", 8) == 0)
		|| (strncasecmp(parameters->argn[i], "url", 3) == 0)) {
		instance->fname = strdup(parameters->argv[i]);
		instance->state = STATE_HAVEURL;
	    }

	    if ((strncasecmp(parameters->argn[i], "href", 4) == 0)
		|| (strncasecmp(parameters->argn[i], "qtsrc", 5) == 0)) {
		instance->href = strdup(parameters->argv[i]);
		instance->state = STATE_HAVEURL;
	    }

	    if (strncasecmp(parameters->argn[i], "height", 6) == 0) {
		sscanf(parameters->argv[i], "%i", &instance->embed_height);
	    }

	    if (strncasecmp(parameters->argn[i], "width", 5) == 0) {
		sscanf(parameters->argv[i], "%i", &instance->embed_width);
	    }

	    /* handle 'scale' attribute used by QT instance */
	    if (strncasecmp(parameters->argn[i], "scale", 5) == 0) {
		if (strncasecmp(parameters->argv[i], "aspect", 6) == 0) {
		    instance->maintain_aspect = 1;
		}
	    }

	    if ((strncasecmp(parameters->argn[i], "loop", 4) == 0)
		|| (strncasecmp(parameters->argn[i], "autorewind", 10) ==
		    0)) {

		lowercase(parameters->argv[i]);
		if (DEBUG)
		    printf("argv[i]=%s\n", parameters->argv[i]);

		if (strstr(parameters->argv[i], "true")
		    || strstr(parameters->argv[i], "yes")) {
		    instance->loop = 1;
		} else {
		    instance->loop = 0;
		}
		if (DEBUG)
		    printf("loop=%i\n", instance->loop);
	    }

	    if (strncasecmp(parameters->argn[i], "autostart", 9) == 0) {

		lowercase(parameters->argv[i]);
		if (DEBUG)
		    printf("argv[i]=%s\n", parameters->argv[i]);

		if (strstr(parameters->argv[i], "true")
		    || strstr(parameters->argv[i], "yes")
		    || strstr(parameters->argv[i], "1")) {
		    instance->autostart = 1;
		} else {
		    instance->autostart = 0;
		}
		if (DEBUG)
		    printf("autostart=%i\n", instance->autostart);
	    }

	    if (strncasecmp(parameters->argn[i], "showcontrols", 11) == 0) {

		lowercase(parameters->argv[i]);
		if (DEBUG)
		    printf("argv[i]=%s\n", parameters->argv[i]);

		if (strstr(parameters->argv[i], "true")
		    || strstr(parameters->argv[i], "yes")
		    || strstr(parameters->argv[i], "1")) {
		    instance->showcontrols = 1;
		} else {
		    instance->showcontrols = 0;
		}
		if (DEBUG)
		    printf("showcontrols=%i\n", instance->showcontrols);
	    }

	    if (strncasecmp(parameters->argn[i], "showlogo", 8) == 0) {

		lowercase(parameters->argv[i]);
		if (DEBUG)
		    printf("argv[i]=%s\n", parameters->argv[i]);

		if (strstr(parameters->argv[i], "false")
		    || strstr(parameters->argv[i], "no")
		    || strstr(parameters->argv[i], "0")) {
		    instance->showlogo = 0;
		} else {
		    instance->showlogo = 1;
		}
		if (DEBUG)
		    printf("showlogo=%i\n", instance->showlogo);
	    }


	    if (strncasecmp(parameters->argn[i], "controls", 8) == 0) {

		lowercase(parameters->argv[i]);
		if (DEBUG)
		    printf("argv[i]=%s\n", parameters->argv[i]);

		if (strstr(parameters->argv[i], "true")
		    || strstr(parameters->argv[i], "yes")
		    || strstr(parameters->argv[i], "1")
		    || strstr(parameters->argv[i], "all")
		    || strstr(parameters->argv[i], "statusfield")
		    || strstr(parameters->argv[i], "playbutton")
		    || strstr(parameters->argv[i], "volumeslider")
		    || strstr(parameters->argv[i], "stopbutton")
		    || strstr(parameters->argv[i], "positionslider")
		    || strstr(parameters->argv[i], "controlpanel")) {
		    instance->controlwindow = 1;
		} else {
		    instance->controlwindow = 0;
		}
		if (strstr(parameters->argv[i], "imagewindow")) {
		    instance->controlwindow = 0;
		}
		if (DEBUG)
		    printf("controlwindow=%i\n", instance->controlwindow);
	    }

	    if ((strncasecmp(parameters->argn[i], "onmediacomplete", 15) ==
		 0)
		|| (strncasecmp(parameters->argn[i], "onendofstream", 13)
		    == 0)) {
		instance->mediaCompleteCallback =
		    (char *) NPN_MemAlloc(strlen(parameters->argv[i]) +
					  12);
		if (strncasecmp(parameters->argv[i], "javascript:", 11) ==
		    0) {
		    snprintf(instance->mediaCompleteCallback,
			     strlen(parameters->argv[i]), "%s",
			     parameters->argv[i]);
		} else {
		    snprintf(instance->mediaCompleteCallback,
			     strlen(parameters->argv[i]) + 12,
			     "javascript:%s", parameters->argv[i]);
		}
		if (DEBUG)
		    printf("mediaCompleteCallback=%s\n",
			   instance->mediaCompleteCallback);
	    }

	    if (instance->nQtNext < 256
		&& (strncasecmp(parameters->argn[i], "qtnext", 6) == 0)
		&& parameters->argv[i][0] == '<') {
		snprintf(parse, 1000, "%s",
			 strtok(&parameters->argv[i][1], ">"));
		if ((cp = strchr(parse, ' '))
		    && strlen(parse) == (unsigned int) (cp - parse + 1))
		    *cp = (char) NULL;
		instance->qtNext[instance->nQtNext++] = strdup(parse);
		snprintf(parse, 1000, "%s", strtok(NULL, "<"));
		if (strcmp(parse, "T")) {
		    if (DEBUG)
			printf("qtNext%i expected \"T\" found \"%s\"\n",
			       instance->nQtNext, parse);
		    instance->nQtNext--;
		} else {
		    snprintf(parse, 1000, "%s", strtok(NULL, ">\n"));
		    if (strcmp(parse, "myself")) {
			if (DEBUG)
			    printf
				("qtNext%i expected \"myself\" found \"%s\"\n",
				 instance->nQtNext, parse);
			instance->nQtNext--;
		    } else if (DEBUG)
			printf("qtNext%i=%s\n",
			       instance->nQtNext,
			       instance->qtNext[instance->nQtNext - 1]);
		}
	    }
	}

	if (instance->controlwindow == 0) {
	    if (instance->fname != NULL) {
		NPN_GetURL(parameters->instance, instance->fname, NULL);
	    }
	}

    } else {
	if (DEBUG)
	    printf("New, full mode %i\n", instance->mode);
    }

    return;

}

void LoadConfigFile(nsPluginInstance * instance)
{

    FILE *config;
    char buffer[1000];
    char parse[1000];

    // load config file

    config = NULL;

    if (config == NULL) {
	snprintf(buffer, 1000, "%s", getenv("HOME"));
	strlcat(buffer, "/.mplayer/mplayerplug-in.conf", 1000);
	config = fopen(buffer, "r");
    }

    if (config == NULL) {
	snprintf(buffer, 1000, "%s", getenv("HOME"));
	strlcat(buffer, "/.mozilla/mplayerplug-in.conf", 1000);
	config = fopen(buffer, "r");
    }

    if (config == NULL) {
	config = fopen("/etc/mplayerplug-in.conf", "r");
    }

    if (config == NULL) {
	// no config file
    } else {
	while (fgets(buffer, sizeof(buffer), config) != NULL) {
	    if ((strncasecmp(buffer, "cachesize", 9) == 0)
		|| (strncasecmp(buffer, "cachemin", 8) == 0)) {
		snprintf(parse, 1000, "%s", strtok(buffer, "="));
		snprintf(parse, 1000, "%s", strtok(NULL, "="));
		sscanf(parse, "%i", &instance->cachesize);
		if (instance->cachesize < 0)
		    instance->cachesize = 0;
		if (instance->cachesize > 65535)
		    instance->cachesize = 65535;
		continue;
	    }

	    if (strncasecmp(buffer, "debug", 5) == 0) {
		snprintf(parse, 1000, "%s", strtok(buffer, "="));
		snprintf(parse, 1000, "%s", strtok(NULL, "="));
		sscanf(parse, "%i", &DEBUG);
//              if (DEBUG != 0)
//                  DEBUG = 1;
		continue;
	    }

	    if (strncasecmp(buffer, "novop", 5) == 0) {
		snprintf(parse, 1000, "%s", strtok(buffer, "="));
		snprintf(parse, 1000, "%s", strtok(NULL, "="));
		sscanf(parse, "%i", &instance->novop);
		if (instance->novop != 0)
		    instance->novop = 1;
		continue;
	    }

	    if (strncasecmp(buffer, "noembed", 7) == 0) {
		snprintf(parse, 1000, "%s", strtok(buffer, "="));
		snprintf(parse, 1000, "%s", strtok(NULL, "="));
		sscanf(parse, "%i", &instance->noembed);
		if (instance->noembed != 0)
		    instance->noembed = 1;
		continue;
	    }

	    if (strncasecmp(buffer, "nomediacache", 12) == 0) {
		snprintf(parse, 1000, "%s", strtok(buffer, "="));
		snprintf(parse, 1000, "%s", strtok(NULL, "="));
		sscanf(parse, "%i", &instance->nomediacache);
		if (instance->nomediacache != 0)
		    instance->nomediacache = 1;
		continue;
	    }


	    if (strncasecmp(buffer, "vopopt", 6) == 0) {
		snprintf(parse, 1000, "%s", strtok(buffer, "="));
		snprintf(parse, 1000, "%s", strtok(NULL, "\n"));
		instance->novop = 0;
		instance->vop = strdup(parse);
		continue;
	    }

	    if (strncasecmp(buffer, "prefer-aspect", 13) == 0) {
		snprintf(parse, 1000, "%s", strtok(buffer, "="));
		snprintf(parse, 1000, "%s", strtok(NULL, "="));
		sscanf(parse, "%i", &instance->maintain_aspect);
		if (instance->maintain_aspect != 0)
		    instance->maintain_aspect = 1;
		continue;
	    }

	    if (strncasecmp(buffer, "rtsp-use-tcp", 12) == 0) {
		snprintf(parse, 1000, "%s", strtok(buffer, "="));
		snprintf(parse, 1000, "%s", strtok(NULL, "="));
		sscanf(parse, "%i", &instance->rtsp_use_tcp);
		if (instance->rtsp_use_tcp != 0)
		    instance->rtsp_use_tcp = 1;
		continue;
	    }

	    if (strncasecmp(buffer, "qt-speed", 8) == 0) {
		sprintf(parse, "%s", strtok(buffer, "="));
		sprintf(parse, "%s", strtok(NULL, "="));
		if (strncasecmp(parse, "low", 3) == 0)
		    instance->qt_speed = SPEED_LOW;
		if (strncasecmp(parse, "medium", 6) == 0)
		    instance->qt_speed = SPEED_MED;
		if (strncasecmp(parse, "high", 4) == 0)
		    instance->qt_speed = SPEED_HIGH;
		if (DEBUG)
		    printf("QT Speed: %i\n", instance->qt_speed);
		continue;
	    }

	    if (strncasecmp(buffer, "vo", 2) == 0) {
		snprintf(parse, 1000, "%s", strtok(buffer, "="));
		snprintf(parse, 1000, "%s", strtok(NULL, "=\n"));
		instance->vo = strdup(parse);
		continue;
	    }

	    if (strncasecmp(buffer, "ao", 2) == 0) {
		snprintf(parse, 1000, "%s", strtok(buffer, "="));
		snprintf(parse, 1000, "%s", strtok(NULL, "=\n"));
		instance->ao = strdup(parse);
		continue;
	    }

	    if (strncasecmp(buffer, "display", 7) == 0) {
		snprintf(parse, 1000, "%s", strtok(buffer, "="));
		snprintf(parse, 1000, "%s", strtok(NULL, "=\n"));
		instance->output_display = strdup(parse);
		continue;
	    }

	    if (strncasecmp(buffer, "dload-dir", 9) == 0) {
		snprintf(parse, 1000, "%s", strtok(buffer, "="));
		snprintf(parse, 1000, "%s", strtok(NULL, "=\n"));
		if (strstr(parse, "$HOME") != NULL) {
		    snprintf(buffer, sizeof(buffer), "%s%s",
			     getenv("HOME"), parse + 5);
		    strlcpy(parse, buffer, sizeof(parse));
		}
		if (instance->download_dir != NULL)
		    free(instance->download_dir);
		instance->download_dir = strdup(parse);
		continue;
	    }

	    if (strncasecmp(buffer, "keep-download", 13) == 0) {
		snprintf(parse, 1000, "%s", strtok(buffer, "="));
		snprintf(parse, 1000, "%s", strtok(NULL, "="));
		sscanf(parse, "%i", &instance->keep_download);
		if (instance->keep_download != 0)
		    instance->keep_download = 1;
		continue;
	    }


	    if (strncasecmp(buffer, "osdlevel", 8) == 0) {
		snprintf(parse, 1000, "%s", strtok(buffer, "="));
		snprintf(parse, 1000, "%s", strtok(NULL, "="));
		sscanf(parse, "%i", &instance->osdlevel);
		if (instance->osdlevel < 0)
		    instance->osdlevel = 0;
		if (instance->osdlevel > 3)
		    instance->osdlevel = 3;
	    }

	    if (strncasecmp(buffer, "cache-percent", 13) == 0) {
		snprintf(parse, 1000, "%s", strtok(buffer, "="));
		snprintf(parse, 1000, "%s", strtok(NULL, "="));
		sscanf(parse, "%i", &instance->cache_percent);
		if (instance->cache_percent < 0)
		    instance->cache_percent = 0;
		if (instance->cache_percent > 100)
		    instance->cache_percent = 100;
	    }




	}
    }

    if (instance->download_dir == NULL && instance->keep_download == 1)
	instance->download_dir = strdup(getenv("HOME"));

}
