/*
 *   meio_api.h
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
/**************************************************************************/
/*           MWAVE EXTERNAL INPUT/OUTPUT HEADER FILE                      */
/*------------------------------------------------------------------------*/
#if !defined(MEIO_API_INCLUDED)

#define MEIO_API_INCLUDED   /* say that we've included this file     CH04 */

/*------------------------------------------------------------------------*/
/* API VERSION NUMBER                                                     */
/*------------------------------------------------------------------------*/
#define APIVERSION  0x0201      /* release 2.01 */


#if !defined(DSP_NOERROR)   /* have the Mwave types been defined?    CH04 */
#include "mwave.h"                                               /*  CH04 */
#endif

#include "mhandles.h"       /* get the Mwave port handles            CH04 */

/*------------------------------------------------------------------------*/
/* Define FAR keyword                                                     */
/*------------------------------------------------------------------------*/
/* FAR is defined as '   ' for OS/2 under C                               */
/* The FAR keyword is needed to convert pointers properly in 16-bit code  */
/*------------------------------------------------------------------------*/
#if defined(__IBMC__)                                             /* CH02 */
    #define FAR
    #define FARPTR16 * _Seg16  /* modifier follows ptr */         /* CH02 */
#else                                                             /* CH02 */
#define FARPTR16 FAR *     /* old style 16:16 far ptr */          /* CH02 */
#if !defined(APIRET)       /* do we have APIRET defined? */       /* CH02 */
typedef ULONG APIRET;
#endif
#if !defined(APIENTRY)     /* is APIENTRY defined?       */       /* CH05 */
#define APIENTRY FAR PASCAL _loadds 
#endif
#endif

#define PHMTASK  PHTASK                                            /*CH05 */
typedef long FAR *LPLONG;  

extern USHORT madbg;
extern USHORT mcdbg;
extern USHORT msdbg;

/**************************************************************************/
/* dspMeioQueryAbilities() Function codes                                 */
/**************************************************************************/
enum MEIO_Query_Types
{                              /*-----------------------------------------*/
     QAPIV                     /* 0  Query API VERSION                    */
    ,QAOWNERS                  /* 1  Query Analog OWNERS                  */
    ,QAUSERS                   /* 2  Query Analog USERS                   */
    ,QDOWNERS                  /* 3  Query Digital OWNERS                 */
    ,QDUSERS                   /* 4  Query Digital USERS                  */
    ,QACONNECTIONS             /* 5  Query Analog CONNECTIONS             */
    ,QDCONNECTIONS             /* 6  Query Digital CONNECTIONS            */
    ,QALLAC                    /* 7  Query All Possible Analog Connections*/
    ,QALLDC                    /* 8  Query All Possible Digital Connect.  */
    ,QAATTRIBUTES              /* 9  Query Analog ATTRIBUTES              */
    ,QASTATUS                  /* 10 Query Analog STATUS                  */
    ,QADAPTER                  /* 11 Query Adapter Capabilities           */
};                             /*-----------------------------------------*/

                                                            /* begin CH03 */
/**************************************************************************/
/* dspMeioResync() Object Type codes                                      */
/**************************************************************************/
enum MEIO_Object_Types
{                              /*-----------------------------------------*/
                               /* type code for...                        */
   HMEIO_OBJ_TYPE              /*  MEIO Handle                            */
  ,HDSP_OBJ_TYPE               /*  DSP  Handle                            */
  ,HCONNECTION_OBJ_TYPE        /*  Connection Handle                      */
                               /*-----------------------------------------*/
};
                                                            /* end   CH03 */

/*************************************************************************/
/*                                                                       */
/*  MEIO global variables                                                */
/*                                                                       */
/*************************************************************************/

#if defined(OS2RING0)                 /* are we running RING 0 code?      */
extern VOID FARPTR16 MeioDevHlp;      /* if we are import MeioDevHlp      */
#endif

extern char Meio_DD_Name[9];          /* name of DD to attach to         */



/**************************************************************************/
/*                                                                        */
/*        MEIO IOCTL Function Codes                                       */
/*                                                                        */
/* Define MEIO DD IOCTL Function codes for each API function.             */
/**************************************************************************/

#define MEIO_FIRST_FUNCTION       0xC0     /* first IOCTL function code   */

enum MEIO_IOCtl_Function_Codes
{
     MEIO_IOCtl_Open            = MEIO_FIRST_FUNCTION
    ,MEIO_IOCtl_Close
    ,MEIO_IOCtl_Query_Abilities
    ,MEIO_IOCtl_Connect
    ,MEIO_IOCtl_QueryConnection
    ,MEIO_IOCtl_UpdateConnection
    ,MEIO_IOCtl_Disconnect
    ,MEIO_IOCtl_Resync                                           /*CH03*/
};



/**************************************************************************/
/*                                                                        */
/*        MEIO Connect Option Codes                                       */
/*                                                                        */
/**************************************************************************/
/*------CONNECTION ATTRIBUTES---------------------------------------------*/
/*  NOTE: Some of these options may not exist for all connections. Refer  */
/*        to adapter documentation for valid connection options.          */
/*------------------------------------------------------------------------*/
enum MeioConnectAttributes
{
  MEIO_CONNECTION_SHARING=1       /* Update Shareability of connection    */
 ,MEIO_CONNECTION_MIXING          /* Enable/Disable Connection Mixing     */
 ,MEIO_USER_MIXING                /* Enable/Disable User Mixing           */
 ,MEIO_OWNER_MIXING               /* Enable/Disable Owner Mixing          */
 ,MEIO_CONNECTION_AGC             /* Enable/Disable Connection AGC        */
 ,MEIO_USER_AGC                   /* Enable/Disable User AGC              */
 ,MEIO_OWNER_AGC                  /* Enable/Disable Owner AGC             */
 ,MEIO_CONNECTION_GAIN            /* Update Connection Gain               */
 ,MEIO_USER_GAIN                  /* Update User Gain                     */
 ,MEIO_OWNER_GAIN                 /* Update Owner Gain                    */
 ,MEIO_CONNECTION_STATE           /* update Connection State          CH04*/
 ,MEIO_CONNECTION_CHARACTERISTICS /* characteristics eg CallerID, etc     */
 ,MEIO_USER_ATTRIBUTES=0x1000     /* beginning of USER defined attributes */
};

/*------------------------------------------------------------------------*/
/*  General boolean attribute values - see MeioConnectionAttributes       */
/*------------------------------------------------------------------------*/
#define MEIO_C_ENABLE     1     /* Enable the attribute                   */
#define MEIO_C_DISABLE    0     /* Disable the attribute                  */

/*------------------------------------------------------------------------*/
/* Connection sharing options, must be single, unique bit                 */
/*------------------------------------------------------------------------*/
#define MY_OWNER_PORT    0x01 /* make Owner port exclusive            CH04*/
#define MY_USER_PORT     0x02 /* make User port exclusive             CH04*/
#define MY_CONNECTION    0x04 /* make Connection exclusive            CH04*/


/*------------------------------------------------------------------------*/
/* Connection state options                                           CH04*/
/*------------------------------------------------------------------------*/
#define UNKNOWN            0  /* MEIO doesn't know the current state  CH04*/
#define ON                 1  /* turn on the switch                   CH04*/
#define OFF                2  /* turn off the switch                  CH04*/
#define UNCHANGED          3  /* don't change the switch setting      CH04*/

/*------------------------------------------------------------------------*/
/*  Adapter Characteristics flags                                         */
/*------------------------------------------------------------------------*/
#define MACF_CDADC          0x00000001L
#define MACF_CDADCBIOS      0x00000002L
#define MACF_CDDAC          0x00000004L
#define MACF_CDDACBIOS      0x00000008L
#define MACF_MIDIPORT       0x00000010L
#define MACF_MIDIBIOS       0x00000020L
#define MACF_VIO            0x00000040L
#define MACF_VIOBIOS        0x00000080L
#define MACF_TAIO           0x00000100L
#define MACF_TAIOBIOS       0x00000200L
#define MACF_HANDSET        0x00000400L
#define MACF_HANDSOFT       0x00000800L
#define MACF_UART           0x00001000L
#define MACF_UARTBIOS       0x00002000L
#define MACF_ISDN           0x00004000L
#define MACF_ISDNBIOS       0x00008000L
#define MACF_V96            0x00010000L                               /*$1*/ 
#define MACF_V96BIOS        0x00020000L                               /*$1*/ 

/*------------------------------------------------------------------------*/
/*   Define Structure for TAIO Connection Characteristics                 */
/*------------------------------------------------------------------------*/
typedef struct
{
   unsigned int CallerID         : 1;  /* supports CallerID in current country*/
   unsigned int CallerID_Enabled : 1;  /* CallerID Passthrough enabled*/
   unsigned int HandsetIntf      : 1;  /* supports a handset to phone line*/
   unsigned int CouplerMismatch  : 1;  /* 1 ==> CouplerID does not match*/
                                       /*       Worldtrade country selection*/
                                       /* 0 ==> They match.*/
   unsigned int reserved1        : 11; /* not defined at this time*/
   unsigned int MultipleCountry  : 1;  /* supports multiple countries*/
   unsigned int CouplerID        : 16; /* WorldTrade Coupler ID*/
}  MEIO_TAIOCONNCHAR;

typedef union
{
   LONG              lArg;      /* member to use if passing as Long arg.*/
   MEIO_TAIOCONNCHAR sVal;      /* member to use if referencing fields*/
}  MEIO_TAIOCONNARG;

/*------------------------------------------------------------------------*/
/*  MEIO Handle Type Definition                                           */
/*------------------------------------------------------------------------*/
typedef ULONG HMEIO;                 /* handle for a MEIO instance        */
typedef ULONG HCONNECTION;           /* handle for a connection           */

typedef enum MEIO_Query_Types   MEIO_QUERYTYPE; /* type of query for MEIO */

typedef enum MeioConnectAttributes            /* connection attributes    */
                                MEIO_CONNECTATTRIBUTE;
typedef enum MEIO_Object_Types  MEIO_OBJ_TYPE;  /* type of MEIO ObjectCH03*/


/**************************************************************************/
/* MEIO OPEN API                                                          */
/**************************************************************************/
ULONG APIENTRY dspMeioOpen(
                 HDSP       hDsp,    /* Handle of DSP device from DSPMGR  */
                 HMEIO FAR *hMEIO,   /* Handle of MEIO Instance returned  */
                 ULONG      Options);/* reserved - must be 0              */

/*------------------------------------------------------------------------*/
/* MEIO CLOSE API                                                         */
/*------------------------------------------------------------------------*/
ULONG APIENTRY dspMeioClose(
                     HMEIO  hMEIO,   /* handle of MEIO instance returned  */
                                     /*     by dspMeioOpen()              */
                     ULONG  Options);/* reserved - must be 0              */


/*------------------------------------------------------------------------*/
/* MEIO QUERY API                                                         */
/*------------------------------------------------------------------------*/
ULONG APIENTRY dspMeioQuery(
            HMEIO           hMEIO,     /* MEIO Handle                     */
            MEIO_QUERYTYPE  Request,   /* type of Query                   */
            ULONG    FAR   *BufferSize,/* size of buffer for returned data*/
                                       /* required size is returned if    */
                                       /* insufficient for type of query  */
            VOID     FAR   *Buffer);   /* buffer for returned data        */



/**************************************************************************/
/* MEIO CONNECT API                                                       */
/**************************************************************************/
ULONG APIENTRY dspMeioConnect(
            HMEIO            hMEIO,          /* MEIO Handle               */
            HCONNECTION FAR *Connection,     /* THE Connection is returned*/

            ULONG            OwnerPort,      /* Connection Owner          */
            ULONG            UserPort,       /* Connection User           */

            ULONG            SharingOptions, /* willingness to share      */
            ULONG            ulState,        /* set switch to this stateCH04*/
            ULONG            Reserved);      /* reserved - must be 0      */



/*------------------------------------------------------------------------*/
/* MEIO DISCONNECT API                                                    */
/*------------------------------------------------------------------------*/
ULONG APIENTRY dspMeioDisconnect(
                HCONNECTION Connection,         /* handle returned by     */
                                                /* dspMeioConnect()       */
                ULONG       ulReserved);        /* must be 0          CH04*/



/*------------------------------------------------------------------------*/
/* MEIO Update Connection Attributes                                      */
/*------------------------------------------------------------------------*/
ULONG APIENTRY dspMeioUpdateConnection(
    HCONNECTION           Connection,   /* handle returned by             */
                                        /* dspMeioConnect()               */
    MEIO_CONNECTATTRIBUTE Attribute,    /* define attribute to update.    */
    LONG                  Value);       /* value of attribute.            */



/*------------------------------------------------------------------------*/
/* MEIO Query Connection Attributes                                       */
/*------------------------------------------------------------------------*/
ULONG APIENTRY dspMeioQueryConnection(
    HCONNECTION           Connection,   /* handle returned by             */
                                        /* dspMeioConnect()               */
    MEIO_CONNECTATTRIBUTE Attribute,    /* define attribute to query.     */
    LONG             FAR *Value);       /* value of attribute.            */


                                                              /*begin CH03*/
/*------------------------------------------------------------------------*/
/* MEIO RESYNC API                                                        */
/*------------------------------------------------------------------------*/
ULONG APIENTRY dspMeioResync(
               MEIO_OBJ_TYPE ObjectType,    /* type of handle being passed*/
               ULONG         Object,        /* some Mwave handle          */
                                            /* dspMeioConnect()           */
               ULONG         ulOptions);    /* resync options, must be 0  */
                                                              /*end   CH03*/
                                            /* 0                      CH03*/



/**************************************************************************/
/* MEIO Return Codes                                                      */
/**************************************************************************/

#define MEIO_NOERROR                    0x00000000
#define MEIO_INVALID_CONNECTION_STATE   0x00000001
#define MEIO_INVALID_VOLUME_REQUEST     0x00000002
#define MEIO_MANAGER_ERROR              0x00000003
#define MEIO_TASK_ERROR                 0x00000004
#define MEIO_FAIL_MEIO_SHUTDOWN         0x00000005
#define MEIO_FAIL_PORT_BLOCK            0x00000006
#define MEIO_FAIL_CONNECTION_BLOCK      0x00000007
#define MEIO_FAIL_REQ_CONNECTION_COUNT  0x00000008

#define MEIO_FAIL_LOAD_MEIO_TASK        0x00000009
#define MEIO_FAIL_FREE_MEIO_TASK        0x0000000A
#define MEIO_FAIL_REQ_ISPOS_MHANDLE     0x0000000B
#define MEIO_FAIL_REQ_MEIO_MHANDLE      0x0000000C
#define MEIO_FAIL_REQ_MEIO_THANDLE      0x0000000D
#define MEIO_FAIL_REQ_MEIO_TLABEL       0x0000000E

#define MEIO_FAIL_LOAD_BIOS_TASK        0x0000000F
#define MEIO_FAIL_FREE_BIOS_TASK        0x00000010
#define MEIO_FAIL_INIT_BIOS_TASK        0x00000011
#define MEIO_FAIL_REQ_BIOS_MHANDLE      0x00000012
#define MEIO_FAIL_REQ_BIOS_THANDLE      0x00000013
#define MEIO_FAIL_REQ_BIOS_TLABEL       0x00000014
#define MEIO_FAIL_BIOS_INITIALIZE       0x00000015

#define MEIO_FAIL_DRIVER_OPEN           0x00000016
#define MEIO_FAIL_DRIVER_CALL           0x00000017
#define MEIO_FAIL_NO_HANDLES            0x00000018
#define MEIO_INVALID_MEIO_HANDLE        0x00000019
#define MEIO_BUSY                       0x0000001A
#define MEIO_INVALID_MEIO_TYPE          0x0000001B
#define MEIO_INSUFFICIENT_BUFFER        0x0000001C
#define MEIO_INVALID_QUERY_PARM         0x00000020

#define MEIO_ERROR                      0x000000FF   /* non specific error */

/*------------------------------------------------------------------------*/
/* dspMEIOConnect Return Codes                                            */
/*------------------------------------------------------------------------*/
/* MEIO_NC_xxxxxxx = NO CONNECTION ERROR CODE                             */
/* MEIO_C_xxxxxxxx = CONNECTION MADE                                      */
/*------------------------------------------------------------------------*/

#define MEIO_NC_CONNECTION_BLOCKED    0x00000101
#define MEIO_NC_OWNER_BLOCKED         0x00000102
#define MEIO_NC_USER_BLOCKED          0x00000103
#define MEIO_NC_INVALID_OWNER         0x00000104
#define MEIO_NC_INVALID_USER          0x00000105
#define MEIO_NC_INVALID_CONNECTION    0x00000106
#define MEIO_NC_INVALID_MIX_BITS      0x00000107
#define MEIO_NC_NOBLOCK_USER_PMIX     0x00000108/* NO BLOCK- Permanant Mix*/
#define MEIO_NC_NOBLOCK_USER_IN_USE   0x00000109/* NO BLOCK- User in Use  */
#define MEIO_NC_INVALID_HANDLE        0x0000010A
#define MEIO_NC_INVALID_ATTRIBUTE     0x0000010B
#define MEIO_NC_MIXING_VIOLATION      0x0000010C
#define MEIO_NC_INVALID_AGC_BITS      0x0000010D
#define MEIO_NC_INVALID_NETWORKINTF   0x00000120 /* network interface incorrect */
                                                 /* probably wrong CouplerID    */
#define MEIO_NC_INVALID_TAIOREV       0x00000121 /* revision mismatch */


/*------------------------------------------------------------------------*/
/* MEIO_Disconnect() Return Codes                                         */
/*------------------------------------------------------------------------*/
/* MEIO_ND_xxxxxxx = NO DISCONNECT                                        */
/*------------------------------------------------------------------------*/


#define MEIO_ND_INVALID_OWNER         0x00000201
#define MEIO_ND_INVALID_USER          0x00000202
#define MEIO_ND_INVALID_CONNECTION    0x00000203
#define MEIO_ND_NOT_CONNECTED         0x00000204
#define MEIO_ND_INVALID_HANDLE        0x00000205

/*------------------------ END RETURN CODES  ------------------------------*/

#endif       /* end of conditional include */

