/*
 *   dspstruc.h -- Prototypes for Data Structure allocation/deallocation and linkage.
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */



/****************************************************************************/
/* Usage:                                                                   */
/*                                                                          */
/*  For the following data structure types, use the AllocatePerm() &        */
/*  FreePerm() routines to allocate and delete space in memory for the      */
/*  specific data type.                                                     */
/*                                                                          */
/*      PARSTBL                                                             */
/*      PARPUB                                                              */
/*                                                                          */
/*  For the following data structure types, use the AllocateTemp() &        */
/*  FreeTemp() routines to allocate and delete space in memory for the      */
/*  specific data type.                                                     */
/*                                                                          */
/*      PARFIX                                                              */
/*                                                                          */
/*  Otherwise, use one of the following functions to allocate/Free memory   */
/*  space for a specific data type. Also, NOTE that the Remove routines     */
/*  will also remove any data structures that are pointed to by the data    */
/*  structure being removed, except for other members of the linked-list    */
/*  the data structure is connected to. For example, a Remove of a RTSK     */
/*  data structure will also remove all segments of the task and so on.     */
/*  All of the Add routines add the nodes at the tail of the linked-list    */
/*  and return a ptr to the node.                                           */
/*                                                                          */
/****************************************************************************/
/*************************************************/
/* Initialization value should be zero.          */
/*************************************************/
#define INIT_VAL 0

/****************************************************************************/
/* Macros                                                                   */
/****************************************************************************/
#define AllocRTCB(pprtcb)   AllocTemp((ULONG)sizeof(RTCB),(USHORT)4096,(PVOID) *pprtcb)
#define FreeRTCB(prtcb)   FreeTemp((PVOID)prtcb,(ULONG)sizeof(RTCB))
#define FreeRMemory(prmemNode)   FreePerm((PVOID)prmemNode,(ULONG)sizeof(RMEM))

/****************************************************************************/
/* Function Prototypes                                                      */
/****************************************************************************/
RC      AllocRMemory (PRMEM * pprmemNode);

RC   AllocRModule (PRMOD * pprmodNode);
RC   RemoveRModule (PRMOD * pprmodListTail, PRMOD prmodNode, PRMOD prmodPrev);

RC   AddRManagerTail (PRMGR * pprmgrListTail, PRMGR * pprmgrNode);

RC   AddRDspTail (PRDSP * pprdspListTail, PRDSP * pprdspNode);

RC   AddRIPCTableTail (PRIPCTE * ppripcteListTail);      /* CH01 LBM */
//RC   RemoveRIPCTableTail (PRIPCTE * ppripcteListTail); /* CH01 LBM */

RC   AddRBiotTail (PRBIOT * pprBiotListTail, PRBIOT * pprBiotNode);
//RC   RemoveRBiot (PRBIOT * pprBiotListTail, PRBIOT prBiotNode, PRBIOT prBiotPrev);

RC   AddRFrameMgrTail (PRFM * pprfmListTail, PRFM * pprfmNode);
RC   RemoveRFrameMgr (PRFM prfmNode, PRTSK prtsk);

RC   AddRGPCConnListTail (PRGPCCL * pprgpcclListTail, PRGPCCL * pprgpcclNode);
RC   RemoveRGPCConnList (PRGPCCL * pprgpcclListTail, PRGPCCL prgpcclNode, PRGPCCL prgpcclPrev);

RC   AddRITCBConnListTail (PRITCBCL * ppritcbclListTail, PRITCBCL * ppritcbclNode);
RC   RemoveRITCBConnList (PRITCBCL * ppritcbclListTail, PRITCBCL pritcbclNode, PRITCBCL pritcbclPrev);

RC   AddRTaskTail (PRTSK * pprtskListTail, PRTSK * pprtskNode);
RC   RemoveRTask (PRTSK * pprtskListTail, PRTSK prtskNode, PRTSK prtskPrev);
RC   RemoveRTasktmp (PRTSK prtskNode);

RC   AddRSegmentTail (PRSEG * pprsegListTail, PRSEG * pprsegNode);
RC   RemoveRSegment (PRSEG * pprsegListTail, PRSEG prsegNode, PRSEG prsegPrev);
RC   RemoveRSegmenttmp (PRSEG prsegNode);

RC   AddRImageTail (PRIMG * pprimgListTail, PRIMG * pprimgNode);
RC   AddRImageHead (PRIMG * pprimgListTail, PRIMG * pprimgNode);
RC   RemoveRImage (PRIMG * pprimgListTail, PRIMG primgNode, PRIMG primgPrev);

RC   AddRLDMATail (PRLDMA * pprldmaListTail, PRLDMA * pprldmaNode);
RC   RemoveRLDMA  (PRLDMA * pprldmaListTail, PRLDMA prldmaNode, PRLDMA prldmaPrev);

RC   AddRGPCTail (PRGPC * pprgpcListTail, PRGPC * pprgpcNode);
RC   RemoveRGPC (PRGPC * pprgpcListTail, PRGPC prgpcNode, PRGPC prgpcPrev);

RC   AddRITCBTail (PRITCB * ppritcbListTail, PRITCB * ppritcbNode);
RC   RemoveRITCB (PRITCB * ppritcbListTail, PRITCB pritcbNode, PRITCB pritcbPrev);

RC   AddRHwTail (PRHW * pprhwListTail, PRHW * pprhwNode);
RC   RemoveRHw (PRHW * pprhwListTail, PRHW prhwNode, PRHW prhwPrev);
RC   CheckDSPStatus(PRDSP prdsp); /* CH04 */
