/*
 *   meiogtwy.h -- MEIO Manager gateway prototypes/defines
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
/****************************************************************************/
/*  Define maximum number of statically allocated components                */
/*     (I hate statically allocated components but Ring 0 is a bitch.)      */
/****************************************************************************/

#define MAX_MEIO_HANDLES     16   /* should be enough for single card HA HA */
#define MAX_MEIO_CONNECTIONS 32   /* two per handle???                      */
#define MAX_MEIO_DSPS         8   /* maximum number of DSPs in system       */

#define MEIO_OBJ_UNUSED      0    /* possible object states */
#define MEIO_OBJ_USED        1

/****************************************************************************/
/*  Define component types                                                  */
/****************************************************************************/

/****************************************************************************/
/*                                                                          */
/*  HMEIO_PARTS  -   Mechanism to access parts of MEIO handle               */
/*                                                                          */
/*  Declaration:                                                            */
/*               HMEIO_PARTS hpThis;                                        */
/*                                                                          */
/*  Assignment:                                                             */
/*               hpThis.Handle = (HMEIO)phMeio;    - init with owners ptr   */
/*                                                                          */
/*  Setting index value:                                                    */
/*               hpThis.Part.HandleIndex = usIndex; - save index into array */
/*                                                                          */
/*  Returning MEIO Handle:                                                  */
/*               *phMeio = hpThis.Handle;                                   */
/*                                                                          */
/****************************************************************************/
typedef union
{
   HMEIO      Handle;          /* handle returned to owners                */
   struct
   {
      USHORT  HandleIndex;     /* index into array of handles              */
      USHORT  OwnersSegment;   /* 'key' to handle's owner                  */
   }  Part;
}  HMEIO_PARTS;


/**************************************************************************/
/*                                                                        */
/*  MEIO_DSP    - Structure containing elements required for each DSP in  */
/*                Mwave Subsystem.  This is initialized to empty by       */
/*                InitializeMeio(), and initialized with data when a new  */
/*                HDSP is used on dspMeioOpen().                          */
/*                                                                        */
/*  Members:                                                              */
/*    usObjectState  - defines state of this object (unused, used, etc.)  */
/*                                                                        */
/*    hDsp           - has handle to Mwave Dsp                            */
/*                                                                        */
/*    hMod           - handle of MEIO module on this DSP                  */
/*                                                                        */
/*    hmTask         - handle of MEIO task on this DSP                    */
/*                                                                        */
/*    ulMEIO_Command - address of MEIO Task Command word                  */
/*                                                                        */
/*    ulMEIO_Data    - address of MEIO Task Data area                     */
/*                                                                        */
/**************************************************************************/
typedef struct
{
   USHORT usObjectState;
   HDSP   hDsp;
   HMOD   hMod;                // handle of MEIO module on this DSP
   HMTASK hmTask;              // handle of MEIO task on this DSP
   HMOD   hMwaveMod;           // handle of Mwave OS module (for BIOS ops)

   ULONG  ulMEIO_Command;      // address of MEIO Task Command word
   ULONG  ulMEIO_Data;         // address of MEIO Task Data area
   ULONG  ulMEIO_VioAddr;      // address of MEIO->VIO ITCB
   ULONG  ulMEIO_TaioAddr;     // address of MEIO->TAIO ITCB
   ULONG  ulMEIO_HSAddr;       // address of MEIO->CDDAC & CDADC ITCB

}  MEIO_DSP;

typedef MEIO_DSP FAR *PMEIO_DSP;

/***************************************************************************/
/*                                                                         */
/*  MEIO_OWNER   - Structure containing elements required for each MEIO    */
/*                 owner.  An owner is established by way of the           */
/*                 dspMeioOpen() function.                                 */
/*                                                                         */
/*  Members:                                                               */
/*                                                                         */
/*    usObjectState  - defines the state of this object (null, used, etc). */
/*                                                                         */
/*    pMeioDsp       - pointer to Meio Data for this DSP.                  */
/*                                                                         */
/*    usOwnerKey     - key to real owner  (currently uses owner's segment) */
/*                                                                         */
/*    ulOptions      - the Open/Close options for this handle.             */
/*                                                                         */
/***************************************************************************/
typedef struct
{
   USHORT    usObjectState;
   PMEIO_DSP pMeioDsp;
   USHORT    usOwnerKey;
   ULONG     ulOptions;
}  MEIO_OWNER;

/****************************************************************************/
/*                                                                          */
/*  MEIO_CONNECTION  - structure containing elements required for each      */
/*                     connection established by dspMeioConnect() and       */
/*                     maintained by dspMeioUpdateConnection().             */
/*                                                                          */
/*  Members:                                                                */
/*                                                                          */
/*    usObjectState    - defines the state of this object (null, used, etc.)*/
/*    hResourceOwner   - contains the Meio Handle 'owning' this connection. */
/*    pMeioDsp         - pointer to Meio Data for this DSP.                 */
/*    lpResourceSet    - pointer to resource set                            */
/*    ulSharingOptions - defines how this can be shared.                    */
/*    ulReserved       - unused for now.                                    */
/*                                                                          */
/****************************************************************************/
typedef struct meio_connection
{
   USHORT     usObjectState;
   HMEIO      hResourceOwner;
   PMEIO_DSP  pMeioDsp;
   PRS        lpResourceSet;
   ULONG      ulSharingOptions;
   ULONG      ulReserved;
}  MEIO_CONNECTION;

/****************************************************************************/
/*                                                                          */
/*  MEIOQCINFO - structure contains handles for owners of a connection      */
/*               pair.  This is for internal use only, it is not for        */
/*               general use.                                               */
/*                                                                          */
/*  Members:                                                                */
/*   USHORT     OwnerHandle - input handle for owner port                   */
/*   USHORT     UserHandle  - input handle for user port                    */
/*   USHORT     OwnerCount  - output number of Connection Handles to which  */
/*                            the port pair is reserved.                    */
/*   struct MEIOQCDATA      - output data structure                         */
/*   {                                                                      */
/*      HCONNECTION hConnection - contains owner's connection handle        */
/*      HMEIO       hMeio       - and MEIO handle                           */
/*   } Data[1];             - one entry for each owner                      */
/*                                                                          */
/****************************************************************************/
struct MEIOQCINFO
{
   USHORT     OwnerHandle;
   USHORT     UserHandle;
   USHORT     OwnerCount;
   struct MEIOQCDATA
   {
      HCONNECTION hConnection;
      HMEIO       hMeio;
   } Data[1];
};
#define MEIOQCINFOREQ  0xfe01        /* Query request code to get this info */

MEIO_OWNER FAR *GetMEIOOwner(HMEIO hMeio);
PMEIO_DSP  FAR  GetMeioDsp(HDSP hDsp);
ULONG      FAR MEIO_Query_Abilities(PMEIO_DSP      pMeioDsp,
                                    MEIO_QUERYTYPE Request,
                                    PULONG         fpBufferSize,
                                    PVOID          fpBuffer);
ULONG  FAR SendScoreBoards(PMEIO_DSP pMeioDsp);

int pascal InitializeMEIO( char FAR *lpszCmdLine );
ULONG  FAR InitializeMEIODsp(PMEIO_DSP pMeioDsp, USHORT reset);

/*-----------------------------------------------------------------*/
/* data value used to export adapter characteristics               */
/*-----------------------------------------------------------------*/
extern ULONG  MEIO_Adapter_Characteristics;
ULONG GetMeioAdapterCaps(ULONG Reserved);
void MEIO_Suspend(PMEIO_DSP pMeioDsp);
