/*
 *   modem.c -- Mwave modem application
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include <stdio.h>
#include <unistd.h>

#include <mwave.h>
#include <mwaveapi.h>
#include <meio_api.h>

#include <mwmspcfc.h>

/*#include <mwmwin.h>*/

#include <port_types.h>

DWORD modem_trc_flags=0x00000200; // see ./mwavem/src/include/port_functions

unsigned char * ini_file="/usr/local/etc/mwavem.conf"; // default location for mwavem ini file

int main(int argc, char **argv) {
	BOOL bRC;
	ULONG ulRC;
	USHORT  usPCMValue;

	SHORT sModemStartSpeed;
	PMWM_DSPINFO pmwmDspInfo;
	MWM_INSTANCE_INFO InstanceInfo;

	USHORT usV34EMEnabled;
	USHORT usAllSpeeds;
	char szStartspeed[80];

        if (argc > 1) {
	  ini_file=argv[1];
        }

	if (GetPrivateProfileInt("DEBUG","MANAGER_API_TRACE",0,ini_file)) {
	  modem_trc_flags |= TRACE_MANAGER_API;
	}
	if (GetPrivateProfileInt("DEBUG","MANAGER_API_DATA_TRACE",0,ini_file)) {
	  modem_trc_flags |= TRACE_MANAGER_API_DATA;
	}
	if (GetPrivateProfileInt("DEBUG","MANAGER_CORE_TRACE",0,ini_file)) {
	  modem_trc_flags |= TRACE_MANAGER_CORE;
	}
	if (GetPrivateProfileInt("DEBUG","MANAGER_SPECIFIC_TRACE",0,ini_file)) {
	  modem_trc_flags |= TRACE_MANAGER_SPECIFIC;
	}
	if (GetPrivateProfileInt("DEBUG","MEIO_API_TRACE",0,ini_file)) {
	  modem_trc_flags |= TRACE_MEIO_API;
	}
	if (GetPrivateProfileInt("DEBUG","MEIO_CORE_TRACE",0,ini_file)) {
	  modem_trc_flags |= TRACE_MEIO_CORE;
	}
	if (GetPrivateProfileInt("DEBUG","MEIO_SPECIFIC_TRACE",0,ini_file)) {
	  modem_trc_flags |= TRACE_MEIO_SPECIFIC;
	}
	if (GetPrivateProfileInt("DEBUG","MWMLW32_TRACE",0,ini_file)) {
	  modem_trc_flags |= TRACE_MWMLW32;
	}
	if (GetPrivateProfileInt("DEBUG","MWMPW32_TRACE",0,ini_file)) {
	  modem_trc_flags |= TRACE_MWMPW32;
	}
	if (GetPrivateProfileInt("DEBUG","MWMUTIL_TRACE",0,ini_file)) {
	  modem_trc_flags |= TRACE_MWMUTIL;
	}
	if (GetPrivateProfileInt("DEBUG","MWWTT32_TRACE",0,ini_file)) {
	  modem_trc_flags |= TRACE_MWWTT32;
	}
        if (GetPrivateProfileInt("DEBUG","MWM_BL",0,ini_file)) {
	  modem_trc_flags |= TRACE_MWMBL;
        }

	fprintf(stdout,"mwave modem, initializing mwave manager...");
 	fflush(stdout);
	bRC = MwaveAPIInit(TRUE);
        if (bRC) {
	  fprintf(stdout,"OK\n");
        } else {
          fprintf(stdout,"ERROR\n");
	  exit(1);
        }
	fflush(stdout);

	usPCMValue = GetPrivateProfileInt("FEATURES", "PCM", 0, ini_file);
	usV34EMEnabled = GetPrivateProfileInt("FEATURES","V34EM",0,ini_file);
	usAllSpeeds = GetPrivateProfileInt( "OPTIONS", "ALLSPEEDS", 0, ini_file);

	fprintf(stdout,"mwave modem, initializing modem specific code...");
	fflush(stdout);
	pmwmDspInfo = mwmSpcfcInitialize((PVOID)ini_file, &InstanceInfo, usPCMValue);
	if(!pmwmDspInfo) {
		fprintf(stdout,"ERROR\n");
		fflush(stdout);
		exit(1);
	} else {
		fprintf(stdout,"OK\n");
		fflush(stdout);
	}/*if-else*/

	fprintf(stdout,"mwave modem, getting configured startup speed...");
	fflush(stdout);

        GetPrivateProfileString("STARTUP","SPEED", "14400",
			szStartspeed, sizeof(szStartspeed), ini_file);

	fprintf(stdout, "%s.\n", szStartspeed);
	fflush(stdout);

	switch((USHORT)atoi(szStartspeed)) {
		case 2400:
			sModemStartSpeed = MW_START2400;
			break;
		case 9600:
			sModemStartSpeed = MW_START9600;
			break;
		case 14400:
			sModemStartSpeed = MW_START14400;
			break;
		case 19200:
			sModemStartSpeed = MW_START19200;
			break;
		case 28800:
		case 33600:
			if (!usAllSpeeds) {
				if (usV34EMEnabled) {
					sModemStartSpeed = MW_START33600;
				} else {
					sModemStartSpeed = MW_START28800;
				} /* endif */
			} else {
				if ((USHORT)atoi(szStartspeed) == 33600 && usV34EMEnabled) {
					sModemStartSpeed = MW_START33600;
				} else {
					sModemStartSpeed = MW_START28800;
				} /* endif */
			} /* endif */
			break;
		case 64000:
			if (usPCMValue) {
				sModemStartSpeed = MW_START64000;
			} else {
				if (usV34EMEnabled) {
					sModemStartSpeed = MW_START33600;
				} else {
					sModemStartSpeed = MW_START28800;
				} /* endif */
			} /* endif */
			break;
		default:
			sModemStartSpeed = MW_BADPARAMETER;
			break;
	}/*case*/

	mwmParseActivateTimeStamp(TRUE);

	fprintf(stdout,"mwave modem, checking configured speed...");
	fflush(stdout);
	sModemStartSpeed = mwmSpcfcCheckSpeedParm(pmwmDspInfo,sModemStartSpeed);
	if (sModemStartSpeed == MW_BADPARAMETER) {
		fprintf(stdout,"ERROR\n");
		fflush(stdout);
		exit(1);
	} else {
		fprintf(stdout,"OK\n");
		fflush(stdout);
	}/*if-else*/

	fprintf(stdout,"mwave modem, setting modem speed...");
	fflush(stdout);
	ulRC = mwmSpcfcSetSpeed(pmwmDspInfo, sModemStartSpeed, 0);
	if(ulRC) {
		fprintf(stdout,"ERROR\n");
		fflush(stdout);
	} else {
		fprintf(stdout,"OK\n");
		fflush(stdout);
	}/*if-else*/

	fprintf(stdout,"mwave modem, loading modem DSP...");
	fflush(stdout);
	ulRC = mwmSpcfcLoadModem(pmwmDspInfo);
	if(ulRC) {
		fprintf(stdout,"ERROR\n");
		fflush(stdout);
	} else {
	        fprintf(stdout,"OK.\n");
		fflush(stdout);
	        fprintf(stdout,"mwave modem STARTED. To setup serial port use:   'setserial /dev/ttySx autoconfig' \n"); 
	        //fprintf(stdout,"mwave modem STARTED.\n"); 
                fflush(stdout);
                // Note: mwmParseHandleMessage replaces the message processing
		//  code from mwmw32/mwmwin.c
		// This routine waits handles messages from mwmParsePostMessage
		//  on this thread.
	        mwmHandleMessage(pmwmDspInfo);
		fprintf(stdout,"mwave modem...Exiting.\n");
		fflush(stdout);
	}/*if-else*/

	exit(0);

}/*main*/


