/*
 *   mwmcapi.c -- Mwave Modem AT Command Parser
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include <mwmspcfc.h>
#include <mwmcntnd.h>
#include <mwmcapi.h>
static char szThisFile[] = "mwmcapi.c";

HMWMODEM hGlobalModem = 1;

unsigned long MWM_ENTRY  mwmOpen( unsigned short usCommNumber,
                                  PHMWMODEM phModem,
                                  PULONG  pulRate,
                                  PHMTASK phmtAsync,
                                  PHMTASK phmtUart,
                                  unsigned short usFlags)
{

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcapi::mwmOpen entry\n");  }

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcapi::mwmOpen exit\n");  }


  return 0;
}

unsigned long MWM_ENTRY  mwmClose(HMWMODEM hModem)
{
  ULONG ulRC;

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcapi::mwmClose entry\n");  }


  if (hModem != hGlobalModem)
    return MWM_BADHANDLE;

  /***************************************************************************/
  /* Return to UART Mode if we were in DMA Mode....                          */
  /***************************************************************************/
  if (pGlobalDspInfo)
  {
    if (pGlobalDspInfo->usUARTMode & USE_DMA)
    {
      ulRC = mwmcapiMoveDMAToUART(pGlobalDspInfo);
      if (ulRC)
        return MWM_MWAVEDSPERROR;
    }
  }

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcapi::mwmClose exit\n");  }

  return 0;
}


ULONG mwmcapiMoveUARTToDMA(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG ulRC;

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcapi::mwmcapiMoveUARTToDMA entry\n");  }



  ulRC=dspDisconnectGPC(pmwmDspInfo->hasyTask,"UART_INPUT",
                        NULL,"UART_INPUT");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return ulRC;
  }


  ulRC=dspDisconnectGPC(NULL,"UART_OUTPUT",
                        pmwmDspInfo->hasyTask,"UART_OUTPUT");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return ulRC;
  }


  /***************************************************************************/
  ulRC=dspDisconnectITCB(pmwmDspInfo->hasyTask,"OEITCB",
                         NULL,"OEITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return ulRC;
  }


  ulRC=dspDisconnectITCB(NULL,"UARTITCB",
                         pmwmDspInfo->hasyTask,"U_RTITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return ulRC;
  }


  /***************************************************************************/
  /* Disconnect MEIO from UART                                               */
//  ulRC = dspMeioConnect(pmwmDspInfo->hMEIO,&pmwmDspInfo->hConnectUart,COMMTX_1,UARTOUT_1,
//           MY_OWNER_PORT|MY_USER_PORT|MY_CONNECTION,UNCHANGED,0);
  /***************************************************************************/
  ulRC = dspMeioDisconnect(pmwmDspInfo->hConnectUart,0);
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return ulRC;
  }



  ulRC=dspDisconnectITCB(NULL,"UARTITCB",
                         pmwmDspInfo->hmctlTask,"UARTITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return ulRC;
  }

  pmwmDspInfo->hmtUART = 0;

  /***************************************************************************/
  /* UART should now be unloaded....Load the new UART replacement task       */
  /***************************************************************************/
  ulRC = mwmCntndLoadModule(pmwmDspInfo,"UARTDMA","UARTDMA",
                            &pmwmDspInfo->hmodFakeUART,szThisFile,__LINE__);
  if (ulRC != DSP_NOERROR)
    return ulRC;

  ulRC = dspNameToTaskHandle(pmwmDspInfo->hmodFakeUART, "UARTDMA",
                             &pmwmDspInfo->hmtFakeUART);
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR,
                   ulRC);
    return(ulRC);
  }



  ulRC=dspConnectITCB(pmwmDspInfo->hasyTask,"OEITCB",pmwmDspInfo->hmtFakeUART,"ODMAITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }



  ulRC=dspConnectITCB(pmwmDspInfo->hmtFakeUART,"UDMAITCB",pmwmDspInfo->hasyTask,"U_RTITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  ulRC=dspConnectITCB(pmwmDspInfo->hmtFakeUART,"UDMAITCB",pmwmDspInfo->hmctlTask,"UARTITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  ulRC = dspChangeModuleState(pmwmDspInfo->hmodFakeUART, DSP_ACTIVATE_ACTIVE );
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }

  pmwmDspInfo->usUARTMode = USE_DMA;


  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcapi::mwmcapiMoveUARTToDMA exit\n");  }


  return 0;
}





ULONG mwmcapiMoveDMAToUART(PMWM_DSPINFO pmwmDspInfo)
{
  ULONG ulRC;


  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcapi::mwmcapiMoveDMAToUART entry\n");  }



  /***************************************************************************/
  /* Unload Fake UART...                                                     */
  /***************************************************************************/
  ulRC = dspFreeModule(pmwmDspInfo->hmodFakeUART);
  if (!ulRC)
  {
    pmwmDspInfo->hmodFakeUART = NULL;
    pmwmDspInfo->hmtFakeUART = NULL;
  }

  /***************************************************************************/
  /* Connect (implicitly load) Real UART.                                    */
  /***************************************************************************/

  ulRC=mwmCntndConnectGPC(pmwmDspInfo->hasyTask,"UART_INPUT",NULL,"UART_INPUT",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);


  ulRC=mwmCntndConnectGPC(NULL,"UART_OUTPUT",pmwmDspInfo->hasyTask,"UART_OUTPUT",0,NULL,
                          pmwmDspInfo, szThisFile,__LINE__ );
  if (ulRC)
    return(ulRC);




  ulRC=dspConnectITCB(pmwmDspInfo->hasyTask,"OEITCB",NULL,"OEITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }



  ulRC=dspConnectITCB(NULL,"UARTITCB",pmwmDspInfo->hasyTask,"U_RTITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }


  ulRC = dspMeioConnect(hMEIO,&pmwmDspInfo->hConnectUart,COMMTX_1,UARTOUT_1,
           MY_OWNER_PORT|MY_USER_PORT|MY_CONNECTION,UNCHANGED,0);



  ulRC=dspConnectITCB(NULL,"UARTITCB",pmwmDspInfo->hmctlTask,"UARTITCB");
  if (ulRC != DSP_NOERROR)
  {
    mwmHandleError(pInstanceInfo,szThisFile,__LINE__,
                   MWM_DSP_ERROR, ulRC);
    return(ulRC);
  }


  pmwmDspInfo->usUARTMode = USE_UART;

  { MW_SYSLOG_1(TRACE_MWMLW32,"mwmcapi::mwmcapiMoveDMAToUART exit\n");  }


  return 0;
}

