<?php
/**
 * This file is part of MythWeb, a php-based interface for MythTV.
 * See http://www.mythtv.org/ for details.
 *
 * Initialization routines.  This file basically loads all of the necessary
 * shared files for the entire program.
 *
 * @url         $URL: http://svn.mythtv.org/svn/branches/release-0-21-fixes/mythplugins/mythweb/includes/init.php $
 * @date        $Date: 2007-12-31 14:38:38 -0600 (Mon, 31 Dec 2007) $
 * @version     $Revision: 15274 $
 * @author      $Author: xris $
 * @license     GPL
 *
 * @package     MythWeb
 *
/**/

// Load the generic utilities so we have access to stuff like DEBUG()
    require_once 'includes/utils.php';

// Clean up some stuff
    require_once 'includes/cleanup.php';

// Define some common stuff
    require_once 'includes/defines.php';

// Check out the php version info
    require_once 'includes/php_version_check.php';

// Load the error trapping and display routines
    require_once 'includes/errors.php';
    require_once 'includes/errordisplay.php';

// Setup the database
    require_once 'includes/database.php';

// Make sure the database is up to date
    require_once 'includes/db_update.php';

// Load the session handler routines
    require_once 'includes/session.php';

// Load the translation routines so the modules can translate their descriptions
    require_once 'includes/translate.php';

// Include a few useful functions
    require_once 'includes/css.php';
    require_once 'includes/mouseovers.php';

// Connect to the backend and load some more handy utilities
    require_once 'includes/mythbackend.php';

// Detect mobile users
    require_once 'includes/mobile.php';

// Setup the skins and themes
    require_once 'includes/skin.php';

// Setup the modules
    require_once 'includes/modules.php';

// Setup the data_dir
    require_once 'includes/data_dir.php';

// Load the session defaults and other config info
    require_once 'includes/config.php';

