#! /usr/bin/perl
#* ============================================================
# * File  : omroep/rss.pl
# * Author: Eric
# * Date  : 2006-09-30
# * Description: parses http://www.uitzendinggemist.nl/index.php/rss
# *
# * Requires:
# * - mythstream v0.17_2
# *
# * To use this parser
# *  add this stream item in MythStream:
# *      Stream Name   : Uitzending gemist RSS
# *      Stream URL    : http://www.uitzendinggemist.nl/index.php/rss
# *      Stream Handler: omroep/rss
# * ============================================================ */


    
use English;
use XML::Simple;
use XML::DOM;

$xml = new XML::Simple;

my $doc = XML::DOM::Document->new;
my $head = $doc->createXMLDecl ('1.0');
my $root = $doc->createElement('items');

sub newNode
{
  local $name  = shift;
  local $value = shift;
  local $node = $doc->createElement($name);
  local $text = $doc->createTextNode($value);
  $node->appendChild($text);
  
  return $node;
}

#------------------------------------------------------------------------------
# Init and Run
#------------------------------------------------------------------------------

&read_parse();    # get commandline parameters into @in
$source = $in[0]; # source filename from command line


eval { $data = $xml->XMLin($source); };

$data = $data->{channel};

foreach my $entry (@{$data->{item}})
{ 
  $descr = "";
  $descr = $entry->{description} . "";
  if ($descr eq "" ) {$descr = "[emptystring]"; }
    

  $url = $entry->{link};
  $url =~ s/\s//g;
  $date = $entry->{pubDate};

  if ($url ne "")
  {
    $item = $doc->createElement('item');
    $root->appendChild($item);
  
    $item->appendChild( newNode('name' , $entry->{title} . " ($date)" ) );
    $item->appendChild( newNode('url'  , $url) );
    $item->appendChild( newNode('descr', $descr ) );
    $item->appendChild( newNode('handler', 'omroep/mediaurl' ) );

    $meta = $doc->createElement('meta');
    $meta->appendChild( newNode('name'   , 'beschrijving') );
    $meta->appendChild( newNode('content', $descr) );
    $meta->appendChild( newNode('viewer' , 'text') );
  
    $item->appendChild( $meta );
  }


}


print $head->toString;
print $root->toString;
print "\n";


# (myth)stream(tuned) expects the following xml output (descr, handler, meta nodes are optional)
# 
# <items>
#   <item>
#      <name>stream name</name>
#      <url>stream url</url>
#      <descr>stream description</descr>                      
#      <handler>handling hint* or parser script name</handler>   
#      <meta>                                                      
#         <name>meta data name</name>
#         <content>the meta data</content>
#         <viewer>viewer*</viewer>
#      </meta>
#      <meta>                                                
#         <name>meta data name</name>
#         <content></content>
#         <viewer></viewer>
#      </meta>
#      ...
#   </item>
#   <item>
#      <name>stream name</name>
#      <url>stream url</url>
#      <descr>stream description</descr>                    
#      <handler></handler>   
#   </item>
#   ...
# </items>  

# *handling hint: STREAM_* (e.g. STREAM_DL starts file download)
# *viewer: text, html, inline

#--------------------------------------------------------------------------------
# get command line parameters
#--------------------------------------------------------------------------------

sub read_parse {
  local (*in) = @_ if @_;
  local ($i);
  push(@in, @ARGV);
  foreach $i (0 .. $#in) { $in[$i] =~ s/\+/ /g;}
  return scalar(@in);
}


