#!/usr/bin/perl
#
# shoutcast parser v0.01 by R. de Vos
# made by the example of icecast.pl 
#
#
# for mythstream and streamtuned (http://home.kabelfoon.nl/~moongies/streamtuned.html)  
# 
# i use it with urls like this.
# http://www.shoutcast.com/directory/index.phtml?s=<search>
# http://www.shoutcast.com/directory/index.phtml?sgenre=Techno
# http://www.shoutcast.com/directory/?s=venezuela
# http://www.shoutcast.com?s=comedy
# 
# todo: parse webpage beter and show bitrates of the streams

use HTML::TokeParser;
use English;
use XML::Simple;
use XML::DOM;

# create object
$xml = new XML::Simple;

my $doc = XML::DOM::Document->new;
my $head = $doc->createXMLDecl ('1.0');
my $root = $doc->createElement('items');

sub newNode
{
  local $name  = shift;
  local $value = shift;
  local $node = $doc->createElement($name);
  local $text = $doc->createTextNode($value);
  $node->appendChild($text);
  
  return $node;
}

&read_parse();    # get commandline parameters into @in
$source = $in[0]; # source filename from command line


$p = HTML::TokeParser->new(shift||"$source");

### system("cp $source /tmp/proef.html");

while (my $token = $p->get_tag("a"))
{
  my $temp2 = $token->[1]{href} || "-";
  if ($temp2 =~ /playlist\.pls/)
  {
#  print "<$temp2>\n";
  $token=$p->get_tag("font");
  my $description=$p->get_trimmed_text("br");
  my $url="http://www.shoutcast.com/$temp2";
  $item = $doc->createElement('item');
  $root->appendChild($item);
  
  if ($description =~ /\[IMG\] (.*)/)
  {
    $description = $1;
  }
  
  while (($description =~ /^ (.*)/) || ("$description" =~ /^\r(.*)/) || ("$description" =~ /^\n(.*)/))
  {
    $description = $1;
  }
  
  if ($description =~ /\[(.*)/)
  {
    $description = "\[$1";
  }
  
  $item->appendChild( newNode('name' , $description) );
  $item->appendChild( newNode('url'  , $url) );
#  $item->appendChild( newNode('descr', $entry->{genre}) );    




  }
#  if ("$temp2" eq "#001E5A")
#  {
#    my $url=$p->get_trimmed_text("/td");
#    {
#      print ">>$url\n";
#    }
# }
}

print $head->toString;
print $root->toString;
print "\n";

#--------------------------------------------------------------------------------
# get command line parameters
#--------------------------------------------------------------------------------

sub read_parse {
  local (*in) = @_ if @_;
  local ($i);
  push(@in, @ARGV);
  foreach $i (0 .. $#in) { $in[$i] =~ s/\+/ /g;}
  return scalar(@in);
}


