/* ============================================================
 * File  : main.cpp (mythstream parser)
 * Author: Eric Giesselbach <ericgies@kabelfoon.nl>
 * Date  : oct 2006
 *
 * Copyright 2006 by Eric Giesselbach

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published bythe Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */


#include <qdom.h>
#include <qregexp.h>

#include "harvester.h"

using namespace std;

QDomDocument doc("returndata");


// <nodename>nodevalue</nodename>
void addTextNode(QDomElement &elem, QString nodename, QString nodevalue)
{
  QDomElement elem1 = doc.createElement( nodename  );
  QDomText txt = doc.createTextNode( nodevalue );
  
  elem1.appendChild(txt);
  elem.appendChild(elem1);
}

//      <meta>
//         <name>meta data name</name>
//         <content></content>
//         <viewer></viewer>
//      </meta>
void addMetaNode(QDomElement &elem, QString name, QString content, QString viewer)
{
  QDomElement elem1 = doc.createElement( "meta"  );
  
  addTextNode(elem1, "name"   , name);
  addTextNode(elem1, "content", content);
  addTextNode(elem1, "viewer" , viewer);
  
  elem.appendChild(elem1);
}


int main( int argc, char **argv )
{
    QString contents;
    QString *data = &contents;

  // start as: program <filename> [<url>]
  
    if (argc < 2) 
    {
       cerr << "parser started without filename" << endl;
       exit(-1);
    }
    
    QString fileName  = argv[1];
    QString sourceUrl = "";

    if (argc > 2)
      sourceUrl = argv[2];
       
  // load file contents  
    
    if (!readTextFile(fileName, data) )
    {
      cerr << "parser cannot open file " << fileName << endl;
      exit(-1);
    }

  // parse data

    // Error in xml: & not escaped

    *data = data->replace( QRegExp("&(?!amp;)"), "&amp;");
    
    Parser* parser = new Parser();

    UrlList *list = parser->parse(*data);
    NewUrl *url;
    
  // generate xml document
    QDomElement elem;
    QDomElement root = doc.createElement( "items" );
    doc.appendChild(root);
    
    url = list->first();
    
    while (url)
    {
      elem = doc.createElement( "item" );
      root.appendChild( elem );
    
      addTextNode(elem, "name"   , url->name);
      addTextNode(elem, "url"    , url->url);
      addTextNode(elem, "descr"  , url->descr);
      if (url->handler != "") addTextNode(elem, "handler", url->handler);
     
      //addMetaNode(elem, "testname", "testcontent", "testviewer");
      
      url = list->next();
    }
    
    delete parser;
     
  // dump xml to stdout
    cout << doc.toString() << endl;
}


