/* ============================================================
 * File  : streamstatus.cpp
 * Author: Eric Giesselbach <ericgies@kabelfoon.nl>
 * Date  : 2003-12-22
 * Description : av stream handling
 *
 * Copyright 2003 by Eric Giesselbach

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published bythe Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// development snapshot, many todo's

#include <iostream>

#include <qapplication.h>
#include <qnetwork.h>
#include <qdatetime.h>
#include <qpainter.h>
#include <qdir.h>
#include <qtimer.h>
#include <qprocess.h>
#include <qstringlist.h>
#include <qdict.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qlayout.h>
#include <qregexp.h>
#include <qurl.h>
#include <math.h>

#include "speechproc.h"


using namespace std;


SpeechProc::SpeechProc(QObject *parent)
{
    myParent = parent;
    proc = NULL;
    
    QTimer *timer = new QTimer( this );
    connect( timer, SIGNAL(timeout()), this, SLOT(timerEvent()) );
    timer->start( 1000, false );

    enabled = false;
    busy = false;
}

SpeechProc::~SpeechProc()
{
    if (proc)
    {
      if ( proc->isRunning() ) proc->tryTerminate();
      //QTimer::singleShot( 1000, proc, SLOT( kill() ) );
    }

}

void SpeechProc::startService()
{
  return;
}

bool SpeechProc::isEnabled()
{
   return enabled;
}

void SpeechProc::enable(bool on)
{
   enabled = on;
}

// not needed?
void SpeechProc::timerEvent()
{
}

void SpeechProc::stopSay()
{
   if (proc)
    proc->tryTerminate();
}

void SpeechProc::say(QString text)
{
   QString buf = "";

   // text is quoted
   
   // block new lines, allow pending (goodbye)
	if (!enabled && !(pendingSay == text && text != "") )
	{
	  pendingSay = "";
	  return;
	}
	
	if (busy)
	{
		pendingSay = text;
		return;
	}

	pendingSay = "";
	
   // allow ascii chars 32..126
   text = text.replace( QRegExp("[^\x20-\x7e]"), " " );
	
   if ( !proc )
   {
     proc = new QProcess( this );
     proc->setCommunication( QProcess::Stdin |
                            QProcess::Stdout|
                            QProcess::Stderr|
                            QProcess::DupStderr );
                            
     // espeak:
     proc->addArgument( "espeak" );
     proc->addArgument( text );

     // festival:
     //proc->addArgument( "festival" );
     //proc->addArgument( "--tts" );
     //buf = text;
    
    connect( proc, SIGNAL(processExited()),
            this, SLOT(serviceExited()) );

    busy = true;
    
    if ( !proc->launch(buf) )
    {
      busy = false;
      fprintf( stderr, "error starting speech service (espeak)\n" );
    }
 
   }
}

void SpeechProc::readFromStdout()
{
   QString val = "";
   QString temp = " ";
   while ( temp != "" )
   {
     temp = QString(proc->readStdout());
     val += temp;
   }
   cout << "MythStream: Speech service says: " << val << endl;
}

void SpeechProc::readFromStderr()
{
  // is rerouted to stdout
}

void SpeechProc::serviceExited()
{
   delete proc;
   proc = NULL;
   busy = false;
   if (pendingSay != "")
   {
      say(pendingSay);
   }
   //cout << "speech stopped" << endl;
}


