#! /usr/bin/perl
#* ============================================================
# * File        : dailymotion/feed.pl
# * Version     : 0.1
# * Author      : 
# * Date        : 2007-09-02
# * Description: dailymotion rss feed parser
# *
# * Requires:
# * - mythstream v0.17_2 (I think, 0.17_1 might work)
# *
# * ============================================================ */

use English;
use XML::Simple;
use XML::DOM;
use Data::Dumper;


$xml = new XML::Simple;

my $doc = XML::DOM::Document->new;
my $head = $doc->createXMLDecl ('1.0');
my $root = $doc->createElement('items');

sub newNode
{
  local $name  = shift;
  local $value = shift;
  local $node = $doc->createElement($name);
  local $text = $doc->createTextNode($value);
  $node->appendChild($text);
  
  return $node;
}

sub checkNode
{
   local $node = shift;   
   return ( $node && !($node =~ /^HASH/) )  # deref empty hash element
}

sub addMetaNode
{
  local $node  = shift;
  local $name  = shift;
  local $type  = shift;
  
  if ( checkNode($node) )
  {
   if ($type eq '')
   {
     $type = "inline";
     if ($node =~ /\n/)           { $type = "text" }
     if ($node =~ /<.+>.+<\/.+>/) { $type = "html" }
   }
   
   $meta = $doc->createElement('meta');
   $meta->appendChild( newNode('name'   , $name) );
   $meta->appendChild( newNode('content', $node) );
   $meta->appendChild( newNode('viewer' , $type) );
   $item->appendChild( $meta );
  }
}

sub parseItem
{
  local $entry = shift;
  
  $temp = $entry->{author};
  $temp =~ s/(?:rss\@dailymotion.com\s)(.*)/$1/;
  
  if ($entry->{link} ne "")
  {
    $item = $doc->createElement('item');
    $item->appendChild( newNode('name'   , $entry->{title} . " $temp") );
    $item->appendChild( newNode('url'    , $entry->{link}) );
    $item->appendChild( newNode('descr'  , $entry->{pubDate}) );
    $item->appendChild( newNode('handler', 'dailymotion/show') );
    $root->appendChild($item);
  
  
    addMetaNode($entry->{description}, 'description', 'html');
    addMetaNode($entry->{author}, 'author', 'inline');
  }
}

#------------------------------------------------------------------------------
# Init and Run
#------------------------------------------------------------------------------

&read_parse();    # get commandline parameters into @in
$source = $in[0]; # source filename from command line

eval{ $data = $xml->XMLin($source); };


$channel = $data->{channel};

#print Dumper($channel->{item});

if ( ref($channel->{item}) eq 'ARRAY' )
{
  foreach my $entry (@{$channel->{item}}) { parseItem($entry); }
}
  else
{
  parseItem($channel->{item});
}

print $head->toString;
print $root->toString;
print "\n";

#--------------------------------------------------------------------------------
# get command line parameters
#--------------------------------------------------------------------------------

sub read_parse {
  local (*in) = @_ if @_;
  local ($i);
  push(@in, @ARGV);
  foreach $i (0 .. $#in) { $in[$i] =~ s/\+/ /g;}
  return scalar(@in);
}


