// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepPrimAPI_MakeHalfSpace_HeaderFile
#define _BRepPrimAPI_MakeHalfSpace_HeaderFile

#ifndef _TopoDS_Solid_HeaderFile
#include <TopoDS_Solid.hxx>
#endif
#ifndef _BRepBuilderAPI_MakeShape_HeaderFile
#include <BRepBuilderAPI_MakeShape.hxx>
#endif
class StdFail_NotDone;
class TopoDS_Face;
class gp_Pnt;
class TopoDS_Shell;
class TopoDS_Solid;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Describes functions to build half-spaces. <br>
//! A half-space is an infinite solid, limited by a surface. It <br>
//! is built from a face or a shell, which bounds it, and with <br>
//! a reference point, which specifies the side of the <br>
//! surface where the matter of the half-space is located. <br>
//! A half-space is a tool commonly used in topological <br>
//! operations to cut another shape. <br>
//! A MakeHalfSpace object provides a framework for: <br>
//! -   defining and implementing the construction of a half-space, and <br>
//! -   consulting the result. <br>
class BRepPrimAPI_MakeHalfSpace  : public BRepBuilderAPI_MakeShape {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Make a HalfSpace defined with a Face and a Point. <br>
Standard_EXPORT BRepPrimAPI_MakeHalfSpace(const TopoDS_Face& Face,const gp_Pnt& RefPnt);

//! Make a HalfSpace defined with a Shell and a Point. <br>
Standard_EXPORT BRepPrimAPI_MakeHalfSpace(const TopoDS_Shell& Shell,const gp_Pnt& RefPnt);

//! Returns the constructed half-space as a solid. <br>
Standard_EXPORT  const TopoDS_Solid& Solid() const;
Standard_EXPORT operator TopoDS_Solid() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopoDS_Solid mySolid;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
