// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepPrimAPI_MakeOneAxis_HeaderFile
#define _BRepPrimAPI_MakeOneAxis_HeaderFile

#ifndef _BRepBuilderAPI_MakeShape_HeaderFile
#include <BRepBuilderAPI_MakeShape.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
class StdFail_NotDone;
class TopoDS_Face;
class TopoDS_Shell;
class TopoDS_Solid;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! The abstract class MakeOneAxis is the root class of <br>
//! algorithms used to construct rotational primitives. <br>
class BRepPrimAPI_MakeOneAxis  : public BRepBuilderAPI_MakeShape {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! The inherited commands should provide the algorithm. <br>
//!          Returned as a pointer. <br>
Standard_EXPORT virtual  Standard_Address OneAxis()  = 0;

//! Stores the solid in myShape. <br>
Standard_EXPORT virtual  void Build() ;

//! Returns the lateral face of the rotational primitive. <br>
//! <br>
Standard_EXPORT  const TopoDS_Face& Face() ;
Standard_EXPORT operator TopoDS_Face();

//! Returns the constructed rotational primitive as a shell. <br>
Standard_EXPORT  const TopoDS_Shell& Shell() ;
Standard_EXPORT operator TopoDS_Shell();

//! Returns the constructed rotational primitive as a solid. <br>
Standard_EXPORT  const TopoDS_Solid& Solid() ;
Standard_EXPORT operator TopoDS_Solid();





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
