// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Contap_ContAna_HeaderFile
#define _Contap_ContAna_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _GeomAbs_CurveType_HeaderFile
#include <GeomAbs_CurveType.hxx>
#endif
#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
#ifndef _gp_Dir_HeaderFile
#include <gp_Dir.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _gp_Circ_HeaderFile
#include <gp_Circ.hxx>
#endif
class StdFail_NotDone;
class Standard_DomainError;
class Standard_OutOfRange;
class gp_Sphere;
class gp_Dir;
class gp_Pnt;
class gp_Cylinder;
class gp_Cone;
class gp_Lin;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class provides the computation of the contours <br>
//!          for quadric surfaces. <br>
class Contap_ContAna  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT Contap_ContAna();


Standard_EXPORT   void Perform(const gp_Sphere& S,const gp_Dir& D) ;


Standard_EXPORT   void Perform(const gp_Sphere& S,const gp_Dir& D,const Standard_Real Ang) ;


Standard_EXPORT   void Perform(const gp_Sphere& S,const gp_Pnt& Eye) ;


Standard_EXPORT   void Perform(const gp_Cylinder& C,const gp_Dir& D) ;


Standard_EXPORT   void Perform(const gp_Cylinder& C,const gp_Dir& D,const Standard_Real Ang) ;


Standard_EXPORT   void Perform(const gp_Cylinder& C,const gp_Pnt& Eye) ;


Standard_EXPORT   void Perform(const gp_Cone& C,const gp_Dir& D) ;


Standard_EXPORT   void Perform(const gp_Cone& C,const gp_Dir& D,const Standard_Real Ang) ;


Standard_EXPORT   void Perform(const gp_Cone& C,const gp_Pnt& Eye) ;

  Standard_Boolean IsDone() const;

  Standard_Integer NbContours() const;
//! Returns GeomAbs_Line or GeomAbs_Circle, when <br>
//!          IsDone() returns True. <br>
  GeomAbs_CurveType TypeContour() const;

  gp_Circ Circle() const;


Standard_EXPORT   gp_Lin Line(const Standard_Integer Index) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean done;
Standard_Integer nbSol;
GeomAbs_CurveType typL;
gp_Pnt pt1;
gp_Pnt pt2;
gp_Pnt pt3;
gp_Pnt pt4;
gp_Dir dir1;
gp_Dir dir2;
gp_Dir dir3;
gp_Dir dir4;
Standard_Real prm;


};


#include <Contap_ContAna.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
