// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Dynamic_DynamicClass_HeaderFile
#define _Dynamic_DynamicClass_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Dynamic_DynamicClass_HeaderFile
#include <Handle_Dynamic_DynamicClass.hxx>
#endif

#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
#ifndef _Handle_Dynamic_ParameterNode_HeaderFile
#include <Handle_Dynamic_ParameterNode.hxx>
#endif
#ifndef _Handle_Dynamic_SequenceOfMethods_HeaderFile
#include <Handle_Dynamic_SequenceOfMethods.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Handle_Dynamic_Parameter_HeaderFile
#include <Handle_Dynamic_Parameter.hxx>
#endif
#ifndef _Handle_Dynamic_Method_HeaderFile
#include <Handle_Dynamic_Method.hxx>
#endif
#ifndef _Handle_Dynamic_DynamicInstance_HeaderFile
#include <Handle_Dynamic_DynamicInstance.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class TCollection_HAsciiString;
class Dynamic_ParameterNode;
class Dynamic_SequenceOfMethods;
class Dynamic_Parameter;
class Dynamic_Method;
class Dynamic_DynamicInstance;


//! A  dynamic class  is  defined   as a  sequence  of <br>
//!          parameters and   as a   sequence of   methods. The <br>
//!          specifications  are similar   to C++  classes. The <br>
//!          class  has  to  be   defined  in terms  of  fields <br>
//!          (Parameters) and methods. An instance of the class <br>
//!          must be   made to set  the  fields and to  use the <br>
//!          functionalities. <br>
class Dynamic_DynamicClass : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Creates a new empty instance of DynamicClass. <br>
Standard_EXPORT Dynamic_DynamicClass(const Standard_CString aname);

//! Adds another parameter <aparameter> to the sequence of <br>
//!          parameter definitions. <br>
Standard_EXPORT   void Parameter(const Handle(Dynamic_Parameter)& aparameter) ;

//! Adds another method to the sequence of methods. It has <br>
//!          <amethod> as name  and <anaddress> as mangled  name of <br>
//!          the corresponding C++ function which must be called. <br>
Standard_EXPORT   void CompiledMethod(const Standard_CString amethod,const Standard_CString anaddress) ;

//! Adds  another method to the  sequence of methods.   It <br>
//!          has <amethod> as name and <afile> as interpreted file. <br>
Standard_EXPORT   void InterpretedMethod(const Standard_CString amethod,const Standard_CString afile) ;

//! Returns a reference to the method object identified by <br>
//!          the string <amethod>. <br>
Standard_EXPORT virtual  Handle_Dynamic_Method Method(const Standard_CString amethod) const;

//! Returns an instance object of this class. <br>
Standard_EXPORT virtual  Handle_Dynamic_DynamicInstance Instance() const;

//! useful for debugging. <br>
Standard_EXPORT virtual  void Dump(Standard_OStream& astream) const;
//Standard_EXPORT ~Dynamic_DynamicClass();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_TCollection_HAsciiString thename;
Handle_Dynamic_ParameterNode thefirstparameternode;
Handle_Dynamic_SequenceOfMethods thesequenceofmethods;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
