// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Geom2dAPI_Interpolate_HeaderFile
#define _Geom2dAPI_Interpolate_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_TColgp_HArray1OfPnt2d_HeaderFile
#include <Handle_TColgp_HArray1OfPnt2d.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Geom2d_BSplineCurve_HeaderFile
#include <Handle_Geom2d_BSplineCurve.hxx>
#endif
#ifndef _Handle_TColgp_HArray1OfVec2d_HeaderFile
#include <Handle_TColgp_HArray1OfVec2d.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfBoolean_HeaderFile
#include <Handle_TColStd_HArray1OfBoolean.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfReal_HeaderFile
#include <Handle_TColStd_HArray1OfReal.hxx>
#endif
class TColgp_HArray1OfPnt2d;
class Geom2d_BSplineCurve;
class TColgp_HArray1OfVec2d;
class TColStd_HArray1OfBoolean;
class TColStd_HArray1OfReal;
class StdFail_NotDone;
class Standard_ConstructionError;
class gp_Vec2d;
class TColgp_Array1OfVec2d;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This  class  is  used  to  interpolate a  BsplineCurve <br>
//! passing   through  an  array  of  points,  with  a  C2 <br>
//! Continuity if tangency is not requested at the point. <br>
//! If tangency is requested at the point the continuity will <br>
//! be C1.  If Perodicity is requested the curve will be closed <br>
//! and the junction will be the first point given. The curve will than be only C1 <br>
//! The curve is defined by a table of points through which it passes, and if required <br>
//! by a parallel table of reals which gives the value of the parameter of each point through <br>
//!  which the resulting BSpline curve passes, and by vectors tangential to these points. <br>
//! An Interpolate object provides a framework for: defining the constraints of the BSpline curve, <br>
//! -   implementing the interpolation algorithm, and consulting the results. <br>
class Geom2dAPI_Interpolate  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Tolerance is to check if the points are not too close to one an other <br>
//! It is also used to check if the tangent vector is not too small. <br>
//! There should be at least 2 points <br>
//! if PeriodicFlag is True then the curve will be periodic. <br>
Standard_EXPORT Geom2dAPI_Interpolate(const Handle(TColgp_HArray1OfPnt2d)& Points,const Standard_Boolean PeriodicFlag,const Standard_Real Tolerance);

//! if PeriodicFlag is True then the curve will be periodic <br>
//!  Warning: <br>
//!  There should be as many parameters as there are points <br>
//!  except if PeriodicFlag is True : then there should be one more <br>
//!  parameter to close the curve <br>
Standard_EXPORT Geom2dAPI_Interpolate(const Handle(TColgp_HArray1OfPnt2d)& Points,const Handle(TColStd_HArray1OfReal)& Parameters,const Standard_Boolean PeriodicFlag,const Standard_Real Tolerance);

//! Assigns this constrained BSpline curve to be <br>
//! tangential to vectors InitialTangent and FinalTangent <br>
//!   at its first and last points respectively (i.e. <br>
//!   the first and last points of the table of <br>
//!   points through which the curve passes, as <br>
//!   defined at the time of initialization). <br>
Standard_EXPORT   void Load(const gp_Vec2d& InitialTangent,const gp_Vec2d& FinalTangent) ;

//!  Assigns this constrained BSpline curve to be <br>
//! tangential to vectors defined in the table Tangents, <br>
//!   which is parallel to the table of points <br>
//!   through which the curve passes, as <br>
//!   defined at the time of initialization. Vectors <br>
//!   in the table Tangents are defined only if <br>
//!   the flag given in the parallel table <br>
//!   TangentFlags is true: only these vectors <br>
//!   are set as tangency constraints. <br>
Standard_EXPORT   void Load(const TColgp_Array1OfVec2d& Tangents,const Handle(TColStd_HArray1OfBoolean)& TangentFlags) ;

//! Clears all tangency constraints on this <br>
//! constrained BSpline curve (as initialized by the function Load). <br>
Standard_EXPORT   void ClearTangents() ;

//! Computes the constrained BSpline curve. Use the function IsDone to verify that the <br>
//! computation is successful, and then the function Curve to obtain the result. <br>
Standard_EXPORT   void Perform() ;

//! Returns the computed BSpline curve. Raises  StdFail_NotDone if the interpolation fails. <br>
Standard_EXPORT  const Handle_Geom2d_BSplineCurve& Curve() const;
Standard_EXPORT operator Handle(Geom2d_BSplineCurve)() const;

//! Returns true if the constrained BSpline curve is successfully constructed. <br>
//! Note: in this case, the result is given by the function Curve. <br>
Standard_EXPORT   Standard_Boolean IsDone() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

//! Interpolates in a non periodic fashion <br>
Standard_EXPORT   void PerformNonPeriodic() ;

//! Interpolates in a C1 periodic fashion <br>
Standard_EXPORT   void PerformPeriodic() ;


 // Fields PRIVATE
 //
Standard_Real myTolerance;
Handle_TColgp_HArray1OfPnt2d myPoints;
Standard_Boolean myIsDone;
Handle_Geom2d_BSplineCurve myCurve;
Handle_TColgp_HArray1OfVec2d myTangents;
Handle_TColStd_HArray1OfBoolean myTangentFlags;
Handle_TColStd_HArray1OfReal myParameters;
Standard_Boolean myPeriodic;
Standard_Boolean myTangentRequest;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
