// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GeomTools_HeaderFile
#define _GeomTools_HeaderFile

#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
#ifndef _Standard_IStream_HeaderFile
#include <Standard_IStream.hxx>
#endif
#ifndef _Handle_Geom_Curve_HeaderFile
#include <Handle_Geom_Curve.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
#ifndef _Handle_GeomTools_UndefinedTypeHandler_HeaderFile
#include <Handle_GeomTools_UndefinedTypeHandler.hxx>
#endif
class Geom_Surface;
class Geom_Curve;
class Geom2d_Curve;
class GeomTools_UndefinedTypeHandler;
class GeomTools_UndefinedTypeHandler;
class GeomTools_SurfaceSet;
class GeomTools_CurveSet;
class GeomTools_Curve2dSet;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! The GeomTools package provides  utilities for Geometry. <br>
//! <br>
//!          *  SurfaceSet,  CurveSet, Curve2dSet  : Tools used <br>
//!          for dumping, writing and reading. <br>
//! <br>
//!          * Methods to dump, write, read curves and surfaces. <br>
class GeomTools  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Dumps the surface on the stream. <br>
Standard_EXPORT static  void Dump(const Handle(Geom_Surface)& S,Standard_OStream& OS) ;

//! Writes the surface on the stream. <br>
Standard_EXPORT static  void Write(const Handle(Geom_Surface)& S,Standard_OStream& OS) ;

//! Reads the surface from the stream. <br>
Standard_EXPORT static  void Read(Handle(Geom_Surface)& S,Standard_IStream& IS) ;

//! Dumps the Curve on the stream. <br>
Standard_EXPORT static  void Dump(const Handle(Geom_Curve)& C,Standard_OStream& OS) ;

//! Writes the Curve on the stream. <br>
Standard_EXPORT static  void Write(const Handle(Geom_Curve)& C,Standard_OStream& OS) ;

//! Reads the Curve from the stream. <br>
Standard_EXPORT static  void Read(Handle(Geom_Curve)& C,Standard_IStream& IS) ;

//! Dumps the Curve on the stream. <br>
Standard_EXPORT static  void Dump(const Handle(Geom2d_Curve)& C,Standard_OStream& OS) ;

//! Writes the Curve on the stream. <br>
Standard_EXPORT static  void Write(const Handle(Geom2d_Curve)& C,Standard_OStream& OS) ;

//! Reads the Curve from the stream. <br>
Standard_EXPORT static  void Read(Handle(Geom2d_Curve)& C,Standard_IStream& IS) ;


Standard_EXPORT static  void SetUndefinedTypeHandler(const Handle(GeomTools_UndefinedTypeHandler)& aHandler) ;


Standard_EXPORT static  Handle_GeomTools_UndefinedTypeHandler GetUndefinedTypeHandler() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //

friend class GeomTools_UndefinedTypeHandler;
friend class GeomTools_SurfaceSet;
friend class GeomTools_CurveSet;
friend class GeomTools_Curve2dSet;

};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
