// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Geom_BoundedSurface_HeaderFile
#define _Geom_BoundedSurface_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Geom_BoundedSurface_HeaderFile
#include <Handle_Geom_BoundedSurface.hxx>
#endif

#ifndef _Geom_Surface_HeaderFile
#include <Geom_Surface.hxx>
#endif


//! The root class for bounded surfaces in 3D space. A <br>
//! bounded surface is defined by a rectangle in its 2D parametric space, i.e. <br>
//! - its u parameter, which ranges between two finite <br>
//!   values u0 and u1, referred to as "First u <br>
//!   parameter" and "Last u parameter" respectively, and <br>
//! - its v parameter, which ranges between two finite <br>
//!   values v0 and v1, referred to as "First v <br>
//!   parameter" and the "Last v parameter" respectively. <br>
//!   The surface is limited by four curves which are the <br>
//! boundaries of the surface: <br>
//! - its u0 and u1 isoparametric curves in the u parametric direction, and <br>
//! - its v0 and v1 isoparametric curves in the v parametric direction. <br>
//! A bounded surface is finite. <br>
//! The common behavior of all bounded surfaces is <br>
//! described by the Geom_Surface class. <br>
//! The Geom package provides three concrete <br>
//! implementations of bounded surfaces: <br>
//! - Geom_BezierSurface, <br>
//! - Geom_BSplineSurface, and <br>
//! - Geom_RectangularTrimmedSurface. <br>
//!  The first two of these implement well known <br>
//! mathematical definitions of complex surfaces, the third <br>
//! trims a surface using four isoparametric curves, i.e. it <br>
//! limits the variation of its parameters to a rectangle in <br>
//! 2D parametric space. <br>
class Geom_BoundedSurface : public Geom_Surface {

public:
 // Methods PUBLIC
 // 
//Standard_EXPORT ~Geom_BoundedSurface();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
