// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Graphic3d_VertexN_HeaderFile
#define _Graphic3d_VertexN_HeaderFile

#ifndef _Standard_ShortReal_HeaderFile
#include <Standard_ShortReal.hxx>
#endif
#ifndef _Graphic3d_Vertex_HeaderFile
#include <Graphic3d_Vertex.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Graphic3d_Vertex;
class Graphic3d_Vector;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class allows the creation and update of <br>
//!	    a vertex with a 3D normal. <br>
class Graphic3d_VertexN  : public Graphic3d_Vertex {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates a point with 0.0, 0.0, 0.0 coordinates <br>
//!	    for which the normal is 0.0, 0.0, 1.0. <br>
Standard_EXPORT Graphic3d_VertexN();

//! Creates a point with coordinates <AX>, <AY>, <AZ> and <br>
//!	    for which the normal is <ANX>, <ANY>, <ANZ>. <br>
//!	    If <FlagNormalise> is True the normal is already normalised <br>
//!	    Else the normal is not normalised, the graphic do it. <br>
Standard_EXPORT Graphic3d_VertexN(const Standard_Real AX,const Standard_Real AY,const Standard_Real AZ,const Standard_Real ANX,const Standard_Real ANY,const Standard_Real ANZ,const Standard_Boolean FlagNormalise = Standard_True);

//! Creates a point in <APoint> for which the normal is <AVector>. <br>
//!	    If <FlagNormalise> is True the normal is already normalised <br>
//!	    Else the normal is not normalised, the graphic do it. <br>
Standard_EXPORT Graphic3d_VertexN(const Graphic3d_Vertex& APoint,const Graphic3d_Vector& AVector,const Standard_Boolean FlagNormalise = Standard_True);

//! Modifies the normal to the point <me>. <br>
//!	    If <FlagNormalise> is True the normal is already normalised <br>
//!	    Else the normal is not normalised, the graphic do it. <br>
Standard_EXPORT   void SetNormal(const Standard_Real NXnew,const Standard_Real NYnew,const Standard_Real NZnew,const Standard_Boolean FlagNormalise = Standard_True) ;

//! Returns the normal to the point <me>. <br>
Standard_EXPORT   void Normal(Standard_Real& ANX,Standard_Real& ANY,Standard_Real& ANZ) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_ShortReal MyDX;
Standard_ShortReal MyDY;
Standard_ShortReal MyDZ;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
