// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESAppli_LevelToPWBLayerMap_HeaderFile
#define _IGESAppli_LevelToPWBLayerMap_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESAppli_LevelToPWBLayerMap_HeaderFile
#include <Handle_IGESAppli_LevelToPWBLayerMap.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfInteger_HeaderFile
#include <Handle_TColStd_HArray1OfInteger.hxx>
#endif
#ifndef _Handle_Interface_HArray1OfHAsciiString_HeaderFile
#include <Handle_Interface_HArray1OfHAsciiString.hxx>
#endif
#ifndef _IGESData_IGESEntity_HeaderFile
#include <IGESData_IGESEntity.hxx>
#endif
#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
class TColStd_HArray1OfInteger;
class Interface_HArray1OfHAsciiString;
class Standard_DimensionMismatch;
class Standard_OutOfRange;
class TCollection_HAsciiString;


//! defines LevelToPWBLayerMap, Type <406> Form <24> <br>
//!          in package IGESAppli <br>
//!          Used to correlate an exchange file level number with <br>
//!          its corresponding native level identifier, physical PWB <br>
//!          layer number and predefined functional level <br>
//!          identification <br>
class IGESAppli_LevelToPWBLayerMap : public IGESData_IGESEntity {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT IGESAppli_LevelToPWBLayerMap();

//! This method is used to set the fields of the class <br>
//!           LevelToPWBLayerMap <br>
//!       - nbPropVal       : Number of property values <br>
//!       - allExchLevels   : Exchange File Level Numbers <br>
//!       - allNativeLevels : Native Level Identifications <br>
//!       - allPhysLevels   : Physical Layer Numbers <br>
//!       - allExchIdents   : Exchange File Level Identifications <br>
//! raises exception if allExchLevels, allNativeLevels, allPhysLevels <br>
//! and all ExchIdents are not of same dimensions <br>
Standard_EXPORT   void Init(const Standard_Integer nbPropVal,const Handle(TColStd_HArray1OfInteger)& allExchLevels,const Handle(Interface_HArray1OfHAsciiString)& allNativeLevels,const Handle(TColStd_HArray1OfInteger)& allPhysLevels,const Handle(Interface_HArray1OfHAsciiString)& allExchIdents) ;

//! returns number of property values <br>
Standard_EXPORT   Standard_Integer NbPropertyValues() const;

//! returns number of level to layer definitions <br>
Standard_EXPORT   Standard_Integer NbLevelToLayerDefs() const;

//! returns Exchange File Level Number <br>
//! raises exception if Index <= 0 or Index > NbLevelToLayerDefs <br>
Standard_EXPORT   Standard_Integer ExchangeFileLevelNumber(const Standard_Integer Index) const;

//! returns Native Level Identification <br>
//! raises exception if Index <= 0 or Index > NbLevelToLayerDefs <br>
Standard_EXPORT   Handle_TCollection_HAsciiString NativeLevel(const Standard_Integer Index) const;

//! returns Physical Layer Number <br>
//! raises exception if Index <= 0 or Index > NbLevelToLayerDefs <br>
Standard_EXPORT   Standard_Integer PhysicalLayerNumber(const Standard_Integer Index) const;


Standard_EXPORT   Handle_TCollection_HAsciiString ExchangeFileLevelIdent(const Standard_Integer Index) const;
//Standard_EXPORT ~IGESAppli_LevelToPWBLayerMap();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer theNbPropertyValues;
Handle_TColStd_HArray1OfInteger theExchangeFileLevelNumber;
Handle_Interface_HArray1OfHAsciiString theNativeLevel;
Handle_TColStd_HArray1OfInteger thePhysicalLayerNumber;
Handle_Interface_HArray1OfHAsciiString theExchangeFileLevelIdent;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
