// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IntPoly_PlaneSection_HeaderFile
#define _IntPoly_PlaneSection_HeaderFile

#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _gp_Trsf_HeaderFile
#include <gp_Trsf.hxx>
#endif
#ifndef _IntPoly_SequenceOfSequenceOfPnt2d_HeaderFile
#include <IntPoly_SequenceOfSequenceOfPnt2d.hxx>
#endif
#ifndef _IntPoly_IndexedMapOfPnt2d_HeaderFile
#include <IntPoly_IndexedMapOfPnt2d.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class TopoDS_Shape;
class gp_Pln;
class gp_Pnt;
class gp_Pnt2d;
class TColgp_SequenceOfPnt2d;
class TopoDS_Edge;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! determines the section of a triangulated shape by a plane. <br>
//!          The section is a set of edges. <br>
class IntPoly_PlaneSection  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT IntPoly_PlaneSection();


Standard_EXPORT IntPoly_PlaneSection(const TopoDS_Shape& S,const gp_Pln& P);


Standard_EXPORT   void Section() ;

//! determines the 2 2D-points resulting of the intersection <br>
//!          of the triangle (Point1,Point2,Point3) by the plane <br>
Standard_EXPORT   Standard_Boolean Intersect(const gp_Pnt& Point1,const gp_Pnt& Point2,const gp_Pnt& Point3,gp_Pnt2d& OutPoint1,gp_Pnt2d& OutPoint2) ;

//! sees whether OldPnt and NewPnt begins or ends a section <br>
//!          created before and adds the 2 others points. <br>
//!          If not, creates a section <br>
Standard_EXPORT   void Insert(const gp_Pnt2d& OldPnt,const gp_Pnt2d& ComPnt,const gp_Pnt2d& NewPnt) ;

//! sees whether BegPnt or EndPnt begins or ends a section <br>
//!          created before, and returns the other point to continue <br>
//!          the construction <br>
//!          Returns 2 if the construction is 'Forward' <br>
//!          Returns 1 if the construction is 'Previous' <br>
//!          Returns 0 if not and creates a section <br>
Standard_EXPORT   Standard_Integer Concat(const gp_Pnt2d& BegPnt,const gp_Pnt2d& EndPnt,gp_Pnt2d& OutPnt) ;

//! sees whether Section begins or ends another one in  mySection, <br>
//!          from the rank 'Index' to the last one 'NbSection' <br>
Standard_EXPORT   void ConcatSection(TColgp_SequenceOfPnt2d& Section,const Standard_Integer NbSection,const Standard_Integer Index) ;

//! builds a section from Point in this way <br>
//!                       ___   ___   ___   ___ <br>
//!               Point--/__/--/__/--/__/--/__/---> <br>
Standard_EXPORT   void ForwConstruction(const gp_Pnt2d& Point) ;

//! builds a section from Point in this way <br>
//!                    ___   ___   ___   ___ <br>
//!               <---/__/--/__/--/__/--/__/--Point <br>
Standard_EXPORT   void PrevConstruction(const gp_Pnt2d& Point) ;


Standard_EXPORT   Standard_Integer NbEdges() ;

//! builds an edge from a sequence of Pnt2d <br>
//!          this is a part of the section <br>
Standard_EXPORT   TopoDS_Edge Edge(const Standard_Integer Index) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopoDS_Shape myShape;
gp_Trsf myTransform;
gp_Trsf myBackTransform;
IntPoly_SequenceOfSequenceOfPnt2d mySection;
IntPoly_IndexedMapOfPnt2d myMapBegPoints;
IntPoly_IndexedMapOfPnt2d myMapEndPoints;
Standard_Integer myCpt;
Standard_Integer myIndex;
Standard_Integer myNbEdges;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
