// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _MeshVS_DataSource_HeaderFile
#define _MeshVS_DataSource_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_MeshVS_DataSource_HeaderFile
#include <Handle_MeshVS_DataSource.hxx>
#endif

#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _MeshVS_EntityType_HeaderFile
#include <MeshVS_EntityType.hxx>
#endif
#ifndef _Handle_MeshVS_HArray1OfSequenceOfInteger_HeaderFile
#include <Handle_MeshVS_HArray1OfSequenceOfInteger.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfInteger_HeaderFile
#include <Handle_TColStd_HArray1OfInteger.hxx>
#endif
#ifndef _TColStd_PackedMapOfInteger_HeaderFile
#include <TColStd_PackedMapOfInteger.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfReal_HeaderFile
#include <Handle_TColStd_HArray1OfReal.hxx>
#endif
class TColStd_Array1OfReal;
class MeshVS_HArray1OfSequenceOfInteger;
class TColStd_HArray1OfInteger;
class TColStd_HArray1OfReal;


//! The deferred class using for the following tasks: <br>
//! 1) Receiving geometry data about single element of node by its number; <br>
//! 2) Receiving type of element or node by its number; <br>
//! 3) Receiving topological information about links between element and nodes it consist of; <br>
//! 4) Receiving information about what element cover this node; <br>
//! 5) Receiving information about all nodes and elements the object consist of <br>
class MeshVS_DataSource : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Returns geometry information about node or element <br>
//! ID is the numerical identificator of node or element <br>
//! IsElement indicates this ID describe node ( if Standard_False ) or element ( if Standard_True ) <br>
//! Coords is an array of co-ordinates of node(s). <br>
//!     For node it is only 3 numbers: X, Y, Z in the strict order <br>
//!     For element it is 3*n numbers, where n is number of this element vertices <br>
//!     The order is strict also: X1, Y1, Z1, X2,...., where Xi, Yi, Zi are co-ordinates of vertices <br>
//! NbNodes is number of nodes. It is recommended this parameter to be set to 1 for node. <br>
//! Type is type of node or element (from enumeration). It is recommended this parameter to be set to <br>
//!     MeshVS_ET_Node for node. <br>
Standard_EXPORT virtual  Standard_Boolean GetGeom(const Standard_Integer ID,const Standard_Boolean IsElement,TColStd_Array1OfReal& Coords,Standard_Integer& NbNodes,MeshVS_EntityType& Type) const = 0;

//! This method is similar to GetGeom, but returns only element or node type. <br>
Standard_EXPORT virtual  Standard_Boolean GetGeomType(const Standard_Integer ID,const Standard_Boolean IsElement,MeshVS_EntityType& Type) const = 0;

//! This method returns topology information about 3D-element <br>
//! Returns false if element with ID isn't 3D or because other troubles <br>
Standard_EXPORT virtual  Standard_Boolean Get3DGeom(const Standard_Integer ID,Standard_Integer& NbNodes,Handle(MeshVS_HArray1OfSequenceOfInteger)& Data) const;

//! This method returns pointer which represents element or node data structure. <br>
//! This address will be saved in MeshVS_MeshOwner, so that you can access to data structure fast <br>
//! by the method Owner(). In the redefined method you can return NULL. <br>
//! ID is the numerical identificator of node or element <br>
//! IsElement indicates this ID describe node ( if Standard_False ) or element ( if Standard_True ) <br>
Standard_EXPORT virtual  Standard_Address GetAddr(const Standard_Integer ID,const Standard_Boolean IsElement) const = 0;

//! This method returns information about nodes this element consist of. <br>
//!          ID is the numerical identificator of node or element. <br>
//!          Returns array of integer identificators of nodes in correct order, <br>
//!          the same as coordinates returned by GetGeom(). <br>
//!          Returns Null handle if element does not exist <br>
Standard_EXPORT virtual  Handle_TColStd_HArray1OfInteger GetNodesByElement(const Standard_Integer ID) const = 0;

//! This method returns map of all nodes the object consist of. <br>
Standard_EXPORT virtual const TColStd_PackedMapOfInteger& GetAllNodes() const = 0;

//! This method returns map of all elements the object consist of. <br>
Standard_EXPORT virtual const TColStd_PackedMapOfInteger& GetAllElements() const = 0;

//! This method calculates normal of face, which is using for correct reflection presentation. <br>
//!   There is default method, for advance reflection this method can be redefined. <br>
//! Id is the numerical identificator of only element! <br>
//! Max is maximal number of nodes an element can consist of <br>
//! nx, ny, nz  are values whose represent co-ordinates of normal (will be returned) <br>
//!   In the redefined method you can return normal with length more then 1, but in this case <br>
//!   the appearance of element will be more bright than usual. For ordinary brightness you must return <br>
//!   normal with length 1 <br>
Standard_EXPORT virtual  Standard_Boolean GetNormal(const Standard_Integer Id,const Standard_Integer Max,Standard_Real& nx,Standard_Real& ny,Standard_Real& nz) const;

//! This method return normal of node ranknode of face Id, <br>
//!          which is using for smooth shading presentation. <br>
//!          Returns false if normal isn't defined. <br>
Standard_EXPORT virtual  Standard_Boolean GetNodeNormal(const Standard_Integer ranknode,const Standard_Integer ElementId,Standard_Real& nx,Standard_Real& ny,Standard_Real& nz) const;

//! This method puts components of normal vectors at each node of a mesh face (at each face of a mesh volume) <br>
//! into the output array. <br>
//! Returns false if some problem was detected during calculation of normals. <br>
//! Id is an identifier of the mesh element. <br>
//! IsNodal, when true, means that normals at mesh element nodes are needed. If nodal normals <br>
//! are not available, or IsNodal is false, or the mesh element is a volume, then the output array contents <br>
//! depend on the element type: <br>
//!   face: a normal calculated by GetNormal() is duplicated for each node of the face; <br>
//!   volume: normals to all faces of the volume are computed (not for each node!). <br>
//! MaxNodes is maximal number of nodes an element can consist of. <br>
//! Normals contains the result. <br>
Standard_EXPORT virtual  Standard_Boolean GetNormalsByElement(const Standard_Integer Id,const Standard_Boolean IsNodal,const Standard_Integer MaxNodes,Handle(TColStd_HArray1OfReal)& Normals) const;
//Standard_EXPORT ~MeshVS_DataSource();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
