// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Message_Msg_HeaderFile
#define _Message_Msg_HeaderFile

#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
class TCollection_AsciiString;
class TCollection_HAsciiString;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class provides a tool for preparing the message, filling it <br>
//!          with parameters, storing and printing to the default trace file. <br>
//! <br>
//!          A Message is created from a keyword: this keyword identifies the <br>
//!          message to be created, in a message file. The text of the message <br>
//!          is taken from the previously loaded message file (class <br>
//!          Message_MsgFile is used). <br>
class Message_Msg  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates a Msg without code (free form). The text then <br>
//!           should be loaded by the method SetOriginal(). <br>
Standard_EXPORT Message_Msg();

//! Creates a Msg from a Code (accessed through MsgFile). <br>
Standard_EXPORT Message_Msg(const Standard_CString acode);
//! Returns the Message Code <br>
  Standard_CString Code() const;

//! Sets an Original Value for a Msg (free form) <br>
Standard_EXPORT   void SetOriginal(const Standard_CString mess) ;
//! Returns the Original Value <br>
  Standard_CString Original() const;
//! Returns the Definitive Value <br>
  Standard_CString Value() const;
//! Tells if Value differs from Original <br>
  Standard_Boolean IsEdited() const;

//! Adds an integer value to the message <br>
//!           The value is printed in place of the first encountered "%d" <br>
//!           in the text string. If this is not found, nothing is done. <br>
Standard_EXPORT   void AddInteger(const Standard_Integer val) ;

//! Adds a real value to the message <br>
//!           The value is printed in place of the first encountered "%f" <br>
//!           in the text string. If this is not found, nothing is done. <br>
Standard_EXPORT   void AddReal(const Standard_Real val) ;

//! Adds a string (ascii) value to the message <br>
//!           The value is printed in place of the first encountered "%s" <br>
//!           in the text string. If this is not found, nothing is done. <br>
Standard_EXPORT   void AddString(const Standard_CString val) ;

//! Same with an AsciiString <br>
Standard_EXPORT   void AddString(const TCollection_AsciiString& val) ;

//! Same with a HAsciiString <br>
Standard_EXPORT   void AddString(const Handle(TCollection_HAsciiString)& val) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TCollection_AsciiString myCode;
TCollection_AsciiString myOriginal;
TCollection_AsciiString myValue;
Standard_Boolean myEdited;


};


#include <Message_Msg.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
