// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Message_OutFile_HeaderFile
#define _Message_OutFile_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Message_OutFile_HeaderFile
#include <Handle_Message_OutFile.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif


//! This class allows to manipulate an ostream C++ (as <cout> ...) <br>
//!           by handle as any other cdl class, for instance create it then <br>
//!           return it as result, transmit it through a client-server <br>
//!           protocol (of course, it remain in server part) ... <br>
class Message_OutFile : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Creates an OutFile which is defined on the standard <br>
//!           output <cout> <br>
Standard_EXPORT Message_OutFile();

//! Creates an OutFile as a file named as <filename>. <br>
//!          If <append> is True then existing file will be appended, <br>
//!          if False, it will be rewritten. <br>
//!  Warning: File creation status must be tested if there is any doubt, <br>
//!          with method IsOpen. If file creation failed, the OutFile <br>
//!          is directed to <cout>. <br>
Standard_EXPORT Message_OutFile(const Standard_CString filename,const Standard_Boolean append);

//! Destructor closes the file if the OutFile is directed not <br>
//!          to a standard output. <br>
Standard_EXPORT   void Destroy() ;
~Message_OutFile()
{
  Destroy();
}

//! Returns True if the OutFile is directed to the file and False <br>
//!          if to a standard output. <br>
  Standard_Boolean IsFile() const;
//! Returns True if file opening has succeeded, else returns False. <br>
//!          Always True for standard output. <br>
  Standard_Boolean IsOpen() const;
//! Returns the name of the currently open file. <br>
//!          Returns an empty string if open on standard output. <br>
  Standard_CString FileName() const;

//! Returns the real OStream to be written on. <br>
Standard_EXPORT   Standard_OStream& Out() ;
Standard_EXPORT operator Standard_OStream& ();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean myFileMode;
Standard_Boolean myFileOpen;
Standard_Address myStream;
TCollection_AsciiString myName;


};


#include <Message_OutFile.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
