// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _MoniTool_Profile_HeaderFile
#define _MoniTool_Profile_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_MoniTool_Profile_HeaderFile
#include <Handle_MoniTool_Profile.hxx>
#endif

#ifndef _Handle_Dico_DictionaryOfTransient_HeaderFile
#include <Handle_Dico_DictionaryOfTransient.hxx>
#endif
#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Handle_MoniTool_Option_HeaderFile
#include <Handle_MoniTool_Option.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfAsciiString_HeaderFile
#include <Handle_TColStd_HSequenceOfAsciiString.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
class Dico_DictionaryOfTransient;
class MoniTool_Option;
class TColStd_HSequenceOfAsciiString;
class TCollection_AsciiString;
class Standard_Transient;


//! A Profile gives access to a set of options : <br>
//!           - it defines and gives access to options, by names specific <br>
//!             to this Profile, defaulted to basic names of the Options <br>
//!           - it records one or more Configurations, each of one is <br>
//!             identified by a name, and commands for each option a switch <br>
//!             value <br>
//!           - a Configuration may be partial, i.e. concern only a subset <br>
//!             of the complete list of options <br>
//!           - Values are accessed through a Current Configuration, which <br>
//!             name is fixed as ".", which can cumulate several <br>
//!             configurations (especially when they are partial) <br>
//! <br>
//!           It may also bring a "fast" access to values, which has been <br>
//!           formerly computed from current configuration or another given <br>
//!           one. But its up-to-date status regarding existing <br>
//!           configurations is not checked : it may be recomputed or <br>
//!           cleared at any time. If not set, the current configuration <br>
//!           is then taken <br>
class MoniTool_Profile : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Creates an empty Profile, with an empty Current Configuration <br>
//!           (named ".") <br>
Standard_EXPORT MoniTool_Profile();

//! Adds an Option, with a Name, by default takes the Name of the <br>
//!           Option <br>
Standard_EXPORT   void AddOption(const Handle(MoniTool_Option)& option,const Standard_CString name = "") ;

//! Returns an Option from its Name. Null Handle if unknown <br>
Standard_EXPORT   Handle_MoniTool_Option Option(const Standard_CString name) const;

//! Returns the list of Option Names <br>
Standard_EXPORT   Handle_TColStd_HSequenceOfAsciiString OptionList() const;

//! Returns the list of Option Names which are defined on a <br>
//!           TypedValue/Static, i.e. for Basic Type <br>
Standard_EXPORT   Handle_TColStd_HSequenceOfAsciiString TypedValueList() const;

//! Adds a new Configuration, yet empty, then filled by AddSwitch <br>
//!           If <confname> already existed, it is replaced from scratch <br>
//!           While AddConf creates new Conf only if it does not yet exist <br>
//! <br>
//!           Remark : the Current Configuration "." may not be changed <br>
Standard_EXPORT   void NewConf(const Standard_CString confname) ;

//! Adds a new Configuration, yet empty, then filled by AddSwitch <br>
//!           If <confname> already existed, it is kept as it is <br>
//!           While NewConf restrts from scratch anyway <br>
//! <br>
//!           Remark : the Current Configuration "." may not be changed <br>
Standard_EXPORT   void AddConf(const Standard_CString confname) ;

//! Tells if <confname> is known as a Configuration <br>
Standard_EXPORT   Standard_Boolean HasConf(const Standard_CString confname) const;

//! Returns the list of Configuration Names, including Current "." <br>
Standard_EXPORT   Handle_TColStd_HSequenceOfAsciiString ConfList() const;

//! Clears a configuration (does not remove it) <br>
//!           A cleared configuration has no effect, it can be reloaded <br>
Standard_EXPORT   Standard_Boolean ClearConf(const Standard_CString confname) ;

//! Adds the definitions from the configuration <otherconf> to <br>
//!           those of <confname> <br>
//!           Returns True if done, False if confname or otherconf are unknown <br>
Standard_EXPORT   Standard_Boolean AddFromOtherConf(const Standard_CString confname,const Standard_CString otherconf) ;

//! Sets the definitions of a configuration from the actual state <br>
//!           (current configuration plus current state of options for those <br>
//!           which are not recorded in current conf) <br>
Standard_EXPORT   Standard_Boolean SetFromCurrent(const Standard_CString confname) ;

//! Adds to the Configuration <confname>, for the option <optname> <br>
//!           the command to switch it to <casename> <br>
//!           If <casename> is not given, records the actual current <br>
//!           CaseName of this Option <br>
//!           Returns True if done, False if <confname> or <optname> is <br>
//!           unknown, or <casename> not allowed for <optname> <br>
Standard_EXPORT   Standard_Boolean AddSwitch(const Standard_CString confname,const Standard_CString optname,const Standard_CString casename = "") ;

//! Removes from the Configuration <confname>, the switch for the <br>
//!           option <optname>. Hence, it will consider the basic default <br>
//!           switch for this option <br>
//!           Returns True if done or switch was not recorded, False if <br>
//!           <confname> or <optname> is unknown <br>
Standard_EXPORT   Standard_Boolean RemoveSwitch(const Standard_CString confname,const Standard_CString optname) ;

//! Returns the list of switches properly concerned by a config : <br>
//!           two lists in parallel, <optlist> lists the names of options <br>
//!           and for each one, <caselist> gives the case for this config <br>
Standard_EXPORT   void SwitchList(const Standard_CString confname,Handle(TColStd_HSequenceOfAsciiString)& optlist,Handle(TColStd_HSequenceOfAsciiString)& caselist) const;

//! Copies (Cumulates) the definition of <confname> to current <br>
//!           Records the current name as the last current setting <br>
//! <br>
//!           Returns True if done, False (and does nothing> if <confname> <br>
//!           is not recorded as a Configuration <br>
//!           If no SetCurrent has been called, the last added one is taken <br>
//! <br>
//!           Remark : SetCurrent is for the Profile : the individual <br>
//!           options are not switched themselves, they are only queried <br>
//!           To switch the options themselves, see below RecordCurrent <br>
//! <br>
//!           Remark : for Options which are listed in the Profile but not <br>
//!           in the current Configuration, their current switch is taken <br>
Standard_EXPORT   Standard_Boolean SetCurrent(const Standard_CString confname) ;

//! Records the switches of current configuration in the options <br>
//!           themselves <br>
Standard_EXPORT   void RecordCurrent() ;

//! Returns the name of last current configuration <br>
Standard_EXPORT  const TCollection_AsciiString& Current() const;

//! Returns the selected case name of option <optname> in current <br>
//!           configuration <br>
//!           Empty String if <optname> unknown <br>
//! <br>
//!           If <proper> is False (D), if <optname> is not recorded in the <br>
//!           current configuration, the own current name of the option <br>
//!           itself is taken <br>
//!           Else, an empty string is returned <br>
Standard_EXPORT   TCollection_AsciiString CaseName(const Standard_CString optname,const Standard_Boolean proper = Standard_False) const;

//! Returns the Value of the switch selected for option <optname> <br>
//!           in current configuration <br>
//!           Null Handle if <optname> unknown <br>
//!           To be down-casted as needed before use <br>
Standard_EXPORT   Handle_Standard_Transient CaseValue(const Standard_CString optname) const;

//! Returns the Value of the switch selected for option <optname> <br>
//!           in current configuration <br>
//!           Returns True if done, False + Null Handle if <optname> unknown <br>
//!           This way of returning a Transient, bound with the Type Control <br>
//!           avoids DownCast and ensures the value is directly usable <br>
Standard_EXPORT   Standard_Boolean Value(const Standard_CString optname,Handle(Standard_Transient)& val) const;

//! For the Options which are defined with a TypedValue/Static, <br>
//!           takes the value defined in current configuration, and sets <br>
//!           the TypedValue with it <br>
//! <br>
//!           If <proper> is False (D), takes the current value, whatever <br>
//!           it is properly recorded in current configuration or not <br>
//!           If <proper> is True, sets the value only if it is properly <br>
//!           recorded in the current configuration <br>
//! <br>
//!           By default, considers all the Options with a TypedValue <br>
//!           If <name> is given, considers the Options of which the name <br>
//!           begins by <name> <br>
Standard_EXPORT   void SetTypedValues(const Standard_Boolean proper = Standard_False,const Standard_CString name = "") const;

//! Recomputes fast access from the definition of a configuration <br>
//!           By default, the current one <br>
//!           Else, a configuration identified by its name <br>
Standard_EXPORT   void SetFast(const Standard_CString confname = "") ;

//! Clears definitions of fast access <br>
Standard_EXPORT   void ClearFast() ;

//! Gets the value corresponding to Option <optname>, as fast <br>
//!           If not defined as fast, check "normal" access by calling Value <br>
//!           Returns True if OK (either Fast or normal), False if not found <br>
//!           (if not found, <val> is returned Null Handle) <br>
Standard_EXPORT   Standard_Boolean FastValue(const Standard_CString optname,Handle(Standard_Transient)& val) const;
//Standard_EXPORT ~MoniTool_Profile();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

//! Internal <br>
Standard_EXPORT   Handle_Dico_DictionaryOfTransient Conf(const Standard_CString confname) const;


 // Fields PRIVATE
 //
Handle_Dico_DictionaryOfTransient theopts;
Handle_Dico_DictionaryOfTransient theconfs;
TCollection_AsciiString thecurname;
Handle_Dico_DictionaryOfTransient thecurconf;
Handle_Dico_DictionaryOfTransient thefastval;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
