// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ProjLib_Torus_HeaderFile
#define _ProjLib_Torus_HeaderFile

#ifndef _gp_Torus_HeaderFile
#include <gp_Torus.hxx>
#endif
#ifndef _ProjLib_Projector_HeaderFile
#include <ProjLib_Projector.hxx>
#endif
class Standard_NoSuchObject;
class gp_Torus;
class gp_Circ;
class gp_Lin;
class gp_Elips;
class gp_Parab;
class gp_Hypr;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Projects elementary curves on a torus. <br>
class ProjLib_Torus  : public ProjLib_Projector {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Undefined projection. <br>
Standard_EXPORT ProjLib_Torus();

//! Projection on the torus <To>. <br>
Standard_EXPORT ProjLib_Torus(const gp_Torus& To);

//! Projection of the circle <C> on the torus <To>. <br>
Standard_EXPORT ProjLib_Torus(const gp_Torus& To,const gp_Circ& C);


Standard_EXPORT   void Init(const gp_Torus& To) ;


Standard_EXPORT virtual  void Project(const gp_Lin& L) ;


Standard_EXPORT virtual  void Project(const gp_Circ& C) ;


Standard_EXPORT virtual  void Project(const gp_Elips& E) ;


Standard_EXPORT virtual  void Project(const gp_Parab& P) ;


Standard_EXPORT virtual  void Project(const gp_Hypr& H) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
gp_Torus myTorus;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
