// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _StepShape_CsgPrimitive_HeaderFile
#define _StepShape_CsgPrimitive_HeaderFile

#ifndef _StepData_SelectType_HeaderFile
#include <StepData_SelectType.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Handle_StepShape_Sphere_HeaderFile
#include <Handle_StepShape_Sphere.hxx>
#endif
#ifndef _Handle_StepShape_Block_HeaderFile
#include <Handle_StepShape_Block.hxx>
#endif
#ifndef _Handle_StepShape_RightAngularWedge_HeaderFile
#include <Handle_StepShape_RightAngularWedge.hxx>
#endif
#ifndef _Handle_StepShape_Torus_HeaderFile
#include <Handle_StepShape_Torus.hxx>
#endif
#ifndef _Handle_StepShape_RightCircularCone_HeaderFile
#include <Handle_StepShape_RightCircularCone.hxx>
#endif
#ifndef _Handle_StepShape_RightCircularCylinder_HeaderFile
#include <Handle_StepShape_RightCircularCylinder.hxx>
#endif
class Standard_Transient;
class StepShape_Sphere;
class StepShape_Block;
class StepShape_RightAngularWedge;
class StepShape_Torus;
class StepShape_RightCircularCone;
class StepShape_RightCircularCylinder;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class StepShape_CsgPrimitive  : public StepData_SelectType {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Returns a CsgPrimitive SelectType <br>
Standard_EXPORT StepShape_CsgPrimitive();

//! Recognizes a CsgPrimitive Kind Entity that is : <br>
//!        1 -> Sphere <br>
//!        2 -> Block <br>
//!        3 -> RightAngularWedge <br>
//!        4 -> Torus <br>
//!        5 -> RightCircularCone <br>
//!        6 -> RightCircularCylinder <br>
//!        0 else <br>
Standard_EXPORT   Standard_Integer CaseNum(const Handle(Standard_Transient)& ent) const;

//! returns Value as a Sphere (Null if another type) <br>
Standard_EXPORT   Handle_StepShape_Sphere Sphere() const;

//! returns Value as a Block (Null if another type) <br>
Standard_EXPORT   Handle_StepShape_Block Block() const;

//! returns Value as a RightAngularWedge (Null if another type) <br>
Standard_EXPORT   Handle_StepShape_RightAngularWedge RightAngularWedge() const;

//! returns Value as a Torus (Null if another type) <br>
Standard_EXPORT   Handle_StepShape_Torus Torus() const;

//! returns Value as a RightCircularCone (Null if another type) <br>
Standard_EXPORT   Handle_StepShape_RightCircularCone RightCircularCone() const;

//! returns Value as a RightCircularCylinder (Null if another type) <br>
Standard_EXPORT   Handle_StepShape_RightCircularCylinder RightCircularCylinder() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
