// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TFunction_Function_HeaderFile
#define _TFunction_Function_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_TFunction_Function_HeaderFile
#include <Handle_TFunction_Function.hxx>
#endif

#ifndef _Standard_GUID_HeaderFile
#include <Standard_GUID.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _TDF_Attribute_HeaderFile
#include <TDF_Attribute.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_TDF_Attribute_HeaderFile
#include <Handle_TDF_Attribute.hxx>
#endif
#ifndef _Handle_TDF_RelocationTable_HeaderFile
#include <Handle_TDF_RelocationTable.hxx>
#endif
#ifndef _Handle_TDF_DataSet_HeaderFile
#include <Handle_TDF_DataSet.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class TDF_Label;
class Standard_GUID;
class TDF_Attribute;
class TDF_RelocationTable;
class TDF_DataSet;


//! Provides the following two services <br>
//! -   a link to an evaluation driver <br>
//! -   the means of providing a link between a <br>
//!   function and an evaluation driver. <br>
class TFunction_Function : public TDF_Attribute {

public:
 // Methods PUBLIC
 // 

//! Static methods: <br>
//!          ============== <br>//! Finds or Creates a function attribute on the label <L>. <br>
//!          Returns the function attribute. <br>
Standard_EXPORT static  Handle_TFunction_Function Set(const TDF_Label& L) ;

//! Finds or Creates a function attribute on the label <L>. <br>
//!          Sets a driver ID to the function. <br>
//!          Returns the function attribute. <br>
Standard_EXPORT static  Handle_TFunction_Function Set(const TDF_Label& L,const Standard_GUID& DriverID) ;

//! Returns the GUID for functions. <br>//! Returns a function found on the label. <br>//! Instance methods: <br>
//!          ================ <br>
Standard_EXPORT static const Standard_GUID& GetID() ;


Standard_EXPORT TFunction_Function();
//! Returns the GUID for this function's driver. <br>
 const Standard_GUID& GetDriverGUID() const;

//! Sets the driver for this function as that <br>
//! indentified by the GUID guid. <br>
Standard_EXPORT   void SetDriverGUID(const Standard_GUID& guid) ;
//! Returns true if the execution failed <br>
  Standard_Boolean Failed() const;

//! Sets the failed index. <br>
Standard_EXPORT   void SetFailure(const Standard_Integer mode = 0) ;

//! Returns an index of failure if the execution of this function failed. <br>
//! If this integer value is 0, no failure has occurred. <br>//! Implementation of Attribute methods: <br>
//!          =================================== <br>
  Standard_Integer GetFailure() const;


Standard_EXPORT  const Standard_GUID& ID() const;


Standard_EXPORT virtual  void Restore(const Handle(TDF_Attribute)& with) ;


Standard_EXPORT virtual  void Paste(const Handle(TDF_Attribute)& into,const Handle(TDF_RelocationTable)& RT) const;


Standard_EXPORT virtual  Handle_TDF_Attribute NewEmpty() const;


Standard_EXPORT virtual  void References(const Handle(TDF_DataSet)& aDataSet) const;


Standard_EXPORT virtual  Standard_OStream& Dump(Standard_OStream& anOS) const;
//Standard_EXPORT ~TFunction_Function();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_GUID myDriverGUID;
Standard_Integer myFailure;


};


#include <TFunction_Function.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
