// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TopOpeBRepDS_InterferenceIterator_HeaderFile
#define _TopOpeBRepDS_InterferenceIterator_HeaderFile

#ifndef _TopOpeBRepDS_ListIteratorOfListOfInterference_HeaderFile
#include <TopOpeBRepDS_ListIteratorOfListOfInterference.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TopOpeBRepDS_Kind_HeaderFile
#include <TopOpeBRepDS_Kind.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_TopOpeBRepDS_Interference_HeaderFile
#include <Handle_TopOpeBRepDS_Interference.hxx>
#endif
class TopOpeBRepDS_ListOfInterference;
class TopOpeBRepDS_Interference;
class TopOpeBRepDS_ListIteratorOfListOfInterference;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Iterate  on  interferences  of  a  list,  matching <br>
//!          conditions  on   interferences. <br>
//! Nota   : <br>
//!          inheritance  of   ListIteratorOfListOfInterference  from <br>
//!          TopOpeBRepDS  has  not   been  done   because  of  the <br>
//!          impossibility of naming  the classical  More, Next <br>
//!          methods  which are declared as static in <br>
//!          TCollection_ListIteratorOfList ... . ListIteratorOfList <br>
//!          has benn placed as a field of InterferenceIterator. <br>
class TopOpeBRepDS_InterferenceIterator  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT TopOpeBRepDS_InterferenceIterator();

//! Creates an iterator on the Interference of list <L>. <br>
Standard_EXPORT TopOpeBRepDS_InterferenceIterator(const TopOpeBRepDS_ListOfInterference& L);

//! re-initialize  interference iteration  process  on <br>
//!          the list of interference <L>. <br>
//!          Conditions are not modified. <br>
Standard_EXPORT   void Init(const TopOpeBRepDS_ListOfInterference& L) ;

//! define a condition on interference iteration process. <br>
//!          Interference must match the Geometry Kind <ST> <br>
Standard_EXPORT   void GeometryKind(const TopOpeBRepDS_Kind GK) ;

//! define a condition on interference iteration process. <br>
//!          Interference must match the Geometry <G> <br>
Standard_EXPORT   void Geometry(const Standard_Integer G) ;

//! define a condition on interference iteration process. <br>
//!          Interference must match the Support Kind <ST> <br>
Standard_EXPORT   void SupportKind(const TopOpeBRepDS_Kind ST) ;

//! define a condition on interference iteration process. <br>
//!          Interference must match the Support <S> <br>
Standard_EXPORT   void Support(const Standard_Integer S) ;

//! reach for an interference  matching the conditions <br>
//!          (if  defined). <br>
Standard_EXPORT   void Match() ;

//! Returns  True if the Interference <I>  matches the <br>
//!          conditions (if defined). <br>
//!          If no conditions defined, returns True. <br>
Standard_EXPORT virtual  Standard_Boolean MatchInterference(const Handle(TopOpeBRepDS_Interference)& I) const;

//! Returns True if there is a current Interference in <br>
//!          the iteration. <br>
Standard_EXPORT   Standard_Boolean More() const;

//! Move to the next Interference. <br>
Standard_EXPORT   void Next() ;

//! Returns   the   current   Interference,   matching   the <br>
//!          conditions  (if defined). <br>
Standard_EXPORT   Handle_TopOpeBRepDS_Interference& Value() const;


Standard_EXPORT   TopOpeBRepDS_ListIteratorOfListOfInterference& ChangeIterator() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopOpeBRepDS_ListIteratorOfListOfInterference myIterator;
Standard_Boolean myGKDef;
TopOpeBRepDS_Kind myGK;
Standard_Boolean myGDef;
Standard_Integer myG;
Standard_Boolean mySKDef;
TopOpeBRepDS_Kind mySK;
Standard_Boolean mySDef;
Standard_Integer myS;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
