// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TopoDS_Builder_HeaderFile
#define _TopoDS_Builder_HeaderFile

#ifndef _Handle_TopoDS_TShape_HeaderFile
#include <Handle_TopoDS_TShape.hxx>
#endif
class Standard_NullObject;
class TopoDS_FrozenShape;
class TopoDS_UnCompatibleShapes;
class TopoDS_Shape;
class TopoDS_TShape;
class TopoDS_Wire;
class TopoDS_Compound;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! A  Builder is used   to  create  Topological  Data <br>
//!          Structures. <br>
//! <br>
//!          There are three groups of methods in the Builder : <br>
//! <br>
//!          The Make methods create Shapes. <br>
//! <br>
//!          The Add method includes a Shape in another Shape. <br>
//! <br>
//!          The Remove  method  removes a  Shape from an other <br>
//!          Shape. <br>
//! <br>
//!          The methods in Builder are not static. They can be <br>
//!          redefined in inherited builders. <br>
class TopoDS_Builder  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Make an  empty Wire. <br>
Standard_EXPORT   void MakeWire(TopoDS_Wire& W) const;

//! Make an empty Compound. <br>
Standard_EXPORT   void MakeCompound(TopoDS_Compound& C) const;

//! Add the Shape C in the Shape S. <br>
//!   Exceptions <br>
//! - TopoDS_FrozenShape if S is not free and cannot be modified. <br>
//! - TopoDS__UnCompatibleShapes if S and C are not compatible. <br>
Standard_EXPORT   void Add(TopoDS_Shape& S,const TopoDS_Shape& C) const;

//! Remove the Shape C from the Shape S. <br>
//!  Exceptions <br>
//! TopoDS_FrozenShape if S is frozen and cannot be modified. <br>
Standard_EXPORT   void Remove(TopoDS_Shape& S,const TopoDS_Shape& C) const;





protected:

 // Methods PROTECTED
 // 

//! The Builder will build Shapes with the model <M>. <br>
Standard_EXPORT TopoDS_Builder();

//! The basic method to make  a Shape, used by all the <br>
//!          Make methods. <br>
Standard_EXPORT   void MakeShape(TopoDS_Shape& S,const Handle(TopoDS_TShape)& T) const;


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
