// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Vrml_AsciiText_HeaderFile
#define _Vrml_AsciiText_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Vrml_AsciiText_HeaderFile
#include <Handle_Vrml_AsciiText.hxx>
#endif

#ifndef _Handle_TColStd_HArray1OfAsciiString_HeaderFile
#include <Handle_TColStd_HArray1OfAsciiString.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Vrml_AsciiTextJustification_HeaderFile
#include <Vrml_AsciiTextJustification.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class TColStd_HArray1OfAsciiString;


//! defines a AsciiText node of VRML specifying geometry shapes. <br>
//! This  node  represents  strings  of  text  characters  from  ASCII  coded <br>
//! character  set. All subsequent strings advance y by -( size * spacing). <br>
//! The justification field determines the placement of the strings in the x <br>
//! dimension. LEFT (the default) places the left edge of each string at x=0. <br>
//! CENTER places the center of each string at x=0. RIGHT places the right edge <br>
//! of each string at x=0. Text is rendered from left to right, top to <br>
//! bottom in the font set by FontStyle. <br>
//! The  default  value  for  the  wigth  field  indicates  the  natural  width <br>
//! should  be  used  for  that  string. <br>
class Vrml_AsciiText : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT Vrml_AsciiText();


Standard_EXPORT Vrml_AsciiText(const Handle(TColStd_HArray1OfAsciiString)& aString,const Standard_Real aSpacing,const Vrml_AsciiTextJustification aJustification,const Standard_Real aWidth);


Standard_EXPORT   void SetString(const Handle(TColStd_HArray1OfAsciiString)& aString) ;


Standard_EXPORT   Handle_TColStd_HArray1OfAsciiString String() const;


Standard_EXPORT   void SetSpacing(const Standard_Real aSpacing) ;


Standard_EXPORT   Standard_Real Spacing() const;


Standard_EXPORT   void SetJustification(const Vrml_AsciiTextJustification aJustification) ;


Standard_EXPORT   Vrml_AsciiTextJustification Justification() const;


Standard_EXPORT   void SetWidth(const Standard_Real aWidth) ;


Standard_EXPORT   Standard_Real Width() const;


Standard_EXPORT   Standard_OStream& Print(Standard_OStream& anOStream) const;
//Standard_EXPORT ~Vrml_AsciiText();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_TColStd_HArray1OfAsciiString myString;
Standard_Real mySpacing;
Vrml_AsciiTextJustification myJustification;
Standard_Real myWidth;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
