/* MA2STD.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"


#ifdef WNT
#include <ApproxF2var.h>
#endif 


/* Subroutine */ int mma2std_(ndimen, ncfmxu, ncfmxv, npatmx, patchf, ncoefu, 
	ncoefv, nbupat, nbvpat, udbfin, vdbfin, pataux, iercod)
const integer *ndimen, *ncfmxu, *ncfmxv, *npatmx;
doublereal *patchf;
const integer *ncoefu, *ncoefv, *nbupat, *nbvpat;
const doublereal *udbfin, *vdbfin;
doublereal *pataux;
integer *iercod;
{
    /* System generated locals */
    integer patchf_dim1, patchf_dim2, patchf_dim3, patchf_offset, pataux_dim1,
	     pataux_dim2, pataux_offset, i__1, i__2, i__3, i__4;

    /* Local variables */
    static integer koct, ilong;
    static doublereal u0, u1, v0, v1;
    static integer ii, nd, jj, ibb, nbp, ier;
    extern integer mnfndeb_();
    extern /* Subroutine */ int mmfmcar_(), mcrfill_(), mgenmsg_(), mgsomsg_()
	    , mvriraz_();




/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ********************************************************************** 
*/

/*     FONCTION : */
/*     ---------- */
/*        Routine de gestion des resultats de l' approximation par */
/*        une surface polynomiale (Changements de bases : */
/* (-1,1)*(-1,1) --> (UDBFIN(1),UDBFIN(2))*(VDBFIN(1),VDBFIN(2)) */

/*     MOTS CLES : */
/*     ----------- */
/*        APPROXIMATION,CHANGEMENT DE BASE,LEGENDRE. */

/*     ARGUMENTS D'ENTREE : */
/*     ------------------ */
/*        NDIMEN: Dimension de l' espace. */
/*        NCFMXU: Dimension MAXI en u des carreaux resultat PATCHF. */
/*        NCFMXV: Dimension MAXI en v des carreaux resultat PATCHF. */
/*        NPATMX: Nbre MAXI de carreaux stockes dans PATCHF. */
/*        PATCHF: Table des coeff. des carreaux d'approximation. */
/*        NCOEFU: Degre+1 retenu en u pour les carreaux PATCHF. */
/*        NCOEFV: Degre+1 retenu en v pour les carreaux PATCHF. */
/*        NBUPAT: Nbre de carreau en U a traiter. */
/*        NBVPAT: Nbre de carreau en V a traiter (le nbre total de */
/*                carreaux a traiter est donc de NBUPAT*NBVPAT). */
/*        UDBFIN,VDBFIN : bornes de variation des parametres U et V */
/*                        de PATCHF. */

/*     ARGUMENTS DE SORTIE : */
/*     ------------------- */
/*        PATAUX: Tableau auxiliaire. */
/*        PATCHF: Tableau resultat dans la base canonique avec */
/*                 U dans (UDBFIN(1),UDBFIN(2)), */
/*                 V dans (VDBFIN(1),VDBFIN(2)) */

/*     COMMONS UTILISES   : */
/*     ---------------- */

/*     REFERENCES APPELEES   : */
/*     ----------------------- */

/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */

/* $    HISTORIQUE DES MODIFICATIONS   : */
/*     -------------------------------- */
/*     18-08-1993 : MPS; Erreur compil HP: .NOT. */
/*     25-05-1993 : MPS; Correction du test relatif au */
/*                       traitement de la base canonique (-1,1) */
/*     01-08-1989 : RBD; Creation. */
/* > */
/* ***********************************************************************
 */

/*   Le nom de la routine */

    /* Parameter adjustments */
    pataux_dim1 = *ndimen;
    pataux_dim2 = *ncfmxu;
    pataux_offset = pataux_dim1 * (pataux_dim2 + 1) + 1;
    pataux -= pataux_offset;
    --ncoefv;
    --ncoefu;
    patchf_dim1 = *ncfmxu;
    patchf_dim2 = *ncfmxv;
    patchf_dim3 = *ndimen;
    patchf_offset = patchf_dim1 * (patchf_dim2 * (patchf_dim3 + 1) + 1) + 1;
    patchf -= patchf_offset;
    --udbfin;
    --vdbfin;

    /* Function Body */
    ibb = mnfndeb_();
    if (ibb >= 2) {
	mgenmsg_("MMA2STD", 7L);
    }

    i__1 = *nbupat * *nbvpat;
    for (nbp = 1; nbp <= i__1; ++nbp) {
	ilong = *ndimen * *ncfmxu * *ncfmxv;
	mvriraz_(&ilong, &pataux[pataux_offset]);

/* ------------------------- inversion de NDIMEN --------------------
-- */

	if (*ndimen != 1) {
	    i__2 = ncoefv[nbp];
	    for (jj = 1; jj <= i__2; ++jj) {
		i__3 = ncoefu[nbp];
		for (ii = 1; ii <= i__3; ++ii) {
		    i__4 = *ndimen;
		    for (nd = 1; nd <= i__4; ++nd) {
			pataux[nd + (ii + jj * pataux_dim2) * pataux_dim1] = 
				patchf[ii + (jj + (nd + nbp * patchf_dim3) * 
				patchf_dim2) * patchf_dim1];
/* L300: */
		    }
/* L200: */
		}
/* L100: */
	    }
	    koct = ilong << 3;
	    mcrfill_(&koct, &pataux[pataux_offset], &patchf[((nbp * 
		    patchf_dim3 + 1) * patchf_dim2 + 1) * patchf_dim1 + 1]);
	}

/* ----------- Dans la base canonique (-1,1), on a termine pour NBP--
---- */

/* MPS      IF ((UDBFIN(1).EQ.-1.D0).AND.(UDBFIN(2).EQ.1.D0).AND. */
/*      1   (VDBFIN(1).EQ.-1.D0).AND.(VDBFIN(2).EQ.1.D0)) GOTO 9999 */

	if (! (udbfin[1] == -1. && udbfin[2] == 1. && vdbfin[1] == -1. && 
		vdbfin[2] == 1.)) {

/* ------------ Sinon on passe dans la base canonique -----------
-------- */
/* --( UDBFIN(1),UDBFIN(2) ) en U,( VDBFIN(1),VDBFIN(2) ) en V -- 
*/

	    u0 = -(udbfin[1] + udbfin[2]) / (udbfin[2] - udbfin[1]);
	    u1 = 2. / (udbfin[2] - udbfin[1]) + u0;
	    v0 = -(vdbfin[1] + vdbfin[2]) / (vdbfin[2] - vdbfin[1]);
	    v1 = 2. / (vdbfin[2] - vdbfin[1]) + v0;
	    mmfmcar_(ndimen, ncfmxu, &ncoefu[nbp], &ncoefv[nbp], &patchf[((
		    nbp * patchf_dim3 + 1) * patchf_dim2 + 1) * patchf_dim1 + 
		    1], &u0, &u1, &v0, &v1, &patchf[((nbp * patchf_dim3 + 1) *
		     patchf_dim2 + 1) * patchf_dim1 + 1], &ier);
	    if (ier > 0) {
		*iercod = ier;
	    }
	}

/* L1111: */
    }
    goto L9999;

/* ---------------------------- The end --------------------------------- 
*/

L9999:
    if (ibb >= 2) {
	mgsomsg_("MMA2STD", 7L);
    }
 return 0 ;
} /* mma2std_ */

