/* MCDRIV.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"
#include <Data_Data.h>
#ifdef WNT
#include <MathBase.h>
#else 
#define  __MathBase_API
#endif

/* Common Block Declarations */

/* extern __Data_API struct { */
extern struct {
    doublereal cnp[3721]	/* was [61][61] */;
} mmcmcnp_;

#define mmcmcnp_1 mmcmcnp_

/* Subroutine */ __MathBase_API int mmcdriv_(ndimen, ncoeff, courbe, ideriv, ncofdv, crvdrv)
integer *ndimen, *ncoeff;
doublereal *courbe;
integer *ideriv, *ncofdv;
doublereal *crvdrv;
{
    /* System generated locals */
    integer courbe_dim1, courbe_offset, crvdrv_dim1, crvdrv_offset, i__1, 
	    i__2;

    /* Local variables */
    static integer i__, j, k;
    static doublereal mfactk, bid;



/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ***********************************************************************
 */

/*     FONCTION : */
/*     ---------- */
/*     CALCUL DE LA MATRICE D'UNE COURBE DERIVEE D' ORDRE IDERIV. */
/*     AVEC PARAMETRES D' ENTRE DISTINCT DES PARAMETRES DE SORTIE. */


/*     MOTS CLES : */
/*     ----------- */
/*     COEFFICIENTS,COURBE,DERIVEE I-EME. */

/*     ARGUMENTS D'ENTREE : */
/*     ------------------ */
/*   NDIMEN   : Dimension de l'espace (2 ou 3 en general) */
/*   NCOEFF  : Le degre +1 de la courbe. */
/*   COURBE  : Tableau des coefficients de la courbe. */
/*   IDERIV : Ordre de derivation demande : 1=derivee 1ere, etc... */

/*     ARGUMENTS DE SORTIE : */
/*     ------------------- */
/*   NCOFDV  : Le degre +1 de la derivee d' ordre IDERIV de la courbe. */
/*   CRVDRV  : Tableau des coefficients de la derivee d' ordre IDERIV */
/*            de la courbe. */

/*     COMMONS UTILISES   : */
/*     ---------------- */

/*     REFERENCES APPELEES   : */
/*     ----------------------- */

/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */

/* ---> Il est possible de prendre comme argument de sortie la courbe */
/*     et le nombre de coeff passes en entree en faisant : */
/*        CALL MMCDRIV(NDIMEN,NCOEFF,COURBE,IDERIV,NCOEFF,COURBE). */
/*     Apres cet appel, NCOEFF doone le nbre de coeff de la courbe */
/*     derivee dont les coefficients sont stockes dans COURBE. */
/*     Attention alors aux coefficients de COURBE de rang superieur a */
/*     NCOEFF : il ne sont pas mis a zero. */

/* ---> Algorithme : */
/*     Le code ci dessous a ete ecrit a partir de l' algorithme suivant: 
*/

/*     Soit P(t) = a1 + a2*t + ... an*t**n. La derivee d' ordre k de P */
/*     (comportant n-k coefficients) est calculee ainsi : */

/*       Pk(t) = a(k+1)*CNP(k,k)*k! */
/*             + a(k+2)*CNP(k+1,k)*k! * t */
/*             . */
/*             . */
/*             . */
/*             + a(n)*CNP(n-1,k)*k! * t**(n-k-1). */

/* $    HISTORIQUE DES MODIFICATIONS   : */
/*     -------------------------------- */
/*     09-01-90 : TE ; COMMON MCCNP -> MMCMCNP.INC & INDICES DES CNP */
/*     07-10-88 : RBD; Creation. */
/* > */
/* ***********************************************************************
 */


/* -------------- Cas ou l' ordre de derivee est plus ------------------- 
*/
/* ---------------- grand que le degre de la courbe --------------------- 
*/

/*     INCLUDE MMCMCNP */
/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ********************************************************************** 
*/

/*     FONCTION : */
/*     ---------- */
/*      Sert a fournir les coefficients du binome (triangle de Pascal). */

/*     MOTS CLES : */
/*     ----------- */
/*      Coeff du binome de 0 a 60. read only . init par block data */

/*     DEMSCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */
/*     Les coefficients du binome forment une matrice triangulaire. */
/*     On complete cette matrice dans le tableau CNP par sa transposee. */
/*     On a donc: CNP(I,J) = CNP(J,I) pour I et J = 0, ..., 60. */

/*     L'initialisation est faite a partir du block-data MMLLL09.RES, */
/*     cree par le programme MQINICNP.FOR (voir l'equipe (AC) ). */

/* $    HISTORIQUE DES MODIFICATIONS : */
/*     ------------------------------ */
/*     03-07-90 : RBD; Ajout commentaires (nom du block-data). */
/*     19-06-90 : RBD; Le commun MMCMCNP remplace MCCNP qui est obsolete. 
*/
/*     08-01-90 : TE ; CREATION */
/* > */
/* ********************************************************************** 
*/



/* ***********************************************************************
 */

    /* Parameter adjustments */
    crvdrv_dim1 = *ndimen;
    crvdrv_offset = crvdrv_dim1 + 1;
    crvdrv -= crvdrv_offset;
    courbe_dim1 = *ndimen;
    courbe_offset = courbe_dim1 + 1;
    courbe -= courbe_offset;

    /* Function Body */
    if (*ideriv >= *ncoeff) {
	i__1 = *ndimen;
	for (i__ = 1; i__ <= i__1; ++i__) {
	    crvdrv[i__ + crvdrv_dim1] = 0.;
/* L10: */
	}
	*ncofdv = 1;
	goto L9999;
    }
/* ********************************************************************** 
*/
/*                         Traitement general */
/* ********************************************************************** 
*/
/* --------------------- Calcul de Factorielle(IDERIV) ------------------ 
*/

    k = *ideriv;
    mfactk = 1.;
    i__1 = k;
    for (i__ = 2; i__ <= i__1; ++i__) {
	mfactk *= i__;
/* L50: */
    }

/* ------------ Calcul des coeff de la derivee d' ordre IDERIV ---------- 
*/
/* ---> Attention : le coefficient binomial C(n,m) est represente dans */
/*                 MCCNP par CNP(N+1,M+1). */

    i__1 = *ncoeff;
    for (j = k + 1; j <= i__1; ++j) {
	bid = mmcmcnp_1.cnp[j - 1 + k * 61] * mfactk;
	i__2 = *ndimen;
	for (i__ = 1; i__ <= i__2; ++i__) {
	    crvdrv[i__ + (j - k) * crvdrv_dim1] = bid * courbe[i__ + j * 
		    courbe_dim1];
/* L200: */
	}
/* L100: */
    }

    *ncofdv = *ncoeff - *ideriv;

/* -------------------------------- The end ----------------------------- 
*/

L9999:
    return 0;
} /* mmcdriv_ */

