/* VGAUS0.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"

/* Subroutine */ int mvgaus0_(kindic, urootl, hiltab, nbrval, iercod)
integer *kindic;
doublereal *urootl, *hiltab;
integer *nbrval, *iercod;
{
    /* System generated locals */
    integer i__1;

    /* Local variables */
    static doublereal tamp[40];
    static integer ndegl, kg, ii;
    extern /* Subroutine */ int mmexthi_(), mmextrl_();



/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ********************************************************************** 
*/

/*      FONCTION : */
/*      -------- */
/*  Chargement pour un degre donne des racines du polynome de LEGENDRE */
/*  DEFINI SUR [-1,1] et des poids des formules de quadrature de Gauss */
/*  (bases sur les interpolants de LAGRANGE correspondants). */
/*  La symetrie par rapport a 0 entre [-1,0] et [0,1] est utilisee. */

/*      MOTS CLES : */
/*      --------- */
/*         . VOLUMIQUE,LEGENDRE,LAGRANGE,GAUSS */

/*      ARGUMENTS D'ENTREE : */
/*      ------------------ */

/*  KINDIC : Prends les valeurs de 1 a 10 en fonction du degre du */
/*           polynome a utiliser. */
/*           Le degre du polynome est egal a 4 k, c'est a dire 4, 8, */
/*           12, 16, 20, 24, 28, 32, 36 et 40. */

/*      ARGUMENTS DE SORTIE : */
/*      ------------------- */

/*  UROOTL : Racines du polynome de LEGENDRE dans le domaine [1,0] */
/*           ordonnees en decroissant. Pour le domaine [-1,0], il faut */
/*           prendre les valeurs opposees. */
/*  HILTAB : Interpolant de LAGRANGE associes aux racines. Pour les */
/*           racines opposes, les interpolants sont egaux. */
/*  NBRVAL : Nombre de coefficients. C'est egal a la moitie du degre en */
/*           raison de la symetrie (i.e. 2*KINDIC). */

/*  IERCOD  :  Code d'erreur : */
/*          < 0 ==> Attention - Warning */
/*          =-1 ==> Valeur de KINDIC erronne. NBRVAL est force a 20 */
/*                  (ordre 40) */
/*          = 0 ==> Tout est OK */

/*      COMMON UTILISES : */
/*      ---------------- */

/*      REFERENCES APPELEES : */
/*      ------------------- */

/*      DESCRIPTION/REMARQUES/LIMITATIONS : */
/*      --------------------------------- */
/*      Si KINDIC n'est pas bon (i.e < 1 ou > 10), le degre est pris */
/*      a 40 directement (ATTENTION au debordement - pour l'eviter, */
/*      prevoir UROOTL et HILTAB dimensionne a 20 au moins). */

/*      La valeur des coefficients a ete calculee en quadruple precision 
*/
/*      par JJM avec l'aide de GD. */
/*      La verification des racines a ete faite par GD. */

/*      Voir les explications detaillees sur le listing */

/* $    HISTORIQUES DES MODIFICATIONS : */
/*     ----------------------------- */
/*        . 23-03-90 : RBD; Les valeurs sont extraites du commun MLGDRTL 
*/
/*                          via MMEXTHI et MMEXTRL. */
/*        . 28-06-88 : JP; DECLARATIONS REAL *8  MAL PLACEES */
/*        . 08-08-87 : GD; Version originale */
/* > */
/* ********************************************************************** 
*/


/* ------------------------------------ */
/* ****** Test de validite de KINDIC ** */
/* ------------------------------------ */

    /* Parameter adjustments */
    --hiltab;
    --urootl;

    /* Function Body */
    *iercod = 0;
    kg = *kindic;
    if (kg < 1 || kg > 10) {
	kg = 10;
	*iercod = -1;
    }
    *nbrval = kg << 1;
    ndegl = *nbrval << 1;

/* ---------------------------------------------------------------------- 
*/
/* ****** Chargement des NBRVAL racines positives en fonction du degre ** 
*/
/* ---------------------------------------------------------------------- 
*/
/* ATTENTION : Le signe moins (-) dans la boucle est intentionnel. */

    mmextrl_(&ndegl, tamp);
    i__1 = *nbrval;
    for (ii = 1; ii <= i__1; ++ii) {
	urootl[ii] = -tamp[ii - 1];
/* L100: */
    }

/* ------------------------------------------------------------------- */
/* ****** Chargement des NBRVAL poids de Gauss en fonction du degre ** */
/* ------------------------------------------------------------------- */

    mmexthi_(&ndegl, tamp);
    i__1 = *nbrval;
    for (ii = 1; ii <= i__1; ++ii) {
	hiltab[ii] = tamp[ii - 1];
/* L200: */
    }

/* ------------------------------- */
/* ****** Fin du sous-programme ** */
/* ------------------------------- */

    return 0;
} /* mvgaus0_ */

