// File:	Message_TraceFile.cxx
// Created:	Fri Jul 30 11:53:57 1999
// Author:	Roman LYGIN
//		<rln@zamox.nnov.matra-dtv.fr>


#include <Message_TraceFile.ixx>
#include <Standard_Mutex.hxx>

static Standard_Mutex theMutex;
static Handle(Message_TraceFile) deftracefile = new Message_TraceFile;


//=======================================================================
//function : Message_TraceFile
//purpose  : 
//=======================================================================

Message_TraceFile::Message_TraceFile()
{
  myFile = new Message_OutFile;
}

//=======================================================================
//function : Message_TraceFile
//purpose  : 
//=======================================================================

Message_TraceFile::Message_TraceFile(const Standard_Integer tracelevel,
					     const Standard_CString filename,
					     const Standard_Boolean append)
{
  myFile = new Message_OutFile (filename, append);
  SetTraceLevel (tracelevel);
}

//=======================================================================
//function : Message_TraceFile
//purpose  : 
//=======================================================================

Message_TraceFile::Message_TraceFile(const Standard_Integer tracelevel,
					     const Handle(Message_OutFile)& file)
{
  myFile = file;
  SetTraceLevel (tracelevel);
}

//=======================================================================
//function : OwnSend
//purpose  : 
//=======================================================================

 void Message_TraceFile::OwnSend(const Standard_CString string,const Message_EndOfMsg theEnd) const
{
  myFile->Out() << string;
  if (theEnd == Message_Flush) myFile->Out() << flush;
  else                             myFile->Out() << endl;
}

//=======================================================================
//function : Default
//purpose  : 
//=======================================================================

Handle(Message_TraceFile) Message_TraceFile::Default() 
{
  Standard_Mutex::Sentry aSentry ( theMutex );
  return deftracefile;
}

//=======================================================================
//function : SetDefault
//purpose  : 
//=======================================================================

 void Message_TraceFile::SetDefault(const Handle(Message_TraceFile)& tracefile) 
{
  Standard_Mutex::Sentry aSentry ( theMutex );
  deftracefile = tracefile;
}

//=======================================================================
//function : SetDefault
//purpose  : 
//=======================================================================

 void Message_TraceFile::SetDefault(const Standard_Integer tracelevel,
					const Standard_CString filename,
					const Standard_Boolean append) 
{
  Standard_Mutex::Sentry aSentry ( theMutex );
  deftracefile = new Message_TraceFile (tracelevel, filename, append);
}

//=======================================================================
//function : SetDefault
//purpose  : 
//=======================================================================

 void Message_TraceFile::SetDefault() 
{
  Standard_Mutex::Sentry aSentry ( theMutex );
  deftracefile = new Message_TraceFile;
}

