/***********************************************************************

     FONCTION :
     ----------
        File OpenGl_initelem :
 

     REMARQUES:
     ---------- 
      

     HISTORIQUE DES MODIFICATIONS   :
     --------------------------------
       xx-xx-xx : xxx ; Creation.
       20-02-96 : FMN ; Suppression code inutile:
       01-04-96 : CAL ; Integration MINSK portage WNT
       25-06-96 : FMN ; Suppression utilisation de glScissor.
       03-07-96 : FMN ; Suppression definition des materiaux (InitMaterial).
       08-07-96 : BGN ; (PRO4768)les dessins des markers echelle 1 sont 
                        grossis (on reprend les bitmaps de l'echelle 2)
                        => creation des markers des echelles 6.5 et 7;
                        creation des bitmaps du marker point par cercles
                        pleins (=> meilleur affichage et suppression du
                        cas particulier).
       17-07-96 : FMN ; Suppression utilisation de HLHSRMode.
                        InitMaterial, InitLM sont inutilisees
       05-12-96 : FMN ; PRO6327: Pas defaut on met la lumiere 
                        GL_LIGHT_MODEL_TWO_SIDE a True.
       13-02-97 : FMN ; Suppression variables inutiles
       15-02-97 : FMN ; Suppression OpenGl_gl_compat.h
       15-02-97 : FMN ; Ajout glHint pour le fog et l'antialiasing
       11-04-97 : FMN ; Ajout glPolygonOffsetEXT
       30-06-97 : FMN ; Les init generales par contexte sont faites dans OpenGl_subrvis.
       05-08-07 : PCT ; ajout support texture mapping
       23-12-97 : FMN ; Suppression TelBackInteriorStyle, TelBackInteriorStyleIndex
                        et TelBackInteriorShadingMethod
       30-11-98 : FMN ; S3819 : Textes toujours visibles
       26-10-99 : VTN ; BUC60599 : Enable to have contiguous horizontal or
                                   vertical hatching. 
       16-06-2000 : ATS : G005 : Init functions for PARRAY and DARRAY primitives
       22-03-04 : SAN ; OCC4895 High-level interface for controlling polygon offsets

************************************************************************/

#define G003    /* EUG 06-10-99 Degeneration mode support
*/

#define G005

#define OCC2934 /* SAN 22/01/04 Texture mapped fonts on WNT */

#define OCC7667 /* asl Export to vector graphic file

/*----------------------------------------------------------------------*/
/*
 * Includes
 */

#include <OpenGl_tgl_all.h>

#include <GL/gl.h>

#include <stdio.h>

#include <OpenGl_telem.h>
#include <OpenGl_tsm.h>
#include <OpenGl_cmn_memory.h>

/*----------------------------------------------------------------------*/
/*
 * Constantes
 */

#define  DOT_LS            0xCCCC
#define  DASH_DOT_LS       0xFF18
#define  DASH_LS           0xFFC0
#define  DASH_DDOT_LS      0xFF24


/*----------------------------------------------------------------------*/
/*
 * Prototypes
 */

static void InitPMFont(void);

/*----------------------------------------------------------------------*/
/*
 * Variables externes
 */

GLuint linestyleBase;
GLuint patternBase;
GLuint markerBase;

/*----------------------------------------------------------------------*/
/*
 * Prototypes des fonctions appele par TsmSendMessage()
 */

extern  MtblPtr  TelLabelInitClass( TelType* );
extern  MtblPtr  TelPolylineInitClass( TelType* );
extern  MtblPtr  TelPolylineColourInitClass( TelType* );
extern  MtblPtr  TelPolylineWidthInitClass( TelType* );
extern  MtblPtr  TelExecuteStructureInitClass( TelType* );
extern  MtblPtr  TelPickIdInitClass( TelType* );
extern  MtblPtr  TelPolylineTypeInitClass( TelType* );
extern  MtblPtr  TelEdgeColourInitClass( TelType* );
extern  MtblPtr  TelEdgeTypeInitClass( TelType* );
extern  MtblPtr  TelEdgeWidthInitClass( TelType* );
extern  MtblPtr  TelAntiAliasingInitClass( TelType* );
extern  MtblPtr  TelPolygonInitClass( TelType* );
extern  MtblPtr  TelInteriorColourInitClass( TelType* );
extern  MtblPtr  TelInteriorStyleInitClass( TelType* );
extern  MtblPtr  TelEdgeFlagInitClass( TelType* );
extern  MtblPtr  TelPolymarkerColourInitClass( TelType* );
extern  MtblPtr  TelPolymarkerSizeInitClass( TelType* );
extern  MtblPtr  TelMarkerInitClass( TelType* );
extern  MtblPtr  TelMarkerSetInitClass( TelType* );
extern  MtblPtr  TelLocalTran3InitClass( TelType* );
extern  MtblPtr  TelAddNamesetInitClass( TelType* );
extern  MtblPtr  TelRemoveNamesetInitClass( TelType* );
extern  MtblPtr  TelBackInteriorColourInitClass( TelType* );
extern  MtblPtr  TelInteriorStyleIndexInitClass( TelType* );
extern  MtblPtr  TelFaceDistinguishingModeInitClass( TelType* );
extern  MtblPtr  TelTextColourInitClass( TelType* );
extern  MtblPtr  TelTextInitClass( TelType* );
extern  MtblPtr  TelTextColourSubTitleInitClass( TelType* );
extern  MtblPtr  TelTextStyleInitClass( TelType* );
extern  MtblPtr  TelTextDisplayTypeInitClass( TelType* );
extern  MtblPtr  TelTextFontInitClass( TelType* );
extern  MtblPtr  TelTextHeightInitClass( TelType* );
/*OCC7456 abd 14.12.2004 Text alingnment attributes  */
extern  MtblPtr  TelTextAlignInitClass( TelType* );
/*OCC7456 abd 14.12.2004 Text alingnment attributes  */
extern  MtblPtr  TelCharacterSpacingInitClass( TelType* );
extern  MtblPtr  TelCharacterExpansionFactorInitClass( TelType* );
extern  MtblPtr  TelPolymarkerTypeInitClass( TelType* );
extern  MtblPtr  TelLightSrcStateInitClass( TelType* );
extern  MtblPtr  TelInteriorReflectanceEquationInitClass( TelType* );
extern  MtblPtr  TelBackInteriorReflectanceEquationInitClass( TelType* );
extern  MtblPtr  TelSurfaceAreaPropertiesInitClass( TelType* );
extern  MtblPtr  TelBackSurfaceAreaPropertiesInitClass( TelType* );
extern  MtblPtr  TelFaceCullingModeInitClass( TelType* );
extern  MtblPtr  TelDepthCueIndexInitClass( TelType* );
extern  MtblPtr  TelInteriorShadingMethodInitClass( TelType* );
extern  MtblPtr  TelViewIndexInitClass( TelType* );
extern  MtblPtr  TelTriangleMeshInitClass( TelType* );
extern  MtblPtr  TelApplicationDataInitClass( TelType* );
extern  MtblPtr  TelQuadrangleInitClass( TelType* );
extern  MtblPtr  TelPolygonIndicesInitClass( TelType* );
extern  MtblPtr  TelHighlightIndexInitClass( TelType* );
extern  MtblPtr  TelPolygonHolesInitClass( TelType* );
extern  MtblPtr  TelCurveInitClass( TelType* );
extern  MtblPtr  TelTextureIdInitClass( TelType* );
extern  MtblPtr  TelDoTextureMapInitClass( TelType* );
/*
extern  MtblPtr  TelNilInitClass( TelType* );
extern  MtblPtr  TelBlinkInitClass( TelType* );
extern  MtblPtr  TelPolygonSetInitClass( TelType* );
extern  MtblPtr  TelClippingPlaneInitClass( TelType* );
*/
#ifdef G003
extern  MtblPtr  TelDegenerateModelInitClass( TelType* );
#endif  /* G003 */
#if defined(OCC2934) && defined(WNT)
extern  MtblPtr  TelTextureMappedFontInitClass( TelType* );
#endif
/* OCC4895 SAN 22/03/04 High-level interface for controlling polygon offsets */
extern  MtblPtr  TelPolygonOffsetInitClass( TelType* );
/* OCC4895 SAN 22/03/04 High-level interface for controlling polygon offsets */
/* ABD 29/10/04  Transform Persistence of Presentation( pan, zoom, rotate ) */
extern  MtblPtr  TelTransformPersistentInitClass( TelType* );
/* ABD 29/10/04  Transform Persistence of Presentation( pan, zoom, rotate ) */

extern  MtblPtr  TelParrayInitClass( TelType* );
/* OCC???? SZV 11/08/05 Implementation of callbacks */
extern  MtblPtr  TelUserdrawInitClass( TelType* );
/* OCC???? SZV 11/08/05 Implementation of callbacks */

static  MtblPtr  (*TsmInitClassTable[])(TelType*) =
{
        TelLabelInitClass,
        TelExecuteStructureInitClass,
	/* ABD 29/10/04  Transform Persistence of Presentation( pan, zoom, rotate ) */
        TelTransformPersistentInitClass,
	/* ABD 29/10/04  Transform Persistence of Presentation( pan, zoom, rotate ) */
        TelPolylineColourInitClass,
        TelPolylineWidthInitClass,
        TelPolylineInitClass,
        TelPickIdInitClass,
        TelPolylineTypeInitClass,
        TelEdgeColourInitClass,
        TelEdgeTypeInitClass,
        TelEdgeWidthInitClass,
        TelAntiAliasingInitClass,
        TelPolygonInitClass,
        TelInteriorColourInitClass,
        TelInteriorStyleInitClass,
        TelEdgeFlagInitClass,
        TelPolymarkerColourInitClass,
        TelPolymarkerSizeInitClass,
        TelMarkerInitClass,
        TelMarkerSetInitClass,
        TelLocalTran3InitClass,
        TelAddNamesetInitClass,
        TelRemoveNamesetInitClass,
        TelBackInteriorColourInitClass,
        TelInteriorStyleIndexInitClass,
        TelFaceDistinguishingModeInitClass,
        TelTextColourInitClass,
        TelTextInitClass,
        TelTextFontInitClass,
        TelTextHeightInitClass,
        /*OCC7456 abd 14.12.2004 Text alingnment attributes  */
        TelTextAlignInitClass,
        /*OCC7456 abd 14.12.2004 Text alingnment attributes  */
        TelCharacterSpacingInitClass,
        TelCharacterExpansionFactorInitClass,
        TelPolymarkerTypeInitClass,
        TelInteriorReflectanceEquationInitClass,
        TelBackInteriorReflectanceEquationInitClass,
        TelLightSrcStateInitClass,
        TelSurfaceAreaPropertiesInitClass,
        TelBackSurfaceAreaPropertiesInitClass,
        TelFaceCullingModeInitClass,
        TelDepthCueIndexInitClass,
        TelInteriorShadingMethodInitClass,
        TelViewIndexInitClass,
        TelTriangleMeshInitClass,
        TelApplicationDataInitClass,
        TelQuadrangleInitClass,
        TelPolygonIndicesInitClass,
        TelHighlightIndexInitClass,
        TelPolygonHolesInitClass,
        TelCurveInitClass,
        TelTextureIdInitClass,
        TelDoTextureMapInitClass, 
        TelTextColourSubTitleInitClass, 
        TelTextStyleInitClass, 
        TelTextDisplayTypeInitClass
/*
        TelNilInitClass,
        TelBlinkInitClass,
        TelPolygonSetInitClass,
        TelClippingPlaneInitClass,
*/
#ifdef G003
        , TelDegenerateModelInitClass
#endif  /* G003 */
#ifdef G005
        , TelParrayInitClass
#endif  /* G005 */
#if defined(OCC2934) && defined(WNT)
        , TelTextureMappedFontInitClass
#endif
/* OCC4895 SAN 22/03/04 High-level interface for controlling polygon offsets */
        , TelPolygonOffsetInitClass
/* OCC4895 SAN 22/03/04 High-level interface for controlling polygon offsets */
/* OCC???? SZV 11/08/05 Implementation of callbacks */
	, TelUserdrawInitClass
/* OCC???? SZV 11/08/05 Implementation of callbacks */
};

#define  ClassTableSize  sizeof(TsmInitClassTable)/sizeof(TStatus (*)())


/*----------------------------------------------------------------------*/

void
TelHookOnAllClasses(void)
{
    TsmInitAllClasses( TsmInitClassTable, ClassTableSize );
    return;
}

/*----------------------------------------------------------------------*/
#ifndef OCC7667
#define GL2PS_LINE_STIPPLE_PATTERN    14
#endif

void
TsmInitAttributes()
{
    unsigned  int  interiors[TEL_HS_USER_DEF_START][32];
    Tint      i;
/*    static int nombre;*/

    linestyleBase = glGenLists(5);

    /* Line */

    glNewList( linestyleBase+TEL_LS_DOT, GL_COMPILE);
#ifndef OCC7667
    glPassThrough( GL2PS_LINE_STIPPLE_PATTERN );
    glPassThrough( DOT_LS );
#endif
    glLineStipple(1,  DOT_LS );
    glEndList();

    glNewList( linestyleBase+TEL_LS_DASH_DOT, GL_COMPILE);
#ifndef OCC7667
    glPassThrough( GL2PS_LINE_STIPPLE_PATTERN );
    glPassThrough( DASH_DOT_LS );
#endif
    glLineStipple(1,  DASH_DOT_LS );
    glEndList();

    glNewList( linestyleBase+TEL_LS_DASH, GL_COMPILE);
#ifndef OCC7667
    glPassThrough( GL2PS_LINE_STIPPLE_PATTERN );
    glPassThrough( DASH_LS );
#endif
    glLineStipple(1,  DASH_LS );
    glEndList();

    glNewList( linestyleBase+TEL_LS_DOUBLE_DOT_DASH, GL_COMPILE);
#ifndef OCC7667
    glPassThrough( GL2PS_LINE_STIPPLE_PATTERN );
    glPassThrough( DASH_DDOT_LS );
#endif
    glLineStipple(1,  DASH_DDOT_LS );
    glEndList();

        /* FSXXX
         * GL_POLYGON_STIPPLE
         * need 32x32 stipple patterns
         */
    cmn_memset( interiors, 0xFF, sizeof(interiors) );


/*    modified by NIZHNY-VTN Tue Oct 26 09:54:20 1999 ___BEGIN___ */
    interiors[TEL_HS_CROSS][1]  = 0xBBBBBBBB,
    interiors[TEL_HS_CROSS][2]  = 0xEEEEEEEE,
    interiors[TEL_HS_CROSS][3]  = 0xBBBBBBBB,
    interiors[TEL_HS_CROSS][4]  = 0xEEEEEEEE,
    interiors[TEL_HS_CROSS][5]  = 0xBBBBBBBB,
    interiors[TEL_HS_CROSS][6]  = 0xEEEEEEEE,
    interiors[TEL_HS_CROSS][7]  = 0xBBBBBBBB,
    interiors[TEL_HS_CROSS][8]  = 0xEEEEEEEE,
    interiors[TEL_HS_CROSS][9]  = 0xBBBBBBBB,
    interiors[TEL_HS_CROSS][10] = 0xEEEEEEEE,
    interiors[TEL_HS_CROSS][11] = 0xBBBBBBBB,
    interiors[TEL_HS_CROSS][12] = 0xEEEEEEEE,
    interiors[TEL_HS_CROSS][13] = 0xBBBBBBBB,
    interiors[TEL_HS_CROSS][14] = 0xEEEEEEEE,
    interiors[TEL_HS_CROSS][15] = 0xBBBBBBBB,
    interiors[TEL_HS_CROSS][16]  = 0xEEEEEEEE,
    interiors[TEL_HS_CROSS][17]  = 0xBBBBBBBB,
    interiors[TEL_HS_CROSS][18]  = 0xEEEEEEEE,
    interiors[TEL_HS_CROSS][19]  = 0xBBBBBBBB,
    interiors[TEL_HS_CROSS][20]  = 0xEEEEEEEE,
    interiors[TEL_HS_CROSS][21]  = 0xBBBBBBBB,
    interiors[TEL_HS_CROSS][22]  = 0xEEEEEEEE,
    interiors[TEL_HS_CROSS][23]  = 0xBBBBBBBB,
    interiors[TEL_HS_CROSS][24]  = 0xEEEEEEEE,
    interiors[TEL_HS_CROSS][25]  = 0xBBBBBBBB,
    interiors[TEL_HS_CROSS][26] = 0xEEEEEEEE,
    interiors[TEL_HS_CROSS][27] = 0xBBBBBBBB,
    interiors[TEL_HS_CROSS][28] = 0xEEEEEEEE,
    interiors[TEL_HS_CROSS][29] = 0xBBBBBBBB,
    interiors[TEL_HS_CROSS][30] = 0xEEEEEEEE,
    interiors[TEL_HS_CROSS][31] = 0xBBBBBBBB;

    interiors[TEL_HS_CROSS_SPARSE][0]  = 0x81818181,
    interiors[TEL_HS_CROSS_SPARSE][1]  = 0x24242424,
    interiors[TEL_HS_CROSS_SPARSE][2]  = 0x18181818,
    interiors[TEL_HS_CROSS_SPARSE][3]  = 0x42424242,
    interiors[TEL_HS_CROSS_SPARSE][4]  = 0x81818181,
    interiors[TEL_HS_CROSS_SPARSE][5]  = 0x24242424,
    interiors[TEL_HS_CROSS_SPARSE][6]  = 0x18181818,
    interiors[TEL_HS_CROSS_SPARSE][7]  = 0x42424242,
    interiors[TEL_HS_CROSS_SPARSE][8]  = 0x81818181,
    interiors[TEL_HS_CROSS_SPARSE][9]  = 0x24242424,
    interiors[TEL_HS_CROSS_SPARSE][10] = 0x18181818,
    interiors[TEL_HS_CROSS_SPARSE][11] = 0x42424242,
    interiors[TEL_HS_CROSS_SPARSE][12] = 0x81818181,
    interiors[TEL_HS_CROSS_SPARSE][13] = 0x24242424,
    interiors[TEL_HS_CROSS_SPARSE][14] = 0x18181818,
    interiors[TEL_HS_CROSS_SPARSE][15] = 0x42424242,
    interiors[TEL_HS_CROSS_SPARSE][16]  = 0x81818181,
    interiors[TEL_HS_CROSS_SPARSE][17]  = 0x24242424,
    interiors[TEL_HS_CROSS_SPARSE][18]  = 0x18181818,
    interiors[TEL_HS_CROSS_SPARSE][19]  = 0x42424242,
    interiors[TEL_HS_CROSS_SPARSE][20]  = 0x81818181,
    interiors[TEL_HS_CROSS_SPARSE][21]  = 0x24242424,
    interiors[TEL_HS_CROSS_SPARSE][22]  = 0x18181818,
    interiors[TEL_HS_CROSS_SPARSE][23]  = 0x42424242,
    interiors[TEL_HS_CROSS_SPARSE][24]  = 0x81818181,
    interiors[TEL_HS_CROSS_SPARSE][25]  = 0x24242424,
    interiors[TEL_HS_CROSS_SPARSE][26] = 0x18181818,
    interiors[TEL_HS_CROSS_SPARSE][27] = 0x42424242,
    interiors[TEL_HS_CROSS_SPARSE][28] = 0x81818181,
    interiors[TEL_HS_CROSS_SPARSE][29] = 0x24242424,
    interiors[TEL_HS_CROSS_SPARSE][30] = 0x18181818,
    interiors[TEL_HS_CROSS_SPARSE][31] = 0x42424242;


    interiors[TEL_HS_GRID][0]  = 0xFFFFFFFF,
    interiors[TEL_HS_GRID][1]  = 0x88888888,
    interiors[TEL_HS_GRID][2]  = 0xFFFFFFFF,
    interiors[TEL_HS_GRID][3]  = 0x88888888,
    interiors[TEL_HS_GRID][4]  = 0xFFFFFFFF,
    interiors[TEL_HS_GRID][5]  = 0x88888888,
    interiors[TEL_HS_GRID][6]  = 0xFFFFFFFF,
    interiors[TEL_HS_GRID][7]  = 0x88888888,
    interiors[TEL_HS_GRID][8]  = 0xFFFFFFFF,
    interiors[TEL_HS_GRID][9]  = 0x88888888,
    interiors[TEL_HS_GRID][10] = 0xFFFFFFFF,
    interiors[TEL_HS_GRID][11] = 0x88888888,
    interiors[TEL_HS_GRID][12] = 0xFFFFFFFF,
    interiors[TEL_HS_GRID][13] = 0x88888888,
    interiors[TEL_HS_GRID][14] = 0xFFFFFFFF,
    interiors[TEL_HS_GRID][15] = 0x88888888,
    interiors[TEL_HS_GRID][16]  = 0xFFFFFFFF,
    interiors[TEL_HS_GRID][17]  = 0x88888888,
    interiors[TEL_HS_GRID][18]  = 0xFFFFFFFF,
    interiors[TEL_HS_GRID][19]  = 0x88888888,
    interiors[TEL_HS_GRID][20]  = 0xFFFFFFFF,
    interiors[TEL_HS_GRID][21]  = 0x88888888,
    interiors[TEL_HS_GRID][22]  = 0xFFFFFFFF,
    interiors[TEL_HS_GRID][23]  = 0x88888888,
    interiors[TEL_HS_GRID][24]  = 0xFFFFFFFF,
    interiors[TEL_HS_GRID][25]  = 0x88888888,
    interiors[TEL_HS_GRID][26] = 0xFFFFFFFF,
    interiors[TEL_HS_GRID][27] = 0x88888888,
    interiors[TEL_HS_GRID][28] = 0xFFFFFFFF,
    interiors[TEL_HS_GRID][29] = 0x88888888,
    interiors[TEL_HS_GRID][30] = 0xFFFFFFFF,
    interiors[TEL_HS_GRID][31] = 0x88888888;

    interiors[TEL_HS_GRID_SPARSE][0]  = 0xFFFFFFFF,
    interiors[TEL_HS_GRID_SPARSE][1]  = 0x80808080,
    interiors[TEL_HS_GRID_SPARSE][2]  = 0x80808080,
    interiors[TEL_HS_GRID_SPARSE][3]  = 0x80808080,
    interiors[TEL_HS_GRID_SPARSE][4]  = 0xFFFFFFFF,
    interiors[TEL_HS_GRID_SPARSE][5]  = 0x80808080,
    interiors[TEL_HS_GRID_SPARSE][6]  = 0x80808080,
    interiors[TEL_HS_GRID_SPARSE][7]  = 0x80808080,
    interiors[TEL_HS_GRID_SPARSE][8]  = 0xFFFFFFFF,
    interiors[TEL_HS_GRID_SPARSE][9]  = 0x80808080,
    interiors[TEL_HS_GRID_SPARSE][10] = 0x80808080,
    interiors[TEL_HS_GRID_SPARSE][11] = 0x80808080,
    interiors[TEL_HS_GRID_SPARSE][12] = 0xFFFFFFFF,
    interiors[TEL_HS_GRID_SPARSE][13] = 0x80808080,
    interiors[TEL_HS_GRID_SPARSE][14] = 0x80808080,
    interiors[TEL_HS_GRID_SPARSE][15] = 0x80808080,
    interiors[TEL_HS_GRID_SPARSE][16]  = 0xFFFFFFFF,
    interiors[TEL_HS_GRID_SPARSE][17]  = 0x80808080,
    interiors[TEL_HS_GRID_SPARSE][18]  = 0x80808080,
    interiors[TEL_HS_GRID_SPARSE][19]  = 0x80808080,
    interiors[TEL_HS_GRID_SPARSE][20]  = 0xFFFFFFFF,
    interiors[TEL_HS_GRID_SPARSE][21]  = 0x80808080,
    interiors[TEL_HS_GRID_SPARSE][22]  = 0x80808080,
    interiors[TEL_HS_GRID_SPARSE][23]  = 0x80808080,
    interiors[TEL_HS_GRID_SPARSE][24]  = 0xFFFFFFFF,
    interiors[TEL_HS_GRID_SPARSE][25]  = 0x80808080,
    interiors[TEL_HS_GRID_SPARSE][26] = 0x80808080,
    interiors[TEL_HS_GRID_SPARSE][27] = 0x80808080,
    interiors[TEL_HS_GRID_SPARSE][28] = 0xFFFFFFFF,
    interiors[TEL_HS_GRID_SPARSE][29] = 0x80808080,
    interiors[TEL_HS_GRID_SPARSE][30] = 0x80808080,
    interiors[TEL_HS_GRID_SPARSE][31] = 0x80808080;

    interiors[TEL_HS_DIAG_45][0]  = 0x88888888,
    interiors[TEL_HS_DIAG_45][1]  = 0x22222222,
    interiors[TEL_HS_DIAG_45][2]  = 0x88888888,
    interiors[TEL_HS_DIAG_45][3]  = 0x22222222,
    interiors[TEL_HS_DIAG_45][4]  = 0x88888888,
    interiors[TEL_HS_DIAG_45][5]  = 0x22222222,
    interiors[TEL_HS_DIAG_45][6]  = 0x88888888,
    interiors[TEL_HS_DIAG_45][7]  = 0x22222222,
    interiors[TEL_HS_DIAG_45][8]  = 0x88888888,
    interiors[TEL_HS_DIAG_45][9]  = 0x22222222,
    interiors[TEL_HS_DIAG_45][10] = 0x88888888,
    interiors[TEL_HS_DIAG_45][11] = 0x22222222,
    interiors[TEL_HS_DIAG_45][12] = 0x88888888,
    interiors[TEL_HS_DIAG_45][13] = 0x22222222,
    interiors[TEL_HS_DIAG_45][14] = 0x88888888,
    interiors[TEL_HS_DIAG_45][15] = 0x22222222,
    interiors[TEL_HS_DIAG_45][16]  = 0x88888888,
    interiors[TEL_HS_DIAG_45][17]  = 0x22222222,
    interiors[TEL_HS_DIAG_45][18]  = 0x88888888,
    interiors[TEL_HS_DIAG_45][19]  = 0x22222222,
    interiors[TEL_HS_DIAG_45][20]  = 0x88888888,
    interiors[TEL_HS_DIAG_45][21]  = 0x22222222,
    interiors[TEL_HS_DIAG_45][22]  = 0x88888888,
    interiors[TEL_HS_DIAG_45][23]  = 0x22222222,
    interiors[TEL_HS_DIAG_45][24]  = 0x88888888,
    interiors[TEL_HS_DIAG_45][25]  = 0x22222222,
    interiors[TEL_HS_DIAG_45][26] = 0x88888888,
    interiors[TEL_HS_DIAG_45][27] = 0x22222222,
    interiors[TEL_HS_DIAG_45][28] = 0x88888888,
    interiors[TEL_HS_DIAG_45][29] = 0x22222222,
    interiors[TEL_HS_DIAG_45][30] = 0x88888888,
    interiors[TEL_HS_DIAG_45][31] = 0x22222222;

    interiors[TEL_HS_DIAG_135][0]  = 0x11111111,
    interiors[TEL_HS_DIAG_135][1]  = 0x44444444,
    interiors[TEL_HS_DIAG_135][2]  = 0x11111111,
    interiors[TEL_HS_DIAG_135][3]  = 0x44444444,
    interiors[TEL_HS_DIAG_135][4]  = 0x11111111,
    interiors[TEL_HS_DIAG_135][5]  = 0x44444444,
    interiors[TEL_HS_DIAG_135][6]  = 0x11111111,
    interiors[TEL_HS_DIAG_135][7]  = 0x44444444,
    interiors[TEL_HS_DIAG_135][8]  = 0x11111111,
    interiors[TEL_HS_DIAG_135][9]  = 0x44444444,
    interiors[TEL_HS_DIAG_135][10] = 0x11111111,
    interiors[TEL_HS_DIAG_135][11] = 0x44444444,
    interiors[TEL_HS_DIAG_135][12] = 0x11111111,
    interiors[TEL_HS_DIAG_135][13] = 0x44444444,
    interiors[TEL_HS_DIAG_135][14] = 0x11111111,
    interiors[TEL_HS_DIAG_135][15] = 0x44444444,
    interiors[TEL_HS_DIAG_135][16]  = 0x11111111,
    interiors[TEL_HS_DIAG_135][17]  = 0x44444444,
    interiors[TEL_HS_DIAG_135][18]  = 0x11111111,
    interiors[TEL_HS_DIAG_135][19]  = 0x44444444,
    interiors[TEL_HS_DIAG_135][20]  = 0x11111111,
    interiors[TEL_HS_DIAG_135][21]  = 0x44444444,
    interiors[TEL_HS_DIAG_135][22]  = 0x11111111,
    interiors[TEL_HS_DIAG_135][23]  = 0x44444444,
    interiors[TEL_HS_DIAG_135][24]  = 0x11111111,
    interiors[TEL_HS_DIAG_135][25]  = 0x44444444,
    interiors[TEL_HS_DIAG_135][26] = 0x11111111,
    interiors[TEL_HS_DIAG_135][27] = 0x44444444,
    interiors[TEL_HS_DIAG_135][28] = 0x11111111,
    interiors[TEL_HS_DIAG_135][29] = 0x44444444,
    interiors[TEL_HS_DIAG_135][30] = 0x11111111,
    interiors[TEL_HS_DIAG_135][31] = 0x44444444;

    interiors[TEL_HS_HORIZONTAL][0]  = 0xFFFFFFFF,
    interiors[TEL_HS_HORIZONTAL][1]  = 0x00000000,
    interiors[TEL_HS_HORIZONTAL][2]  = 0xFFFFFFFF,
    interiors[TEL_HS_HORIZONTAL][3]  = 0x00000000,
    interiors[TEL_HS_HORIZONTAL][4]  = 0xFFFFFFFF,
    interiors[TEL_HS_HORIZONTAL][5]  = 0x00000000,
    interiors[TEL_HS_HORIZONTAL][6]  = 0xFFFFFFFF,
    interiors[TEL_HS_HORIZONTAL][7]  = 0x00000000,
    interiors[TEL_HS_HORIZONTAL][8]  = 0xFFFFFFFF,
    interiors[TEL_HS_HORIZONTAL][9]  = 0x00000000,
    interiors[TEL_HS_HORIZONTAL][10] = 0xFFFFFFFF,
    interiors[TEL_HS_HORIZONTAL][11] = 0x00000000,
    interiors[TEL_HS_HORIZONTAL][12] = 0xFFFFFFFF,
    interiors[TEL_HS_HORIZONTAL][13] = 0x00000000,
    interiors[TEL_HS_HORIZONTAL][14] = 0xFFFFFFFF,
    interiors[TEL_HS_HORIZONTAL][15] = 0x00000000,
    interiors[TEL_HS_HORIZONTAL][16]  = 0xFFFFFFFF,
    interiors[TEL_HS_HORIZONTAL][17]  = 0x00000000,
    interiors[TEL_HS_HORIZONTAL][18]  = 0xFFFFFFFF,
    interiors[TEL_HS_HORIZONTAL][19]  = 0x00000000,
    interiors[TEL_HS_HORIZONTAL][20]  = 0xFFFFFFFF,
    interiors[TEL_HS_HORIZONTAL][21]  = 0x00000000,
    interiors[TEL_HS_HORIZONTAL][22]  = 0xFFFFFFFF,
    interiors[TEL_HS_HORIZONTAL][23]  = 0x00000000,
    interiors[TEL_HS_HORIZONTAL][24]  = 0xFFFFFFFF,
    interiors[TEL_HS_HORIZONTAL][25]  = 0x00000000,
    interiors[TEL_HS_HORIZONTAL][26] = 0xFFFFFFFF,
    interiors[TEL_HS_HORIZONTAL][27] = 0x00000000,
    interiors[TEL_HS_HORIZONTAL][28] = 0xFFFFFFFF,
    interiors[TEL_HS_HORIZONTAL][29] = 0x00000000,
    interiors[TEL_HS_HORIZONTAL][30] = 0xFFFFFFFF,
    interiors[TEL_HS_HORIZONTAL][31] = 0x00000000;

    interiors[TEL_HS_VERTICAL][0]  = 0x11111111,
    interiors[TEL_HS_VERTICAL][1]  = 0x11111111,
    interiors[TEL_HS_VERTICAL][2]  = 0x11111111,
    interiors[TEL_HS_VERTICAL][3]  = 0x11111111,
    interiors[TEL_HS_VERTICAL][4]  = 0x11111111,
    interiors[TEL_HS_VERTICAL][5]  = 0x11111111,
    interiors[TEL_HS_VERTICAL][6]  = 0x11111111,
    interiors[TEL_HS_VERTICAL][7]  = 0x11111111,
    interiors[TEL_HS_VERTICAL][8]  = 0x11111111,
    interiors[TEL_HS_VERTICAL][9]  = 0x11111111,
    interiors[TEL_HS_VERTICAL][10] = 0x11111111,
    interiors[TEL_HS_VERTICAL][11] = 0x11111111,
    interiors[TEL_HS_VERTICAL][12] = 0x11111111,
    interiors[TEL_HS_VERTICAL][13] = 0x11111111,
    interiors[TEL_HS_VERTICAL][14] = 0x11111111,
    interiors[TEL_HS_VERTICAL][15] = 0x11111111,
    interiors[TEL_HS_VERTICAL][16]  = 0x11111111,
    interiors[TEL_HS_VERTICAL][17]  = 0x11111111,
    interiors[TEL_HS_VERTICAL][18]  = 0x11111111,
    interiors[TEL_HS_VERTICAL][19]  = 0x11111111,
    interiors[TEL_HS_VERTICAL][20]  = 0x11111111,
    interiors[TEL_HS_VERTICAL][21]  = 0x11111111,
    interiors[TEL_HS_VERTICAL][22]  = 0x11111111,
    interiors[TEL_HS_VERTICAL][23]  = 0x11111111,
    interiors[TEL_HS_VERTICAL][24]  = 0x11111111,
    interiors[TEL_HS_VERTICAL][25]  = 0x11111111,
    interiors[TEL_HS_VERTICAL][26] = 0x11111111,
    interiors[TEL_HS_VERTICAL][27] = 0x11111111,
    interiors[TEL_HS_VERTICAL][28] = 0x11111111,
    interiors[TEL_HS_VERTICAL][29] = 0x11111111,
    interiors[TEL_HS_VERTICAL][30] = 0x11111111,
    interiors[TEL_HS_VERTICAL][31] = 0x11111111;

    interiors[TEL_HS_DIAG_45_SPARSE][0]  = 0x80808080,
    interiors[TEL_HS_DIAG_45_SPARSE][1]  = 0x20202020,
    interiors[TEL_HS_DIAG_45_SPARSE][2]  = 0x08080808,
    interiors[TEL_HS_DIAG_45_SPARSE][3]  = 0x02020202,
    interiors[TEL_HS_DIAG_45_SPARSE][4]  = 0x80808080,
    interiors[TEL_HS_DIAG_45_SPARSE][5]  = 0x20202020,
    interiors[TEL_HS_DIAG_45_SPARSE][6]  = 0x08080808,
    interiors[TEL_HS_DIAG_45_SPARSE][7]  = 0x02020202,
    interiors[TEL_HS_DIAG_45_SPARSE][8]  = 0x80808080,
    interiors[TEL_HS_DIAG_45_SPARSE][9]  = 0x20202020,
    interiors[TEL_HS_DIAG_45_SPARSE][10] = 0x08080808,
    interiors[TEL_HS_DIAG_45_SPARSE][11] = 0x02020202,
    interiors[TEL_HS_DIAG_45_SPARSE][12] = 0x80808080,
    interiors[TEL_HS_DIAG_45_SPARSE][13] = 0x20202020,
    interiors[TEL_HS_DIAG_45_SPARSE][14] = 0x08080808,
    interiors[TEL_HS_DIAG_45_SPARSE][15] = 0x02020202,
    interiors[TEL_HS_DIAG_45_SPARSE][16]  = 0x80808080,
    interiors[TEL_HS_DIAG_45_SPARSE][17]  = 0x20202020,
    interiors[TEL_HS_DIAG_45_SPARSE][18]  = 0x08080808,
    interiors[TEL_HS_DIAG_45_SPARSE][19]  = 0x02020202,
    interiors[TEL_HS_DIAG_45_SPARSE][20]  = 0x80808080,
    interiors[TEL_HS_DIAG_45_SPARSE][21]  = 0x20202020,
    interiors[TEL_HS_DIAG_45_SPARSE][22]  = 0x08080808,
    interiors[TEL_HS_DIAG_45_SPARSE][23]  = 0x02020202,
    interiors[TEL_HS_DIAG_45_SPARSE][24]  = 0x80808080,
    interiors[TEL_HS_DIAG_45_SPARSE][25]  = 0x20202020,
    interiors[TEL_HS_DIAG_45_SPARSE][26] = 0x08080808,
    interiors[TEL_HS_DIAG_45_SPARSE][27] = 0x02020202,
    interiors[TEL_HS_DIAG_45_SPARSE][28] = 0x80808080,
    interiors[TEL_HS_DIAG_45_SPARSE][29] = 0x20202020,
    interiors[TEL_HS_DIAG_45_SPARSE][30] = 0x08080808,
    interiors[TEL_HS_DIAG_45_SPARSE][31] = 0x02020202;

    interiors[TEL_HS_DIAG_135_SPARSE][0]  = 0x01010101,
    interiors[TEL_HS_DIAG_135_SPARSE][1]  = 0x04040404,
    interiors[TEL_HS_DIAG_135_SPARSE][2]  = 0x10101010,
    interiors[TEL_HS_DIAG_135_SPARSE][3]  = 0x40404040,
    interiors[TEL_HS_DIAG_135_SPARSE][4]  = 0x01010101,
    interiors[TEL_HS_DIAG_135_SPARSE][5]  = 0x04040404,
    interiors[TEL_HS_DIAG_135_SPARSE][6]  = 0x10101010,
    interiors[TEL_HS_DIAG_135_SPARSE][7]  = 0x40404040,
    interiors[TEL_HS_DIAG_135_SPARSE][8]  = 0x01010101,
    interiors[TEL_HS_DIAG_135_SPARSE][9]  = 0x04040404,
    interiors[TEL_HS_DIAG_135_SPARSE][10] = 0x10101010,
    interiors[TEL_HS_DIAG_135_SPARSE][11] = 0x40404040,
    interiors[TEL_HS_DIAG_135_SPARSE][12] = 0x01010101,
    interiors[TEL_HS_DIAG_135_SPARSE][13] = 0x04040404,
    interiors[TEL_HS_DIAG_135_SPARSE][14] = 0x10101010,
    interiors[TEL_HS_DIAG_135_SPARSE][15] = 0x40404040,
    interiors[TEL_HS_DIAG_135_SPARSE][16]  = 0x01010101,
    interiors[TEL_HS_DIAG_135_SPARSE][17]  = 0x04040404,
    interiors[TEL_HS_DIAG_135_SPARSE][18]  = 0x10101010,
    interiors[TEL_HS_DIAG_135_SPARSE][19]  = 0x40404040,
    interiors[TEL_HS_DIAG_135_SPARSE][20]  = 0x01010101,
    interiors[TEL_HS_DIAG_135_SPARSE][21]  = 0x04040404,
    interiors[TEL_HS_DIAG_135_SPARSE][22]  = 0x10101010,
    interiors[TEL_HS_DIAG_135_SPARSE][23]  = 0x40404040,
    interiors[TEL_HS_DIAG_135_SPARSE][24]  = 0x01010101,
    interiors[TEL_HS_DIAG_135_SPARSE][25]  = 0x04040404,
    interiors[TEL_HS_DIAG_135_SPARSE][26] = 0x10101010,
    interiors[TEL_HS_DIAG_135_SPARSE][27] = 0x40404040,
    interiors[TEL_HS_DIAG_135_SPARSE][28] = 0x01010101,
    interiors[TEL_HS_DIAG_135_SPARSE][29] = 0x04040404,
    interiors[TEL_HS_DIAG_135_SPARSE][30] = 0x10101010,
    interiors[TEL_HS_DIAG_135_SPARSE][31] = 0x40404040;

    interiors[TEL_HS_HORIZONTAL_SPARSE][0]  = 0xFFFFFFFF,
    interiors[TEL_HS_HORIZONTAL_SPARSE][1]  = 0x00000000,
    interiors[TEL_HS_HORIZONTAL_SPARSE][2]  = 0x00000000,
    interiors[TEL_HS_HORIZONTAL_SPARSE][3]  = 0x00000000,
    interiors[TEL_HS_HORIZONTAL_SPARSE][4]  = 0xFFFFFFFF,
    interiors[TEL_HS_HORIZONTAL_SPARSE][5]  = 0x00000000,
    interiors[TEL_HS_HORIZONTAL_SPARSE][6]  = 0x00000000,
    interiors[TEL_HS_HORIZONTAL_SPARSE][7]  = 0x00000000,
    interiors[TEL_HS_HORIZONTAL_SPARSE][8]  = 0xFFFFFFFF,
    interiors[TEL_HS_HORIZONTAL_SPARSE][9]  = 0x00000000,
    interiors[TEL_HS_HORIZONTAL_SPARSE][10] = 0x00000000,
    interiors[TEL_HS_HORIZONTAL_SPARSE][11] = 0x00000000,
    interiors[TEL_HS_HORIZONTAL_SPARSE][12] = 0xFFFFFFFF,
    interiors[TEL_HS_HORIZONTAL_SPARSE][13] = 0x00000000,
    interiors[TEL_HS_HORIZONTAL_SPARSE][14] = 0x00000000,
    interiors[TEL_HS_HORIZONTAL_SPARSE][15] = 0x00000000,
    interiors[TEL_HS_HORIZONTAL_SPARSE][16]  = 0xFFFFFFFF,
    interiors[TEL_HS_HORIZONTAL_SPARSE][17]  = 0x00000000,
    interiors[TEL_HS_HORIZONTAL_SPARSE][18]  = 0x00000000,
    interiors[TEL_HS_HORIZONTAL_SPARSE][19]  = 0x00000000,
    interiors[TEL_HS_HORIZONTAL_SPARSE][20]  = 0xFFFFFFFF,
    interiors[TEL_HS_HORIZONTAL_SPARSE][21]  = 0x00000000,
    interiors[TEL_HS_HORIZONTAL_SPARSE][22]  = 0x00000000,
    interiors[TEL_HS_HORIZONTAL_SPARSE][23]  = 0x00000000,
    interiors[TEL_HS_HORIZONTAL_SPARSE][24]  = 0xFFFFFFFF,
    interiors[TEL_HS_HORIZONTAL_SPARSE][25]  = 0x00000000,
    interiors[TEL_HS_HORIZONTAL_SPARSE][26] = 0x00000000,
    interiors[TEL_HS_HORIZONTAL_SPARSE][27] = 0x00000000,
    interiors[TEL_HS_HORIZONTAL_SPARSE][28] = 0xFFFFFFFF,
    interiors[TEL_HS_HORIZONTAL_SPARSE][29] = 0x00000000,
    interiors[TEL_HS_HORIZONTAL_SPARSE][30] = 0x00000000,
    interiors[TEL_HS_HORIZONTAL_SPARSE][31] = 0x00000000;
/*    modified by NIZHNY-VTN Tue Oct 26 09:55:42 1999 ___END___ */

    interiors[TEL_HS_VERTICAL_SPARSE][0]  = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][1]  = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][2]  = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][3]  = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][4]  = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][5]  = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][6]  = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][7]  = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][8]  = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][9]  = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][10] = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][11] = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][12] = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][13] = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][14] = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][15] = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][16]  = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][17]  = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][18]  = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][19]  = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][20]  = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][21]  = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][22]  = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][23]  = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][24]  = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][25]  = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][26] = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][27] = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][28] = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][29] = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][30] = 0x10101010,
    interiors[TEL_HS_VERTICAL_SPARSE][31] = 0x10101010;

    patternBase = glGenLists(TEL_HS_USER_DEF_START);
    for( i = 1; i < TEL_HS_USER_DEF_START; i++ )
    {
        glNewList( patternBase+i, GL_COMPILE);
        glPolygonStipple((const GLubyte *) (interiors[i]));
        glEndList();
    }

    /* Init des fontes */
    (void) InitPMFont();

    return;
}

/* Following Section relates to POLYMARKER */

#define TEL_NO_OF_SIZES     (long)13
#define TEL_NB_OF_MARKERS   (int)5

typedef struct
{
   Tchar *str;
   Tfloat  width, height; /* FSXXX  Tint -> Tfloat */   
   Tint  offset;
} PM_FONT_INFO, *pm_font_info;

#define PM_PLUS_10_NUM  9*2
#define PM_PLUS_15_NUM  11*2
#define PM_PLUS_20_NUM  13*2
#define PM_PLUS_25_NUM  15*2
#define PM_PLUS_30_NUM  17*3
#define PM_PLUS_35_NUM  19*3
#define PM_PLUS_40_NUM  21*3
#define PM_PLUS_45_NUM  23*3
#define PM_PLUS_50_NUM  25*4
#define PM_PLUS_55_NUM  27*4
#define PM_PLUS_60_NUM  29*4
#define PM_PLUS_65_NUM  31*4
#define PM_PLUS_70_NUM  32*4

#define PM_STAR_10_NUM  9
#define PM_STAR_15_NUM  11*2
#define PM_STAR_20_NUM  13*2
#define PM_STAR_25_NUM  15*2
#define PM_STAR_30_NUM  17*2
#define PM_STAR_35_NUM  19*2
#define PM_STAR_40_NUM  21*3
#define PM_STAR_45_NUM  23*3
#define PM_STAR_50_NUM  25*3
#define PM_STAR_55_NUM  27*3
#define PM_STAR_60_NUM  29*4
#define PM_STAR_65_NUM  32*4
#define PM_STAR_70_NUM  32*4

#define PM_CROSS_10_NUM 7
#define PM_CROSS_15_NUM 9*2
#define PM_CROSS_20_NUM 11*2
#define PM_CROSS_25_NUM 13*2
#define PM_CROSS_30_NUM 15*2
#define PM_CROSS_35_NUM 17*3
#define PM_CROSS_40_NUM 19*3
#define PM_CROSS_45_NUM 21*3
#define PM_CROSS_50_NUM 23*3
#define PM_CROSS_55_NUM 25*4
#define PM_CROSS_60_NUM 27*4
#define PM_CROSS_65_NUM 32*4
#define PM_CROSS_70_NUM 32*4

#define PM_CIRC_10_NUM  7
#define PM_CIRC_15_NUM  9*2
#define PM_CIRC_20_NUM  9*2
#define PM_CIRC_25_NUM  11*2
#define PM_CIRC_30_NUM  13*2
#define PM_CIRC_35_NUM  15*2
#define PM_CIRC_40_NUM  17*3
#define PM_CIRC_45_NUM  19*3
#define PM_CIRC_50_NUM  21*3
#define PM_CIRC_55_NUM  23*3
#define PM_CIRC_60_NUM  25*4
#define PM_CIRC_65_NUM  27*4
#define PM_CIRC_70_NUM  29*4

#define PM_DOT_10_NUM  5
#define PM_DOT_15_NUM  5
#define PM_DOT_20_NUM  7
#define PM_DOT_25_NUM  7
#define PM_DOT_30_NUM  9*2
#define PM_DOT_35_NUM  9*2
#define PM_DOT_40_NUM  9*2
#define PM_DOT_45_NUM  9*2
#define PM_DOT_50_NUM  9*2
#define PM_DOT_55_NUM  9*2
#define PM_DOT_60_NUM  11*2
#define PM_DOT_65_NUM  11*2
#define PM_DOT_70_NUM  11*2

#define PM_PLUS_10_OFT  0
#define PM_PLUS_15_OFT  PM_PLUS_10_OFT + PM_PLUS_10_NUM
#define PM_PLUS_20_OFT  PM_PLUS_15_OFT + PM_PLUS_15_NUM
#define PM_PLUS_25_OFT  PM_PLUS_20_OFT + PM_PLUS_20_NUM
#define PM_PLUS_30_OFT  PM_PLUS_25_OFT + PM_PLUS_25_NUM
#define PM_PLUS_35_OFT  PM_PLUS_30_OFT + PM_PLUS_30_NUM
#define PM_PLUS_40_OFT  PM_PLUS_35_OFT + PM_PLUS_35_NUM
#define PM_PLUS_45_OFT  PM_PLUS_40_OFT + PM_PLUS_40_NUM
#define PM_PLUS_50_OFT  PM_PLUS_45_OFT + PM_PLUS_45_NUM
#define PM_PLUS_55_OFT  PM_PLUS_50_OFT + PM_PLUS_50_NUM
#define PM_PLUS_60_OFT  PM_PLUS_55_OFT + PM_PLUS_55_NUM
#define PM_PLUS_65_OFT  PM_PLUS_60_OFT + PM_PLUS_60_NUM
#define PM_PLUS_70_OFT  PM_PLUS_65_OFT + PM_PLUS_65_NUM

#define PM_STAR_10_OFT  PM_PLUS_70_OFT + PM_PLUS_70_NUM
#define PM_STAR_15_OFT  PM_STAR_10_OFT + PM_STAR_10_NUM
#define PM_STAR_20_OFT  PM_STAR_15_OFT + PM_STAR_15_NUM
#define PM_STAR_25_OFT  PM_STAR_20_OFT + PM_STAR_20_NUM
#define PM_STAR_30_OFT  PM_STAR_25_OFT + PM_STAR_25_NUM
#define PM_STAR_35_OFT  PM_STAR_30_OFT + PM_STAR_30_NUM
#define PM_STAR_40_OFT  PM_STAR_35_OFT + PM_STAR_35_NUM
#define PM_STAR_45_OFT  PM_STAR_40_OFT + PM_STAR_40_NUM
#define PM_STAR_50_OFT  PM_STAR_45_OFT + PM_STAR_45_NUM
#define PM_STAR_55_OFT  PM_STAR_50_OFT + PM_STAR_50_NUM
#define PM_STAR_60_OFT  PM_STAR_55_OFT + PM_STAR_55_NUM
#define PM_STAR_65_OFT  PM_STAR_60_OFT + PM_STAR_60_NUM
#define PM_STAR_70_OFT  PM_STAR_65_OFT + PM_STAR_65_NUM

#define PM_CROSS_10_OFT  PM_STAR_70_OFT + PM_STAR_70_NUM
#define PM_CROSS_15_OFT  PM_CROSS_10_OFT + PM_CROSS_10_NUM
#define PM_CROSS_20_OFT  PM_CROSS_15_OFT + PM_CROSS_15_NUM
#define PM_CROSS_25_OFT  PM_CROSS_20_OFT + PM_CROSS_20_NUM
#define PM_CROSS_30_OFT  PM_CROSS_25_OFT + PM_CROSS_25_NUM
#define PM_CROSS_35_OFT  PM_CROSS_30_OFT + PM_CROSS_30_NUM
#define PM_CROSS_40_OFT  PM_CROSS_35_OFT + PM_CROSS_35_NUM
#define PM_CROSS_45_OFT  PM_CROSS_40_OFT + PM_CROSS_40_NUM
#define PM_CROSS_50_OFT  PM_CROSS_45_OFT + PM_CROSS_45_NUM
#define PM_CROSS_55_OFT  PM_CROSS_50_OFT + PM_CROSS_50_NUM
#define PM_CROSS_60_OFT  PM_CROSS_55_OFT + PM_CROSS_55_NUM
#define PM_CROSS_65_OFT  PM_CROSS_60_OFT + PM_CROSS_60_NUM
#define PM_CROSS_70_OFT  PM_CROSS_65_OFT + PM_CROSS_65_NUM

#define PM_CIRC_10_OFT  PM_CROSS_70_OFT + PM_CROSS_70_NUM
#define PM_CIRC_15_OFT  PM_CIRC_10_OFT + PM_CIRC_10_NUM
#define PM_CIRC_20_OFT  PM_CIRC_15_OFT + PM_CIRC_15_NUM
#define PM_CIRC_25_OFT  PM_CIRC_20_OFT + PM_CIRC_20_NUM
#define PM_CIRC_30_OFT  PM_CIRC_25_OFT + PM_CIRC_25_NUM
#define PM_CIRC_35_OFT  PM_CIRC_30_OFT + PM_CIRC_30_NUM
#define PM_CIRC_40_OFT  PM_CIRC_35_OFT + PM_CIRC_35_NUM
#define PM_CIRC_45_OFT  PM_CIRC_40_OFT + PM_CIRC_40_NUM
#define PM_CIRC_50_OFT  PM_CIRC_45_OFT + PM_CIRC_45_NUM
#define PM_CIRC_55_OFT  PM_CIRC_50_OFT + PM_CIRC_50_NUM
#define PM_CIRC_60_OFT  PM_CIRC_55_OFT + PM_CIRC_55_NUM
#define PM_CIRC_65_OFT  PM_CIRC_60_OFT + PM_CIRC_60_NUM
#define PM_CIRC_70_OFT  PM_CIRC_65_OFT + PM_CIRC_65_NUM

#define PM_DOT_10_OFT  PM_CIRC_70_OFT + PM_CIRC_70_NUM
#define PM_DOT_15_OFT  PM_DOT_10_OFT + PM_DOT_10_NUM
#define PM_DOT_20_OFT  PM_DOT_15_OFT + PM_DOT_15_NUM
#define PM_DOT_25_OFT  PM_DOT_20_OFT + PM_DOT_20_NUM
#define PM_DOT_30_OFT  PM_DOT_25_OFT + PM_DOT_25_NUM
#define PM_DOT_35_OFT  PM_DOT_30_OFT + PM_DOT_30_NUM
#define PM_DOT_40_OFT  PM_DOT_35_OFT + PM_DOT_35_NUM
#define PM_DOT_45_OFT  PM_DOT_40_OFT + PM_DOT_40_NUM
#define PM_DOT_50_OFT  PM_DOT_45_OFT + PM_DOT_45_NUM
#define PM_DOT_55_OFT  PM_DOT_50_OFT + PM_DOT_50_NUM
#define PM_DOT_60_OFT  PM_DOT_55_OFT + PM_DOT_55_NUM
#define PM_DOT_65_OFT  PM_DOT_60_OFT + PM_DOT_60_NUM
#define PM_DOT_70_OFT  PM_DOT_65_OFT + PM_DOT_65_NUM

static PM_FONT_INFO array[TEL_NB_OF_MARKERS][TEL_NO_OF_SIZES] =
                                         {
                                            { {"\101", ( float )9,  ( float )9,  PM_PLUS_10_OFT},
                                              {"\102", ( float )11, ( float )11, PM_PLUS_15_OFT},
                                              {"\103", ( float )13, ( float )13, PM_PLUS_20_OFT},
                                              {"\003", ( float )15, ( float )15, PM_PLUS_25_OFT},
                                              {"\004", ( float )17, ( float )17, PM_PLUS_30_OFT},
                                              {"\005", ( float )19, ( float )19, PM_PLUS_35_OFT},
                                              {"\006", ( float )21, ( float )21, PM_PLUS_40_OFT},
                                              {"\007", ( float )23, ( float )23, PM_PLUS_45_OFT},
                                              {"\010", ( float )25, ( float )25, PM_PLUS_50_OFT},
                                              {"\011", ( float )27, ( float )27, PM_PLUS_55_OFT},
                                              {"\012", ( float )29, ( float )29, PM_PLUS_60_OFT},
                                              {"\013", ( float )31, ( float )31, PM_PLUS_65_OFT},
                                              {"\014", ( float )32, ( float )32, PM_PLUS_70_OFT}  },

                                            { {"\015", ( float )7, ( float )9,   PM_STAR_10_OFT},
                                              {"\016", ( float )9, ( float )11,  PM_STAR_15_OFT},
                                              {"\017", ( float )11, ( float )13, PM_STAR_20_OFT},
                                              {"\020", ( float )13, ( float )15, PM_STAR_25_OFT},
                                              {"\021", ( float )13, ( float )17, PM_STAR_30_OFT},
                                              {"\022", ( float )15, ( float )19, PM_STAR_35_OFT},
                                              {"\023", ( float )17, ( float )21, PM_STAR_40_OFT},
                                              {"\024", ( float )19, ( float )23, PM_STAR_45_OFT},
                                              {"\025", ( float )21, ( float )25, PM_STAR_50_OFT},
                                              {"\026", ( float )23, ( float )27, PM_STAR_55_OFT},
                                              {"\027", ( float )25, ( float )29, PM_STAR_60_OFT},
                                              {"\030", ( float )32, ( float )32, PM_STAR_65_OFT},
                                              {"\031", ( float )32, ( float )32, PM_STAR_70_OFT}  },

                                            { {"\032", ( float )7, ( float )7,   PM_CROSS_10_OFT},
                                              {"\033", ( float )9, ( float )9,   PM_CROSS_15_OFT},
                                              {"\034", ( float )11, ( float )11, PM_CROSS_20_OFT},
                                              {"\035", ( float )13, ( float )13, PM_CROSS_25_OFT},
                                              {"\036", ( float )15, ( float )15, PM_CROSS_30_OFT},
                                              {"\037", ( float )17, ( float )17, PM_CROSS_35_OFT},
                                              {"\040", ( float )19, ( float )19, PM_CROSS_40_OFT},
                                              {"\041", ( float )21, ( float )21, PM_CROSS_45_OFT},
                                              {"\042", ( float )23, ( float )23, PM_CROSS_50_OFT},
                                              {"\043", ( float )25, ( float )25, PM_CROSS_55_OFT},
                                              {"\044", ( float )27, ( float )27, PM_CROSS_60_OFT},
                                              {"\045", ( float )32, ( float )32, PM_CROSS_65_OFT},
                                              {"\046", ( float )32, ( float )32, PM_CROSS_70_OFT} },

                                            { {"\047", ( float )7, ( float )7,   PM_CIRC_10_OFT},
                                              {"\050", ( float )9, ( float )9,   PM_CIRC_15_OFT},
                                              {"\051", ( float )9, ( float )9,   PM_CIRC_20_OFT},
                                              {"\052", ( float )11, ( float )11, PM_CIRC_25_OFT},
                                              {"\053", ( float )13, ( float )13, PM_CIRC_30_OFT},
                                              {"\054", ( float )15, ( float )15, PM_CIRC_35_OFT},
                                              {"\055", ( float )17, ( float )17, PM_CIRC_40_OFT},
                                              {"\056", ( float )19, ( float )19, PM_CIRC_45_OFT},
                                              {"\057", ( float )21, ( float )21, PM_CIRC_50_OFT},
                                              {"\060", ( float )23, ( float )23, PM_CIRC_55_OFT},
                                              {"\061", ( float )25, ( float )25, PM_CIRC_60_OFT},
                                              {"\062", ( float )27, ( float )27, PM_CIRC_65_OFT},
                                              {"\063", ( float )29, ( float )29, PM_CIRC_70_OFT} },

                                            { {"\064", ( float )5, ( float )5,   PM_DOT_10_OFT},
                                              {"\065", ( float )5, ( float )5,   PM_DOT_15_OFT},
                                              {"\066", ( float )7, ( float )7,   PM_DOT_20_OFT},
                                              {"\067", ( float )7, ( float )7,   PM_DOT_25_OFT},
                                              {"\070", ( float )9, ( float )9,   PM_DOT_30_OFT},
                                              {"\071", ( float )9, ( float )9,   PM_DOT_35_OFT},
                                              {"\072", ( float )9, ( float )9,   PM_DOT_40_OFT},
                                              {"\073", ( float )9, ( float )9,   PM_DOT_45_OFT},
                                              {"\074", ( float )9, ( float )9,   PM_DOT_50_OFT},
                                              {"\075", ( float )9, ( float )9,   PM_DOT_55_OFT},
                                              {"\076", ( float )11, ( float )11, PM_DOT_60_OFT},
                                              {"\077", ( float )11, ( float )11, PM_DOT_65_OFT},
                                              {"\100", ( float )11, ( float )11, PM_DOT_70_OFT} }
                                         };

#define TEL_PM_START_SIZE 1.0
#define TEL_PM_END_SIZE   7.0

#define TEL_PM_SIZE_STEP  0.5

/*----------------------------------------------------------------------*/
#ifdef OCC7667
#define GL2PS_MARKER      15
#endif

static void
InitPMFont(void)
{
   Tint         i, k1, k2, offset;
   unsigned     char raster[] = {

                                          0x08,0x00,
                                          0x08,0x00,
                                          0x08,0x00,
                                          0x08,0x00,
                                          0xff,0x80,
                                          0x08,0x00,
                                          0x08,0x00,
                                          0x08,0x00,
                                          0x08,0x00,  /* PLUS 9x9 = 1.0 */

                                          0x04,0x00,
                                          0x04,0x00,
                                          0x04,0x00,
                                          0x04,0x00,
                                          0x04,0x00,
                                          0xff,0xe0,
                                          0x04,0x00,
                                          0x04,0x00,
                                          0x04,0x00,
                                          0x04,0x00,
                                          0x04,0x00,  /* PLUS 11x11 = 1.5 */

                                          0x02,0x00,
                                          0x02,0x00,
                                          0x02,0x00,
                                          0x02,0x00,
                                          0x02,0x00,
                                          0x02,0x00,
                                          0xff,0xf8,
                                          0x02,0x00,
                                          0x02,0x00,
                                          0x02,0x00,
                                          0x02,0x00,
                                          0x02,0x00,
                                          0x02,0x00,/* PLUS 13x13 = 2.0 */

                                          0x01,0x00,
                                          0x01,0x00,
                                          0x01,0x00,
                                          0x01,0x00,
                                          0x01,0x00,
                                          0x01,0x00,
                                          0x01,0x00,
                                          0xff,0xfe,
                                          0x01,0x00,
                                          0x01,0x00,
                                          0x01,0x00,
                                          0x01,0x00,
                                          0x01,0x00,
                                          0x01,0x00,
                                          0x01,0x00,/* PLUS 15x15 = 2.5 */

                                          0x00,0x80, 0x00,
                                          0x00,0x80, 0x00,
                                          0x00,0x80, 0x00,
                                          0x00,0x80, 0x00,
                                          0x00,0x80, 0x00,
                                          0x00,0x80, 0x00,
                                          0x00,0x80, 0x00,
                                          0x00,0x80, 0x00,
                                          0xff,0xff, 0x80,
                                          0x00,0x80, 0x00,
                                          0x00,0x80, 0x00,
                                          0x00,0x80, 0x00,
                                          0x00,0x80, 0x00,
                                          0x00,0x80, 0x00,
                                          0x00,0x80, 0x00,
                                          0x00,0x80, 0x00,
                                          0x00,0x80, 0x00,/* PLUS 17x17 = 3.0 */


                                          0x00,0x40, 0x00,
                                          0x00,0x40, 0x00,
                                          0x00,0x40, 0x00,
                                          0x00,0x40, 0x00,
                                          0x00,0x40, 0x00,
                                          0x00,0x40, 0x00,
                                          0x00,0x40, 0x00,
                                          0x00,0x40, 0x00,
                                          0x00,0x40, 0x00,
                                          0xff,0xff, 0xe0,
                                          0x00,0x40, 0x00,
                                          0x00,0x40, 0x00,
                                          0x00,0x40, 0x00,
                                          0x00,0x40, 0x00,
                                          0x00,0x40, 0x00,
                                          0x00,0x40, 0x00,
                                          0x00,0x40, 0x00,
                                          0x00,0x40, 0x00,
                                          0x00,0x40, 0x00,/* PLUS 19x19 = 3.5 */

                                          0x00,0x20, 0x00,
                                          0x00,0x20, 0x00,
                                          0x00,0x20, 0x00,
                                          0x00,0x20, 0x00,
                                          0x00,0x20, 0x00,
                                          0x00,0x20, 0x00,
                                          0x00,0x20, 0x00,
                                          0x00,0x20, 0x00,
                                          0x00,0x20, 0x00,
                                          0x00,0x20, 0x00,
                                          0xff,0xff, 0xf8,
                                          0x00,0x20, 0x00,
                                          0x00,0x20, 0x00,
                                          0x00,0x20, 0x00,
                                          0x00,0x20, 0x00,
                                          0x00,0x20, 0x00,
                                          0x00,0x20, 0x00,
                                          0x00,0x20, 0x00,
                                          0x00,0x20, 0x00,
                                          0x00,0x20, 0x00,
                                          0x00,0x20, 0x00,/* PLUS 21x21 = 4.0 */

                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,
                                          0xff,0xff, 0xfe,
                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,/* PLUS 23x23 = 4.5 */

                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0xff,0xff, 0xff,0x80,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,/* PLUS 25x25 = 5.0 */

                                          0x00,0x04, 0x00,0x00,
                                          0x00,0x04, 0x00,0x00,
                                          0x00,0x04, 0x00,0x00,
                                          0x00,0x04, 0x00,0x00,
                                          0x00,0x04, 0x00,0x00,
                                          0x00,0x04, 0x00,0x00,
                                          0x00,0x04, 0x00,0x00,
                                          0x00,0x04, 0x00,0x00,
                                          0x00,0x04, 0x00,0x00,
                                          0x00,0x04, 0x00,0x00,
                                          0x00,0x04, 0x00,0x00,
                                          0x00,0x04, 0x00,0x00,
                                          0x00,0x04, 0x00,0x00,
                                          0xff,0xff, 0xff,0xe0,
                                          0x00,0x04, 0x00,0x00,
                                          0x00,0x04, 0x00,0x00,
                                          0x00,0x04, 0x00,0x00,
                                          0x00,0x04, 0x00,0x00,
                                          0x00,0x04, 0x00,0x00,
                                          0x00,0x04, 0x00,0x00,
                                          0x00,0x04, 0x00,0x00,
                                          0x00,0x04, 0x00,0x00,
                                          0x00,0x04, 0x00,0x00,
                                          0x00,0x04, 0x00,0x00,
                                          0x00,0x04, 0x00,0x00,
                                          0x00,0x04, 0x00,0x00,
                                          0x00,0x04, 0x00,0x00,/* PLUS 27x27 = 5.5 */

                                          0x00,0x02, 0x00,0x00,
                                          0x00,0x02, 0x00,0x00,
                                          0x00,0x02, 0x00,0x00,
                                          0x00,0x02, 0x00,0x00,
                                          0x00,0x02, 0x00,0x00,
                                          0x00,0x02, 0x00,0x00,
                                          0x00,0x02, 0x00,0x00,
                                          0x00,0x02, 0x00,0x00,
                                          0x00,0x02, 0x00,0x00,
                                          0x00,0x02, 0x00,0x00,
                                          0x00,0x02, 0x00,0x00,
                                          0x00,0x02, 0x00,0x00,
                                          0x00,0x02, 0x00,0x00,
                                          0x00,0x02, 0x00,0x00,
                                          0xff,0xff, 0xff,0xf8,
                                          0x00,0x02, 0x00,0x00,
                                          0x00,0x02, 0x00,0x00,
                                          0x00,0x02, 0x00,0x00,
                                          0x00,0x02, 0x00,0x00,
                                          0x00,0x02, 0x00,0x00,
                                          0x00,0x02, 0x00,0x00,
                                          0x00,0x02, 0x00,0x00,
                                          0x00,0x02, 0x00,0x00,
                                          0x00,0x02, 0x00,0x00,
                                          0x00,0x02, 0x00,0x00,
                                          0x00,0x02, 0x00,0x00,
                                          0x00,0x02, 0x00,0x00,
                                          0x00,0x02, 0x00,0x00,
                                          0x00,0x02, 0x00,0x00,/* PLUS 29x29 = 6.0 */

                                          0x00,0x01, 0x00,0x00,
                                          0x00,0x01, 0x00,0x00,
                                          0x00,0x01, 0x00,0x00,
                                          0x00,0x01, 0x00,0x00,
                                          0x00,0x01, 0x00,0x00,
                                          0x00,0x01, 0x00,0x00,
                                          0x00,0x01, 0x00,0x00,
                                          0x00,0x01, 0x00,0x00,
                                          0x00,0x01, 0x00,0x00,
                                          0x00,0x01, 0x00,0x00,
                                          0x00,0x01, 0x00,0x00,
                                          0x00,0x01, 0x00,0x00,
                                          0x00,0x01, 0x00,0x00,
                                          0x00,0x01, 0x00,0x00,
                                          0x00,0x01, 0x00,0x00,
                                          0xff,0xff, 0xff,0xfd,
                                          0x00,0x01, 0x00,0x00,
                                          0x00,0x01, 0x00,0x00,
                                          0x00,0x01, 0x00,0x00,
                                          0x00,0x01, 0x00,0x00,
                                          0x00,0x01, 0x00,0x00,
                                          0x00,0x01, 0x00,0x00,
                                          0x00,0x01, 0x00,0x00,
                                          0x00,0x01, 0x00,0x00,
                                          0x00,0x01, 0x00,0x00,
                                          0x00,0x01, 0x00,0x00,
                                          0x00,0x01, 0x00,0x00,
                                          0x00,0x01, 0x00,0x00,
                                          0x00,0x01, 0x00,0x00,
                                          0x00,0x01, 0x00,0x00,
                                          0x00,0x01, 0x00,0x00,/* PLUS 31x31 = 6.5 */

                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0xff,0xff, 0xff,0xff,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,/* PLUS 32x32 = 7.0 */

                                          0x10,
                                          0x10,
                                          0xd6,
                                          0x38,
                                          0x10,
                                          0x38,
                                          0xd6,
                                          0x10,
                                          0x10,/* STAR 7x9 = 1.0 */

                                          0x08,0x00,
                                          0x08,0x00,
                                          0x08,0x00,
                                          0xc9,0x80,
                                          0x3e,0x00,
                                          0x08,0x00,
                                          0x3e,0x00,
                                          0xc9,0x80,
                                          0x08,0x00,
                                          0x08,0x00,
                                          0x08,0x00,/* STAR 9x11 = 1.5 */

                                          0x04,0x00,
                                          0x04,0x00,
                                          0x04,0x00,
                                          0x84,0x20,
                                          0x64,0xc0,
                                          0x1f,0x00,
                                          0x04,0x00,
                                          0x1f,0x00,
                                          0x64,0xc0,
                                          0x84,0x20,
                                          0x04,0x00,
                                          0x04,0x00,
                                          0x04,0x00,/* STAR 11x13 = 2.0 */


                                          0x02,0x00,
                                          0x02,0x00,
                                          0x02,0x00,
                                          0x02,0x00,
                                          0x82,0x18,
                                          0x62,0x60,
                                          0x1b,0x80,
                                          0x06,0x00,
                                          0x1b,0x80,
                                          0x62,0x60,
                                          0x82,0x18,
                                          0x02,0x00,
                                          0x02,0x00,
                                          0x02,0x00,
                                          0x02,0x00,/* STAR 13x15 = 2.5 */

                                          0x02,0x00,
                                          0x02,0x00,
                                          0x02,0x00,
                                          0x02,0x00,
                                          0x82,0x08,
                                          0x62,0x30,
                                          0x12,0x40,
                                          0x0f,0x80,
                                          0x02,0x00,
                                          0x0f,0x80,
                                          0x12,0x40,
                                          0x62,0x30,
                                          0x82,0x08,
                                          0x02,0x00,
                                          0x02,0x00,
                                          0x02,0x00,
                                          0x02,0x00,/* STAR 13x17 = 3.0 */

                                          0x01,0x00,
                                          0x01,0x00,
                                          0x01,0x00,
                                          0x01,0x00,
                                          0x01,0x00,
                                          0xc1,0x06,
                                          0x21,0x18,
                                          0x19,0x20,
                                          0x07,0xc0,
                                          0x01,0x00,
                                          0x07,0xc0,
                                          0x19,0x20,
                                          0x21,0x18,
                                          0xc1,0x06,
                                          0x01,0x00,
                                          0x01,0x00,
                                          0x01,0x00,
                                          0x01,0x00,
                                          0x01,0x00,/* STAR 15x19 = 3.5 */

                                          0x00,0x80, 0x00,
                                          0x00,0x80, 0x00,
                                          0x00,0x80, 0x00,
                                          0x00,0x80, 0x00,
                                          0x00,0x80, 0x00,
                                          0x80,0x80, 0x80,
                                          0x60,0x83, 0x00,
                                          0x10,0x8c, 0x00,
                                          0x0c,0x90, 0x00,
                                          0x03,0xe0, 0x00,
                                          0x00,0x80, 0x00,
                                          0x03,0xe0, 0x00,
                                          0x0c,0x90, 0x00,
                                          0x10,0x8c, 0x00,
                                          0x60,0x83, 0x00,
                                          0x80,0x80, 0x80,
                                          0x00,0x80, 0x00,
                                          0x00,0x80, 0x00,
                                          0x00,0x80, 0x00,
                                          0x00,0x80, 0x00,
                                          0x00,0x80, 0x00,/* STAR 17x21 = 4.0 */

                                          0x00,0x40, 0x00,
                                          0x00,0x40, 0x00,
                                          0x00,0x40, 0x00,
                                          0x00,0x40, 0x00,
                                          0x00,0x40, 0x00,
                                          0x00,0x40, 0x00,
                                          0xc0,0x40, 0x60,
                                          0x30,0x41, 0x80,
                                          0x08,0x42, 0x00,
                                          0x06,0x4c, 0x00,
                                          0x01,0xf0, 0x00,
                                          0x00,0x40, 0x00,
                                          0x01,0xf0, 0x00,
                                          0x06,0x4c, 0x00,
                                          0x08,0x42, 0x00,
                                          0x30,0x41, 0x80,
                                          0xc0,0x40, 0x60,
                                          0x00,0x40, 0x00,
                                          0x00,0x40, 0x00,
                                          0x00,0x40, 0x00,
                                          0x00,0x40, 0x00,
                                          0x00,0x40, 0x00,
                                          0x00,0x40, 0x00,/* STAR 19x23 = 4.5 */

                                          0x00,0x20, 0x00,
                                          0x00,0x20, 0x00,
                                          0x00,0x20, 0x00,
                                          0x00,0x20, 0x00,
                                          0x00,0x20, 0x00,
                                          0x00,0x20, 0x00,
                                          0x80,0x20, 0x08,
                                          0x60,0x20, 0x30,
                                          0x18,0x20, 0xc0,
                                          0x04,0x21, 0x00,
                                          0x03,0x26, 0x00,
                                          0x00,0xf8, 0x00,
                                          0x00,0x20, 0x00,
                                          0x00,0xf8, 0x00,
                                          0x03,0x26, 0x00,
                                          0x04,0x21, 0x00,
                                          0x18,0x20, 0xc0,
                                          0x60,0x20, 0x30,
                                          0x80,0x20, 0x08,
                                          0x00,0x20, 0x00,
                                          0x00,0x20, 0x00,
                                          0x00,0x20, 0x00,
                                          0x00,0x20, 0x00,
                                          0x00,0x20, 0x00,
                                          0x00,0x20, 0x00,/* STAR 21x25 = 5.0 */

                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,
                                          0xc0,0x10, 0x06,
                                          0x30,0x10, 0x18,
                                          0x08,0x10, 0x60,
                                          0x06,0x10, 0x80,
                                          0x01,0x93, 0x00,
                                          0x00,0x7c, 0x00,
                                          0x00,0x10, 0x00,
                                          0x00,0x7c, 0x00,
                                          0x01,0x93, 0x00,
                                          0x06,0x10, 0x80,
                                          0x08,0x10, 0x60,
                                          0x30,0x10, 0x18,
                                          0xc0,0x10, 0x06,
                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,
                                          0x00,0x10, 0x00,/* STAR 23x27 = 5.5 */

                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x80,0x08, 0x00,0x80,
                                          0x60,0x08, 0x03,0x00,
                                          0x18,0x08, 0x0c,0x00,
                                          0x04,0x08, 0x30,0x00,
                                          0x03,0x08, 0x40,0x00,
                                          0x00,0xc9, 0x80,0x00,
                                          0x00,0x3e, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x3e, 0x00,0x00,
                                          0x00,0xc9, 0x80,0x00,
                                          0x03,0x08, 0x40,0x00,
                                          0x04,0x08, 0x30,0x00,
                                          0x18,0x08, 0x0c,0x00,
                                          0x60,0x08, 0x03,0x00,
                                          0x80,0x08, 0x00,0x80,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,/* STAR 25x29 = 6.0 */

                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00, 
                                          0x00,0x00, 0x80,0x00,
                                          0x30,0x00, 0x80,0x06,
                                          0x0c,0x00, 0x80,0x18,
                                          0x03,0x00, 0x80,0x60,
                                          0x00,0xc0, 0x81,0x80,
                                          0x00,0x30, 0x86,0x00,
                                          0x00,0x0c, 0x98,0x00,
                                          0x00,0x03, 0xe0,0x00,
                                          0x00,0x03, 0xe0,0x00,
                                          0x00,0x0c, 0x98,0x00,
                                          0x00,0x30, 0x86,0x00,
                                          0x00,0xc0, 0x81,0x80,
                                          0x03,0x00, 0x80,0x60,
                                          0x0c,0x00, 0x80,0x18,
                                          0x30,0x00, 0x80,0x06,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x80,0x00,
                                          0x00,0x00, 0x00,0x00,
                                          0x00,0x00, 0x00,0x00,/* STAR 32x32 = 6.5 */

                                          0x00, 0x00, 0x80, 0x00,
                                          0x00, 0x00, 0x80, 0x00,
                                          0x00, 0x00, 0x80, 0x00,
                                          0x00, 0x00, 0x80, 0x00,
                                          0x00, 0x00, 0x80, 0x00,
                                          0x00, 0x00, 0x80, 0x00,
                                          0x00, 0x00, 0x80, 0x00, 
                                          0x00, 0x00, 0x80, 0x00,
                                          0x10, 0x00, 0x80, 0x04,
                                          0x0c, 0x00, 0x80, 0x18,
                                          0x02, 0x00, 0x80, 0x20,
                                          0x01, 0x80, 0x80, 0xc0,
                                          0x00, 0x40, 0x81, 0x00,
                                          0x00, 0x30, 0x86, 0x00,
                                          0x00, 0x08, 0x88, 0x00,
                                          0x00, 0x06, 0xb0, 0x00,
                                          0x00, 0x01, 0xc0, 0x00,
                                          0x00, 0x06, 0xb0, 0x00,
                                          0x00, 0x08, 0x88, 0x00,
                                          0x00, 0x30, 0x86, 0x00,
                                          0x00, 0x40, 0x81, 0x00,
                                          0x01, 0x80, 0x80, 0xc0,
                                          0x02, 0x00, 0x80, 0x20,
                                          0x0c, 0x00, 0x80, 0x18,
                                          0x10, 0x00, 0x80, 0x04,
                                          0x00, 0x00, 0x80, 0x00,
                                          0x00, 0x00, 0x80, 0x00,
                                          0x00, 0x00, 0x80, 0x00,
                                          0x00, 0x00, 0x80, 0x00,
                                          0x00, 0x00, 0x80, 0x00,
                                          0x00, 0x00, 0x80, 0x00,
                                          0x00, 0x00, 0x80, 0x00,/* STAR 32x32 = 7.0 */


                                          0x82,
                                          0x44,
                                          0x28,
                                          0x10,
                                          0x28,
                                          0x44,
                                          0x82,/* CROSS 7x7 = 1.0 */

                                          0x80,0x80,
                                          0x41,0x00,
                                          0x22,0x00,
                                          0x14,0x00,
                                          0x08,0x00,
                                          0x14,0x00,
                                          0x22,0x00,
                                          0x41,0x00,
                                          0x80,0x80,/* CROSS 9x9 = 1.5 */

                                          0x80,0x20,
                                          0x40,0x40,
                                          0x20,0x80,
                                          0x11,0x00,
                                          0x0a,0x00,
                                          0x04,0x00,
                                          0x0a,0x00,
                                          0x11,0x00,
                                          0x20,0x80,
                                          0x40,0x40,
                                          0x80,0x20,/* CROSS 11x11 = 2.0 */

                                          0x80,0x08,
                                          0x40,0x10,
                                          0x20,0x20,
                                          0x10,0x40,
                                          0x08,0x80,
                                          0x05,0x00,
                                          0x02,0x00,
                                          0x05,0x00,
                                          0x08,0x80,
                                          0x10,0x40,
                                          0x20,0x20,
                                          0x40,0x10,
                                          0x80,0x08,/* CROSS 13x13 = 2.5 */

                                          0x80,0x02,
                                          0x40,0x04,
                                          0x20,0x08,
                                          0x10,0x10,
                                          0x08,0x20,
                                          0x04,0x40,
                                          0x02,0x80,
                                          0x01,0x00,
                                          0x02,0x80,
                                          0x04,0x40,
                                          0x08,0x20,
                                          0x10,0x10,
                                          0x20,0x08,
                                          0x40,0x04,
                                          0x80,0x02,/* CROSS 15x15 = 3.0 */

                                          0x80,0x00, 0x80,
                                          0x40,0x01, 0x00,
                                          0x20,0x02, 0x00,
                                          0x10,0x04, 0x00,
                                          0x08,0x08, 0x00,
                                          0x04,0x10, 0x00,
                                          0x02,0x20, 0x00,
                                          0x01,0x40, 0x00,
                                          0x00,0x80, 0x00,
                                          0x01,0x40, 0x00,
                                          0x02,0x20, 0x00,
                                          0x04,0x10, 0x00,
                                          0x08,0x08, 0x00,
                                          0x10,0x04, 0x00,
                                          0x20,0x02, 0x00,
                                          0x40,0x01, 0x00,
                                          0x80,0x00, 0x80,/* CROSS 17x17 = 3.5 */

                                          0x80,0x00, 0x20,
                                          0x40,0x00, 0x40,
                                          0x20,0x00, 0x80,
                                          0x10,0x01, 0x00,
                                          0x08,0x02, 0x00,
                                          0x04,0x04, 0x00,
                                          0x02,0x08, 0x00,
                                          0x01,0x10, 0x00,
                                          0x00,0xa0, 0x00,
                                          0x00,0x40, 0x00,
                                          0x00,0xa0, 0x00,
                                          0x01,0x10, 0x00,
                                          0x02,0x08, 0x00,
                                          0x04,0x04, 0x00,
                                          0x08,0x02, 0x00,
                                          0x10,0x01, 0x00,
                                          0x20,0x00, 0x80,
                                          0x40,0x00, 0x40,
                                          0x80,0x00, 0x20,/* CROSS 19x19 = 4.0 */

                                          0x80,0x00, 0x08,
                                          0x40,0x00, 0x10,
                                          0x20,0x00, 0x20,
                                          0x10,0x00, 0x40,
                                          0x08,0x00, 0x80,
                                          0x04,0x01, 0x00,
                                          0x02,0x02, 0x00,
                                          0x01,0x04, 0x00,
                                          0x00,0x88, 0x00,
                                          0x00,0x50, 0x00,
                                          0x00,0x20, 0x00,
                                          0x00,0x50, 0x00,
                                          0x00,0x88, 0x00,
                                          0x01,0x04, 0x00,
                                          0x02,0x02, 0x00,
                                          0x04,0x01, 0x00,
                                          0x08,0x00, 0x80,
                                          0x10,0x00, 0x40,
                                          0x20,0x00, 0x20,
                                          0x40,0x00, 0x10,
                                          0x80,0x00, 0x08,/* CROSS 21x21 = 4.5 */

                                          0x80,0x00, 0x02,
                                          0x40,0x00, 0x04,
                                          0x20,0x00, 0x08,
                                          0x10,0x00, 0x10,
                                          0x08,0x00, 0x20,
                                          0x04,0x00, 0x40,
                                          0x02,0x00, 0x80,
                                          0x01,0x01, 0x00,
                                          0x00,0x82, 0x00,
                                          0x00,0x44, 0x00,
                                          0x00,0x28, 0x00,
                                          0x00,0x10, 0x00,
                                          0x00,0x28, 0x00,
                                          0x00,0x44, 0x00,
                                          0x00,0x82, 0x00,
                                          0x01,0x01, 0x00,
                                          0x02,0x00, 0x80,
                                          0x04,0x00, 0x40,
                                          0x08,0x00, 0x20,
                                          0x10,0x00, 0x10,
                                          0x20,0x00, 0x08,
                                          0x40,0x00, 0x04,
                                          0x80,0x00, 0x02,/* CROSS 23x23 = 5.0 */

                                          0x80,0x00, 0x00,0x80,
                                          0x40,0x00, 0x01,0x00,
                                          0x20,0x00, 0x02,0x00,
                                          0x10,0x00, 0x04,0x00,
                                          0x08,0x00, 0x08,0x00,
                                          0x04,0x00, 0x10,0x00,
                                          0x02,0x00, 0x20,0x00,
                                          0x01,0x00, 0x40,0x00,
                                          0x00,0x80, 0x80,0x00,
                                          0x00,0x41, 0x00,0x00,
                                          0x00,0x22, 0x00,0x00,
                                          0x00,0x14, 0x00,0x00,
                                          0x00,0x08, 0x00,0x00,
                                          0x00,0x14, 0x00,0x00,
                                          0x00,0x22, 0x00,0x00,
                                          0x00,0x41, 0x00,0x00,
                                          0x00,0x80, 0x80,0x00,
                                          0x01,0x00, 0x40,0x00,
                                          0x02,0x00, 0x20,0x00,
                                          0x04,0x00, 0x10,0x00,
                                          0x08,0x00, 0x08,0x00,
                                          0x10,0x00, 0x04,0x00,
                                          0x20,0x00, 0x02,0x00,
                                          0x40,0x00, 0x01,0x00,
                                          0x80,0x00, 0x00,0x80,/* CROSS 25x25 = 5.5 */

                                          0x80,0x00, 0x00,0x20,
                                          0x40,0x00, 0x00,0x40,
                                          0x20,0x00, 0x00,0x80,
                                          0x10,0x00, 0x01,0x00,
                                          0x08,0x00, 0x02,0x00,
                                          0x04,0x00, 0x04,0x00,
                                          0x02,0x00, 0x08,0x00,
                                          0x01,0x00, 0x10,0x00,
                                          0x00,0x80, 0x20,0x00,
                                          0x00,0x40, 0x40,0x00,
                                          0x00,0x20, 0x80,0x00,
                                          0x00,0x11, 0x00,0x00,
                                          0x00,0x0a, 0x00,0x00,
                                          0x00,0x04, 0x00,0x00,
                                          0x00,0x0a, 0x00,0x00,
                                          0x00,0x11, 0x00,0x00,
                                          0x00,0x20, 0x80,0x00,
                                          0x00,0x40, 0x40,0x00,
                                          0x00,0x80, 0x20,0x00,
                                          0x01,0x00, 0x10,0x00,
                                          0x02,0x00, 0x08,0x00,
                                          0x04,0x00, 0x04,0x00,
                                          0x08,0x00, 0x02,0x00,
                                          0x10,0x00, 0x01,0x00,
                                          0x20,0x00, 0x00,0x80,
                                          0x40,0x00, 0x00,0x40,
                                          0x80,0x00, 0x00,0x20,/* CROSS 27x27 = 6.0 */

                                          0x00,0x00, 0x00,0x00,
                                          0x00,0x00, 0x00,0x00,
                                          0x20,0x00, 0x00,0x04,
                                          0x10,0x00, 0x00,0x08,
                                          0x08,0x00, 0x00,0x10,
                                          0x04,0x00, 0x00,0x20,
                                          0x02,0x00, 0x00,0x40,
                                          0x01,0x00, 0x00,0x80,
                                          0x00,0x80, 0x01,0x00,
                                          0x00,0x40, 0x02,0x00,
                                          0x00,0x20, 0x04,0x00,
                                          0x00,0x10, 0x08,0x00,
                                          0x00,0x08, 0x10,0x00,
                                          0x00,0x04, 0x20,0x00,
                                          0x00,0x02, 0x40,0x00,
                                          0x00,0x01, 0x80,0x00,
                                          0x00,0x01, 0x80,0x00,
                                          0x00,0x02, 0x40,0x00,
                                          0x00,0x04, 0x20,0x00,
                                          0x00,0x08, 0x10,0x00,
                                          0x00,0x10, 0x08,0x00,
                                          0x00,0x20, 0x04,0x00,
                                          0x00,0x40, 0x02,0x00,
                                          0x00,0x80, 0x01,0x00,
                                          0x01,0x00, 0x00, 0x80,
                                          0x02,0x00, 0x00,0x40, 
                                          0x04,0x00, 0x00,0x20,
                                          0x08,0x00, 0x00,0x10,
                                          0x10,0x00, 0x00,0x08,
                                          0x20,0x00, 0x00,0x04,
                                          0x00,0x00, 0x00,0x00,
                                          0x00,0x00, 0x00,0x00,/* CROSS 32x32 = 6.5 */

                                          0x00,0x00, 0x00,0x00,
                                          0x40,0x00, 0x00,0x02,
                                          0x20,0x00, 0x00,0x04,
                                          0x10,0x00, 0x00,0x08,
                                          0x08,0x00, 0x00,0x10,
                                          0x04,0x00, 0x00,0x20,
                                          0x02,0x00, 0x00,0x40,
                                          0x01,0x00, 0x00,0x80,
                                          0x00,0x80, 0x01,0x00,
                                          0x00,0x40, 0x02,0x00,
                                          0x00,0x20, 0x04,0x00,
                                          0x00,0x10, 0x08,0x00,
                                          0x00,0x08, 0x10,0x00,
                                          0x00,0x04, 0x20,0x00,
                                          0x00,0x02, 0x40,0x00,
                                          0x00,0x01, 0x80,0x00,
                                          0x00,0x01, 0x80,0x00,
                                          0x00,0x02, 0x40,0x00,
                                          0x00,0x04, 0x20,0x00,
                                          0x00,0x08, 0x10,0x00,
                                          0x00,0x10, 0x08,0x00,
                                          0x00,0x20, 0x04,0x00,
                                          0x00,0x40, 0x02,0x00, 
                                          0x00,0x80, 0x01,0x00,
                                          0x01,0x00, 0x00,0x80,
                                          0x02,0x00, 0x00,0x40,
                                          0x04,0x00, 0x00,0x20,
                                          0x08,0x00, 0x00,0x10,
                                          0x10,0x00, 0x00,0x08,
                                          0x20,0x00, 0x00,0x04,
                                          0x40,0x00, 0x00,0x02,
                                          0x00,0x00, 0x00,0x00,/* CROSS 32x32 = 7.0 */

                                          0x38,
                                          0x44,
                                          0x82,
                                          0x82,
                                          0x82,
                                          0x44,
                                          0x38,/* CIRC 7x7 = 1.0 */

                                          0x3c,0x00,
                                          0x42,0x00,
                                          0x81,0x00,
                                          0x81,0x00,
                                          0x81,0x00,
                                          0x81,0x00,
                                          0x42,0x00,
                                          0x3c,0x00,
                                          0x00,0x00,/*CIRC 9x9 = 1.5 */

                                          0x3e, 0x00,
                                          0x41, 0x00,
                                          0x81, 0x80,
                                          0x80,0x80,
                                          0x80,0x80,
                                          0x80,0x80,
                                          0x81, 0x80,
                                          0x41, 0x00,
                                          0x3e,0x00,/* CIRC 9x9 = 2.0 */

                                          0x1f,0x00,
                                          0x20,0x80,
                                          0x40,0x40,
                                          0x80,0x20,
                                          0x80,0x20,
                                          0x80,0x20,
                                          0x80,0x20,
                                          0x80,0x20,
                                          0x40,0x40,
                                          0x20,0x80,
                                          0x1f,0x00,/* CIRC 11x11 = 2.5 */

                                          0x0f,0x80,
                                          0x10,0x40,
                                          0x20,0x20,
                                          0x40,0x10,
                                          0x80,0x08,
                                          0x80,0x08,
                                          0x80,0x08,
                                          0x80,0x08,
                                          0x80,0x08,
                                          0x40,0x10,
                                          0x20,0x20,
                                          0x10,0x40,
                                          0x0f,0x80,/* CIRC 13x13 = 3.0 */

                                          0x07,0xc0,
                                          0x18,0x30,
                                          0x20,0x08,
                                          0x40,0x04,
                                          0x40,0x04,
                                          0x80,0x02,
                                          0x80,0x02,
                                          0x80,0x02,
                                          0x80,0x02,
                                          0x80,0x02,
                                          0x40,0x04,
                                          0x40,0x04,
                                          0x20,0x08,
                                          0x18,0x30,
                                          0x07,0xc0,/* CIRC 15x15 = 3.5 */

                                          0x03,0xe0, 0x00,
                                          0x0c,0x18, 0x00,
                                          0x10,0x04, 0x00,
                                          0x20,0x02, 0x00,
                                          0x40,0x01, 0x00,
                                          0x40,0x01, 0x00,
                                          0x80,0x00, 0x80,
                                          0x80,0x00, 0x80,
                                          0x80,0x00, 0x80,
                                          0x80,0x00, 0x80,
                                          0x80,0x00, 0x80,
                                          0x40,0x01, 0x00,
                                          0x40,0x01, 0x00,
                                          0x20,0x02, 0x00,
                                          0x10,0x04, 0x00,
                                          0x0c,0x18, 0x00,
                                          0x03,0xe0, 0x00,/* CIRC 17x17 = 4.0 */

                                          0x03,0xf8, 0x00,
                                          0x0e,0x0e, 0x00,
                                          0x18,0x03, 0x00,
                                          0x20,0x00, 0x80,
                                          0x60,0x00, 0xc0,
                                          0x40,0x00, 0x40,
                                          0xc0,0x00, 0x60,
                                          0x80,0x00, 0x20,
                                          0x80,0x00, 0x20,
                                          0x80,0x00, 0x20,
                                          0x80,0x00, 0x20,
                                          0x80,0x00, 0x20,
                                          0xc0,0x00, 0x60,
                                          0x40,0x00, 0x40,
                                          0x60,0x00, 0xc0,
                                          0x20,0x00, 0x80,
                                          0x18,0x03, 0x00,
                                          0x0e,0x0e, 0x00,
                                          0x03,0xf8, 0x00,/* CIRC 19x19 = 4.5 */


                                          0x01,0xfc, 0x00,
                                          0x06,0x03, 0x00,
                                          0x08,0x00, 0x80,
                                          0x10,0x00, 0x40,
                                          0x20,0x00, 0x20,
                                          0x40,0x00, 0x10,
                                          0x40,0x00, 0x10,
                                          0x80,0x00, 0x08,
                                          0x80,0x00, 0x08,
                                          0x80,0x00, 0x08,
                                          0x80,0x00, 0x08,
                                          0x80,0x00, 0x08,
                                          0x80,0x00, 0x08,
                                          0x80,0x00, 0x08,
                                          0x40,0x00, 0x10,
                                          0x40,0x00, 0x10,
                                          0x20,0x00, 0x20,
                                          0x10,0x00, 0x40,
                                          0x08,0x00, 0x80,
                                          0x06,0x03, 0x00,
                                          0x01,0xfc, 0x00,/* CIRC 21x21 = 5.0 */

                                          0x00,0xfe, 0x00,
                                          0x03,0x01, 0x80,
                                          0x0c,0x00, 0x60,
                                          0x18,0x00, 0x30,
                                          0x30,0x00, 0x18,
                                          0x20,0x00, 0x08,
                                          0x40,0x00, 0x04,
                                          0x40,0x00, 0x04,
                                          0x80,0x00, 0x02,
                                          0x80,0x00, 0x02,
                                          0x80,0x00, 0x02,
                                          0x80,0x00, 0x02,
                                          0x80,0x00, 0x02,
                                          0x80,0x00, 0x02,
                                          0x80,0x00, 0x02,
                                          0x40,0x00, 0x04,
                                          0x40,0x00, 0x04,
                                          0x20,0x00, 0x08,
                                          0x30,0x00, 0x18,
                                          0x18,0x00, 0x30,
                                          0x0c,0x00, 0x60,
                                          0x03,0x01, 0x80,
                                          0x00,0xfe, 0x00,/* CIRC 23x23 = 5.5 */

                                          0x00,0x7f, 0x00,0x00,
                                          0x01,0x80, 0xc0,0x00,
                                          0x06,0x00, 0x30,0x00,
                                          0x08,0x00, 0x08,0x00,
                                          0x10,0x00, 0x04,0x00,
                                          0x20,0x00, 0x02,0x00,
                                          0x20,0x00, 0x02,0x00,
                                          0x40,0x00, 0x01,0x00,
                                          0x40,0x00, 0x01,0x00,
                                          0x80,0x00, 0x00,0x80,
                                          0x80,0x00, 0x00,0x80,
                                          0x80,0x00, 0x00,0x80,
                                          0x80,0x00, 0x00,0x80,
                                          0x80,0x00, 0x00,0x80,
                                          0x80,0x00, 0x00,0x80,
                                          0x80,0x00, 0x00,0x80,
                                          0x40,0x00, 0x01,0x00,
                                          0x40,0x00, 0x01,0x00,
                                          0x20,0x00, 0x02,0x00,
                                          0x20,0x00, 0x02,0x00,
                                          0x10,0x00, 0x04,0x00,
                                          0x08,0x00, 0x08,0x00,
                                          0x06,0x00, 0x30,0x00,
                                          0x01,0x80, 0xc0,0x00,
                                          0x00,0x7f, 0x00,0x00,/* CIRC 25x25 = 6.0 */

                                          0x00,0x3f, 0x80,0x00,
                                          0x01,0xc0, 0x70,0x00,
                                          0x03,0x00, 0x18,0x00,
                                          0x0c,0x00, 0x06,0x00,
                                          0x18,0x00, 0x03,0x00,
                                          0x10,0x00, 0x01,0x00,
                                          0x20,0x00, 0x00,0x80,
                                          0x60,0x00, 0x00,0xc0,
                                          0x40,0x00, 0x00,0x40,
                                          0x40,0x00, 0x00,0x40,
                                          0x80,0x00, 0x00,0x20,
                                          0x80,0x00, 0x00,0x20,
                                          0x80,0x00, 0x00,0x20,
                                          0x80,0x00, 0x00,0x20,
                                          0x80,0x00, 0x00,0x20,
                                          0x80,0x00, 0x00,0x20,
                                          0x80,0x00, 0x00,0x20,
                                          0x40,0x00, 0x00,0x40,
                                          0x40,0x00, 0x00,0x40,
                                          0x60,0x00, 0x00,0xc0,
                                          0x20,0x00, 0x00,0x80,
                                          0x10,0x00, 0x01,0x00,
                                          0x18,0x00, 0x03,0x00,
                                          0x0c,0x00, 0x06,0x00,
                                          0x03,0x00, 0x18,0x00,
                                          0x01,0xc0, 0x70,0x00,
                                          0x00,0x3f, 0x80,0x00,/* CIRC 27x27 = 6.5 */

                                          0x00,0x1f, 0xc0,0x00,
                                          0x00,0xe0, 0x38,0x00,
                                          0x01,0x00, 0x04,0x00,
                                          0x06,0x00, 0x03,0x00,
                                          0x08,0x00, 0x00,0x80,
                                          0x10,0x00, 0x00,0x40,
                                          0x10,0x00, 0x00,0x40,
                                          0x20,0x00, 0x00,0x20,
                                          0x40,0x00, 0x00,0x10,
                                          0x40,0x00, 0x00,0x10,
                                          0x40,0x00, 0x00,0x10,
                                          0x80,0x00, 0x00,0x08,
                                          0x80,0x00, 0x00,0x08,
                                          0x80,0x00, 0x00,0x08,
                                          0x80,0x00, 0x00,0x08,
                                          0x80,0x00, 0x00,0x08,
                                          0x80,0x00, 0x00,0x08,
                                          0x80,0x00, 0x00,0x08,
                                          0x40,0x00, 0x00,0x10,
                                          0x40,0x00, 0x00,0x10,
                                          0x40,0x00, 0x00,0x10,
                                          0x20,0x00, 0x00,0x20,
                                          0x10,0x00, 0x00,0x40,
                                          0x10,0x00, 0x00,0x40,
                                          0x08,0x00, 0x00,0x80,
                                          0x06,0x00, 0x03,0x00,
                                          0x01,0x00, 0x04,0x00,
                                          0x00,0xe0, 0x38,0x00,
                                          0x00,0x1f, 0xc0,0x00, /* CIRC 29x29 = 7.0 */

                                          0x00,
                                          0x18,
                                          0x18,
                                          0x00,
                                          0x00,/* DOT 5x5 = 1.0 */

                                          0x70,
                                          0xf8,
                                          0xf8,
                                          0xf8,
                                          0x70,/* DOT 5x5 = 1.5 = 1.0 */

                                          0x38,
                                          0x7c,
                                          0xfe,
                                          0xfe,
                                          0xfe,
                                          0x7c,
                                          0x38,/* DOT 7x7 = 2.0 */

                                          0x38,
                                          0x7c,
                                          0xfe,
                                          0xfe,
                                          0xfe,
                                          0x7c,
                                          0x38,/* DOT 7x7 = 2.5 =  2.0 */

                                          0x00,0x00,
                                          0x3c,0x00,
                                          0x7e,0x00,
                                          0xff,0x00,
                                          0xff,0x00,
                                          0xff,0x00,
                                          0x7e,0x00,
                                          0x3c,0x00,
                                          0x00,0x00,/* DOT 9x9 = 3.0 */

                                          0x00,0x00,
                                          0x3c,0x00,
                                          0x7e,0x00,
                                          0xff,0x00,
                                          0xff,0x00,
                                          0xff,0x00,
                                          0x7e,0x00,
                                          0x3c,0x00,
                                          0x00,0x00,/* DOT 9x9 = 3.5 = 3.0 */

                                          0x1c,0x00,
                                          0x7f,0x00,
                                          0x7f,0x00,
                                          0xff,0x80,
                                          0xff,0x80,
                                          0xff,0x80,
                                          0x7f,0x00,
                                          0x7f,0x00,
                                          0x1c,0x00,/* DOT 9x9 = 4.0 */

                                          0x1c,0x00,
                                          0x7f,0x00,
                                          0x7f,0x00,
                                          0xff,0x80,
                                          0xff,0x80,
                                          0xff,0x80,
                                          0x7f,0x00,
                                          0x7f,0x00,
                                          0x1c,0x00,/* DOT 9x9 = 4.5 = 4.0 */

                                          0x3e,0x00,
                                          0x7f,0x00,
                                          0xff,0x80,
                                          0xff,0x80,
                                          0xff,0x80,
                                          0xff,0x80,
                                          0xff,0x80,
                                          0x7f,0x00,
                                          0x3e,0x00,/* DOT 9x9 = 5.0 */

                                          0x3e,0x00,
                                          0x7f,0x00,
                                          0xff,0x80,
                                          0xff,0x80,
                                          0xff,0x80,
                                          0xff,0x80,
                                          0xff,0x80,
                                          0x7f,0x00,
                                          0x3e,0x00,/* DOT 9x9 = 5.5 = 5.0 */

                                          0x1e, 0x00,
                                          0x3f, 0x80,
                                          0xff, 0xc0,
                                          0xff, 0xe1,
                                          0xff, 0xe1,
                                          0xff, 0xf1,
                                          0xff, 0xe1,
                                          0xff, 0xe1,
                                          0xff, 0xc0,
                                          0x3f, 0x80,
                                          0x1e, 0x00,/* DOT 11x11 = 6.0 */

                                          0x1e, 0x00,
                                          0x3f, 0x80,
                                          0xff, 0xc0,
                                          0xff, 0xe1,
                                          0xff, 0xe1,
                                          0xff, 0xf1,
                                          0xff, 0xe1,
                                          0xff, 0xe1,
                                          0xff, 0xc0,
                                          0x3f, 0x80,
                                          0x1e, 0x00,/* DOT 11x11 = 6.5 = 6.0 */

                                          0x1e, 0x00,
                                          0x3f, 0x80,
                                          0xff, 0xc0,
                                          0xff, 0xe1,
                                          0xff, 0xe1,
                                          0xff, 0xf1,
                                          0xff, 0xe1,
                                          0xff, 0xe1,
                                          0xff, 0xc0,
                                          0x3f, 0x80,
                                          0x1e, 0x00 /* DOT 11x11 = 7.0 =  6.0 */
                                 };

    glPixelStorei(GL_UNPACK_ALIGNMENT, 1);

        markerBase = glGenLists (80);

   for( i = 0; i < TEL_NO_OF_SIZES*TEL_NB_OF_MARKERS; i++ )
   {
#ifdef OCC7667
      GLsizei w, h, size, j;
#endif


      k1 = i / TEL_NO_OF_SIZES;
      k2 = i % TEL_NO_OF_SIZES;
      offset = array[k1][k2].offset;

#ifdef OCC7667
      w = ( GLsizei ) array[k1][k2].width;
      h = ( GLsizei ) array[k1][k2].height;
#endif

      glNewList( (GLuint) array[k1][k2].str[0]+markerBase, GL_COMPILE);

#ifdef OCC7667
      glBitmap( w, h, (float)(array[k1][k2].width) / ( float )2.0,
                      (float)(array[k1][k2].height) / ( float )2.0,
                      ( float )30.0,  ( float )30.0, (const GLubyte *) &raster[offset]);

      glPassThrough( GL2PS_MARKER );
      glPassThrough( ( GLfloat ) array[k1][k2].width );
      glPassThrough( ( GLfloat ) array[k1][k2].height );
      glPassThrough( ( GLfloat ) 30.0 );
      glPassThrough( ( GLfloat ) 30.0 );

      size = h + h * ( ( w-1 ) / 8 );
      for( j=0; j<size; j++ )
          glPassThrough( raster[offset+j] );

#else
      glBitmap( (GLsizei) array[k1][k2].width, (GLsizei) array[k1][k2].height,
                    (float)(array[k1][k2].width) / ( float )2.0,
                    (float)(array[k1][k2].height) / ( float )2.0,
                  ( float )30.0,  ( float )30.0, (const GLubyte *) &raster[offset]);
#endif

      glEndList();

   }
}

/*----------------------------------------------------------------------*/

char *
TelGetStringForPM( Tint mrkr_type, Tfloat val )
{
    Tint   id;
    Tfloat index;

    if( val < TEL_PM_START_SIZE )
        val = ( float )1.0;
    if( val > TEL_PM_END_SIZE )
        val = ( float )7.0;

    index = ( float )(TEL_NO_OF_SIZES-1) * (val - ( float )TEL_PM_START_SIZE )
            / ( float )(TEL_PM_END_SIZE - TEL_PM_START_SIZE);
    id = (Tint)(index + 0.5 );

    return array[mrkr_type][id].str;
}
/*----------------------------------------------------------------------*/
