// File:	StepToGeom_MakeBoundedCurve.cxx
// Created:	Fri Jul  2 12:34:13 1993
// Author:	Martine LANGLOIS
//		<mla@mastox>
//:n6 abv 15.02.99: S4132: adding translation of polyline
//:p0 abv 19.02.99: management of 'done' flag improved; trimmed_curve treated

#include <StepToGeom_MakeBoundedCurve.ixx>
#include <StdFail_NotDone.hxx>

#include <StepGeom_BSplineCurveWithKnotsAndRationalBSplineCurve.hxx>
#include <StepGeom_BSplineCurveWithKnots.hxx>
#include <StepGeom_BezierCurve.hxx>
#include <StepGeom_UniformCurve.hxx>
#include <StepGeom_UniformCurveAndRationalBSplineCurve.hxx>
#include <StepGeom_QuasiUniformCurve.hxx>
#include <StepGeom_QuasiUniformCurveAndRationalBSplineCurve.hxx>
#include <StepGeom_Polyline.hxx>
#include <StepGeom_TrimmedCurve.hxx>
#include <StepGeom_KnotType.hxx>
#include <StepToGeom_MakeBSplineCurve.hxx>
#include <StepGeom_Polyline.hxx>
#include <StepToGeom_MakePolyline.hxx>
#include <StepToGeom_MakeTrimmedCurve.hxx>

#include <TColStd_HArray1OfInteger.hxx>
#include <TColStd_HArray1OfReal.hxx>

//=============================================================================
// Creation d' une BoundedCurve de Geom a partir d' une BoundedCurve de Step
//=============================================================================

StepToGeom_MakeBoundedCurve::StepToGeom_MakeBoundedCurve ( const Handle(StepGeom_BoundedCurve)& C)
{
  done = Standard_False;

  Handle(StepGeom_BSplineCurveWithKnots) BSPL = new StepGeom_BSplineCurveWithKnots;
  Handle(StepGeom_BSplineCurveWithKnotsAndRationalBSplineCurve) RBSPL = 
    new StepGeom_BSplineCurveWithKnotsAndRationalBSplineCurve;

  if (C->IsKind(STANDARD_TYPE(StepGeom_BSplineCurveWithKnotsAndRationalBSplineCurve))) {
    Handle(StepGeom_BSplineCurveWithKnotsAndRationalBSplineCurve)
      Bspli = Handle(StepGeom_BSplineCurveWithKnotsAndRationalBSplineCurve)::DownCast(C);
    StepToGeom_MakeBSplineCurve MkCurve(Bspli);
    if ( MkCurve.IsDone() ) theBoundedCurve = MkCurve.Value();
  }
  else if (C->IsKind(STANDARD_TYPE(StepGeom_BSplineCurveWithKnots))) {
    Handle(StepGeom_BSplineCurveWithKnots)
      Bspli = Handle(StepGeom_BSplineCurveWithKnots)::DownCast(C);
    StepToGeom_MakeBSplineCurve MkCurve(Bspli);      
    if ( MkCurve.IsDone() ) theBoundedCurve = MkCurve.Value();
  }
  else if (C->IsKind(STANDARD_TYPE(StepGeom_TrimmedCurve))) {
    Handle(StepGeom_TrimmedCurve) L = Handle(StepGeom_TrimmedCurve)::DownCast(C);
    StepToGeom_MakeTrimmedCurve MkTrimmed(L); 
    if ( MkTrimmed.IsDone() ) theBoundedCurve = MkTrimmed.Value();
  }
  // STEP BezierCurve, UniformCurve and QuasiUniformCurve are transformed into
  // STEP BSplineCurve before being mapped onto CAS.CADE/SF
  else if (C->IsKind(STANDARD_TYPE(StepGeom_BezierCurve))) {
    Handle(StepGeom_BezierCurve) BzC = Handle(StepGeom_BezierCurve)::DownCast(C);
    BSPL->SetDegree(BzC->Degree());
    BSPL->SetControlPointsList(BzC->ControlPointsList());
    BSPL->SetCurveForm(BzC->CurveForm());
    BSPL->SetClosedCurve(BzC->ClosedCurve());
    BSPL->SetSelfIntersect(BzC->SelfIntersect());
    // Compute Knots and KnotsMultiplicity
    Handle(TColStd_HArray1OfInteger) Kmult = new TColStd_HArray1OfInteger(1,2);
    Handle(TColStd_HArray1OfReal) Knots = new TColStd_HArray1OfReal(1,2);
    Kmult->SetValue(1, BzC->Degree() + 1);
    Kmult->SetValue(2, BzC->Degree() + 1);
    Knots->SetValue(1, 0.);
    Knots->SetValue(2, 1.);
    BSPL->SetKnotMultiplicities(Kmult);
    BSPL->SetKnots(Knots);
    StepToGeom_MakeBSplineCurve MkCurve(BSPL);
    if ( MkCurve.IsDone() ) theBoundedCurve = MkCurve.Value();
  }
  else if (C->IsKind(STANDARD_TYPE(StepGeom_UniformCurve))) {
#ifdef DEBUG
    cout << "Warning : converting UniformCurve onto BSplineCurveWithKnots" << endl;
#endif
    Handle(StepGeom_UniformCurve) UC = Handle(StepGeom_UniformCurve)::DownCast(C);
    BSPL->SetDegree(UC->Degree());
    BSPL->SetControlPointsList(UC->ControlPointsList());
    BSPL->SetCurveForm(UC->CurveForm());
    BSPL->SetClosedCurve(UC->ClosedCurve());
    BSPL->SetSelfIntersect(UC->SelfIntersect());
    // Compute Knots and KnotsMultiplicity
    Standard_Integer nbK = BSPL->NbControlPointsList() + BSPL->Degree() + 1;
    Handle(TColStd_HArray1OfInteger) Kmult = new TColStd_HArray1OfInteger(1,nbK);
    Handle(TColStd_HArray1OfReal) Knots = new TColStd_HArray1OfReal(1,nbK);
    for (Standard_Integer iUC = 1 ; iUC <= nbK ; iUC ++) {
      Kmult->SetValue(iUC, 1);
      Knots->SetValue(iUC, iUC - 1.);
    }
    BSPL->SetKnotMultiplicities(Kmult);
    BSPL->SetKnots(Knots);
    StepToGeom_MakeBSplineCurve MkCurve(BSPL);
    if ( MkCurve.IsDone() ) theBoundedCurve = MkCurve.Value();
  }
  else if (C->IsKind(STANDARD_TYPE(StepGeom_QuasiUniformCurve))) {
#ifdef DEBUG
    cout << "Warning : converting QuasiUniformCurve onto BSplineCurveWithKnots" << endl;
#endif
    Handle(StepGeom_QuasiUniformCurve) QUC = 
      Handle(StepGeom_QuasiUniformCurve)::DownCast(C);
    BSPL->SetDegree(QUC->Degree());
    BSPL->SetControlPointsList(QUC->ControlPointsList());
    BSPL->SetCurveForm(QUC->CurveForm());
    BSPL->SetClosedCurve(QUC->ClosedCurve());
    BSPL->SetSelfIntersect(QUC->SelfIntersect());
    // Compute Knots and KnotsMultiplicity
    Standard_Integer nbK = BSPL->NbControlPointsList() - BSPL->Degree() + 1;
    Handle(TColStd_HArray1OfInteger) Kmult = new TColStd_HArray1OfInteger(1,nbK);
    Handle(TColStd_HArray1OfReal) Knots = new TColStd_HArray1OfReal(1,nbK);
    for (Standard_Integer iQUC = 1 ; iQUC <= nbK ; iQUC ++) {
      Kmult->SetValue(iQUC, 1);
      Knots->SetValue(iQUC, iQUC - 1.);
    }
    Kmult->SetValue(1, BSPL->Degree() + 1);
    Kmult->SetValue(nbK, BSPL->Degree() + 1);
    BSPL->SetKnotMultiplicities(Kmult);
    BSPL->SetKnots(Knots);
    StepToGeom_MakeBSplineCurve MkCurve(BSPL);
    if ( MkCurve.IsDone() ) theBoundedCurve = MkCurve.Value();
  }
  else if (C->IsKind(STANDARD_TYPE(StepGeom_UniformCurveAndRationalBSplineCurve))) {
#ifdef DEBUG
    cout << "Warning : converting Rational UniformCurve onto BSplineCurveWithKnots" << endl;
#endif
    Handle(StepGeom_UniformCurveAndRationalBSplineCurve) RUC = 
      Handle(StepGeom_UniformCurveAndRationalBSplineCurve)::DownCast(C);
    // Compute Knots and KnotsMultiplicity
    Standard_Integer nbK = RUC->NbControlPointsList() + RUC->Degree() + 1;
    Handle(TColStd_HArray1OfInteger) Kmult = new TColStd_HArray1OfInteger(1,nbK);
    Handle(TColStd_HArray1OfReal) Knots = new TColStd_HArray1OfReal(1,nbK);
    for (Standard_Integer iUC = 1 ; iUC <= nbK ; iUC ++) {
      Kmult->SetValue(iUC, 1);
      Knots->SetValue(iUC, iUC - 1.);
    }
    // Initialize the BSplineCurveWithKnotsAndRationalBSplineCurve
    StepGeom_KnotType TypeKnots = StepGeom_ktUnspecified;
    RBSPL->Init(RUC->Name(), RUC->Degree(), RUC->ControlPointsList(), RUC->CurveForm(),
		RUC->ClosedCurve(), RUC->SelfIntersect(), Kmult, Knots, TypeKnots,
		RUC->WeightsData());
    StepToGeom_MakeBSplineCurve MkCurve(RBSPL);
    if ( MkCurve.IsDone() ) theBoundedCurve = MkCurve.Value();
  }
  else if (C->IsKind(STANDARD_TYPE(StepGeom_QuasiUniformCurveAndRationalBSplineCurve))) {
#ifdef DEBUG
    cout << "Warning : converting Rational QuasiUniformCurve onto BSplineCurveWithKnots" << endl;
#endif
    Handle(StepGeom_QuasiUniformCurveAndRationalBSplineCurve) RQUC = 
      Handle(StepGeom_QuasiUniformCurveAndRationalBSplineCurve)::DownCast(C);
    // Compute Knots and KnotsMultiplicity
    Standard_Integer nbK = RQUC->NbControlPointsList() - RQUC->Degree() + 1;
    Handle(TColStd_HArray1OfInteger) Kmult = new TColStd_HArray1OfInteger(1,nbK);
    Handle(TColStd_HArray1OfReal) Knots = new TColStd_HArray1OfReal(1,nbK);
    for (Standard_Integer iRQUC = 1 ; iRQUC <= nbK ; iRQUC ++) {
      Kmult->SetValue(iRQUC, 1);
      Knots->SetValue(iRQUC, iRQUC - 1.);
    }
    Kmult->SetValue(1, RQUC->Degree() + 1);
    Kmult->SetValue(nbK, RQUC->Degree() + 1);
    // Initialize the BSplineCurveWithKnotsAndRationalBSplineCurve
    StepGeom_KnotType TypeKnots = StepGeom_ktUnspecified;
    RBSPL->Init(RQUC->Name(), RQUC->Degree(), RQUC->ControlPointsList(), RQUC->CurveForm(),
		RQUC->ClosedCurve(), RQUC->SelfIntersect(), Kmult, Knots, TypeKnots,
		RQUC->WeightsData());
    StepToGeom_MakeBSplineCurve MkCurve(RBSPL);
    if ( MkCurve.IsDone() ) theBoundedCurve = MkCurve.Value();
  }
  else if (C->IsKind(STANDARD_TYPE(StepGeom_Polyline))) { //:n6 abv 15 Feb 99
    Handle(StepGeom_Polyline) PL = Handle(StepGeom_Polyline)::DownCast ( C );
    StepToGeom_MakePolyline MkPL ( PL );
    if ( MkPL.IsDone() ) theBoundedCurve = MkPL.Value();
  }
  done = ! theBoundedCurve.IsNull();
}

//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom_BoundedCurve) &
      StepToGeom_MakeBoundedCurve::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theBoundedCurve;
}
