#ifndef _StdLSchema_PDF_Reference_HeaderFile_
#include <StdLSchema_PDF_Reference.hxx>
#endif
#ifndef _PDF_Reference_HeaderFile_
#include <PDF_Reference.hxx>
#endif
#include <StdLSchema_PDF_Reference.ixx>
#ifndef _Storage_Schema_HeaderFile_
#include <Storage_Schema.hxx>
#endif
#ifndef _Storage_stCONSTclCOM_HeaderFile_
#include <Storage_stCONSTclCOM.hxx>
#endif

Handle_Standard_Type& StdLSchema_PDF_Reference_Type_()
{

  static Handle_Standard_Type tSchema = STANDARD_TYPE(StdLSchema_PDF_Reference); 
  static Handle_Standard_Type bSchema = STANDARD_TYPE(Storage_CallBack);

  static Handle_Standard_Transient _Ancestors[]= {tSchema,bSchema,NULL};
  static Handle_Standard_Type _aType = new Standard_Type("StdLSchema_PDF_Reference",
			                                 sizeof(StdLSchema_PDF_Reference),
			                                 1,
			                                 (Standard_Address)_Ancestors,
			                                 (Standard_Address)NULL);

  return _aType;
}

const Handle(StdLSchema_PDF_Reference) Handle(StdLSchema_PDF_Reference)::DownCast(const Handle(Storage_CallBack)& AnObject) {
  Handle(StdLSchema_PDF_Reference) _anOtherObject;

  if (!AnObject.IsNull()) {
     if (AnObject->IsKind(STANDARD_TYPE(StdLSchema_PDF_Reference))) {
       _anOtherObject = Handle(StdLSchema_PDF_Reference)((Handle(StdLSchema_PDF_Reference)&)AnObject);
     }
  }

  return _anOtherObject ;
}

Standard_Boolean StdLSchema_PDF_Reference::IsKind(const Handle(Standard_Type)& AType) const { 
  return (STANDARD_TYPE(StdLSchema_PDF_Reference) == AType || Storage_CallBack::IsKind(AType)); 
}

const Handle(Standard_Type)& StdLSchema_PDF_Reference::DynamicType() const { 
  return STANDARD_TYPE(StdLSchema_PDF_Reference) ; 
}
Handle(Standard_Persistent) StdLSchema_PDF_Reference::New() const
{
 return new PDF_Reference(Storage_stCONSTclCOM());
}

void StdLSchema_PDF_Reference::SAdd(const Handle(PDF_Reference)& p, const Handle(Storage_Schema)& theSchema)
{
  if (!p.IsNull()) {
    if (theSchema->AddPersistent(p,"PDF_Reference")) {
         theSchema->PersistentToAdd(p->_CSFDB_GetPDF_ReferencemyValue());

    }
  }
}

void StdLSchema_PDF_Reference::Add(const Handle(Standard_Persistent)& p, const Handle(Storage_Schema)& theSchema) const {
  StdLSchema_PDF_Reference::SAdd((Handle(PDF_Reference)&)p,theSchema);
}

void StdLSchema_PDF_Reference::SWrite(const Handle(Standard_Persistent)& p, Storage_BaseDriver& f, const Handle(Storage_Schema)& theSchema)
{ 
  if (!p.IsNull()) {
    Handle(PDF_Reference) &pp = (Handle(PDF_Reference)&)p;
    theSchema->WritePersistentObjectHeader(p,f);
    
    f.BeginWritePersistentObjectData();
  theSchema->WritePersistentReference(pp->_CSFDB_GetPDF_ReferencemyValue(),f);

    f.EndWritePersistentObjectData();
  }
}

void StdLSchema_PDF_Reference::Write(const Handle(Standard_Persistent)& p, Storage_BaseDriver& f, const Handle(Storage_Schema)& theSchema) const
{ 
 StdLSchema_PDF_Reference::SWrite(p,f,theSchema);
}
void StdLSchema_PDF_Reference::SRead(const Handle(Standard_Persistent)& p, Storage_BaseDriver& f, const Handle(Storage_Schema)& theSchema)
{ 
  if (!p.IsNull()) {
    Handle(PDF_Reference) &pp = (Handle(PDF_Reference)&)p;

    theSchema->ReadPersistentObjectHeader(f);
    f.BeginReadPersistentObjectData();


    Handle(PCollection_HAsciiString) PDF_ReferencemyValue;

    theSchema->ReadPersistentReference(PDF_ReferencemyValue,f);
    pp->_CSFDB_SetPDF_ReferencemyValue(PDF_ReferencemyValue);

    f.EndReadPersistentObjectData();
  }
}

void StdLSchema_PDF_Reference::Read(const Handle(Standard_Persistent)& p, Storage_BaseDriver& f, const Handle(Storage_Schema)& theSchema) const
{ 
 StdLSchema_PDF_Reference::SRead(p,f,theSchema);
}
