// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _AlienImage_SunRFAlienData_HeaderFile
#define _AlienImage_SunRFAlienData_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_AlienImage_SunRFAlienData_HeaderFile
#include <Handle_AlienImage_SunRFAlienData.hxx>
#endif

#ifndef _AlienImage_SUNRFFileHeader_HeaderFile
#include <AlienImage_SUNRFFileHeader.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _AlienImage_AlienImageData_HeaderFile
#include <AlienImage_AlienImageData.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _AlienImage_SUNRFFormat_HeaderFile
#include <AlienImage_SUNRFFormat.hxx>
#endif
#ifndef _Handle_Image_Image_HeaderFile
#include <Handle_Image_Image.hxx>
#endif
#ifndef _Handle_Image_PseudoColorImage_HeaderFile
#include <Handle_Image_PseudoColorImage.hxx>
#endif
#ifndef _Handle_Image_ColorImage_HeaderFile
#include <Handle_Image_ColorImage.hxx>
#endif
class Standard_OutOfRange;
class Standard_TypeMismatch;
class OSD_File;
class Image_Image;
class Image_PseudoColorImage;
class Image_ColorImage;


//! This class defines a SUN Raster File .rs Alien image. <br>
class AlienImage_SunRFAlienData : public AlienImage_AlienImageData {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT AlienImage_SunRFAlienData();

//! Frees memory allocated by SunRFAlienData and <br>
//!          reset Object fields. <br>
Standard_EXPORT   void Clear() ;
~AlienImage_SunRFAlienData()
{
  Clear();
}


//! Frees memory allocated by SunRFAlienData <br>
Standard_EXPORT   void FreeData() ;

//! Read content of a  SunRFAlienData object from a file . <br>
//!          Returns True if file is a Sun Raster file . <br>
Standard_EXPORT   Standard_Boolean Read(OSD_File& afile) ;

//! Write content of a  SunRFAlienData object to a file . <br>
Standard_EXPORT   Standard_Boolean Write(OSD_File& afile) const;

//! Set SUN Raster File Format for Write method. <br>
Standard_EXPORT   void SetFormat(const AlienImage_SUNRFFormat aFormat) ;

//! Get SUN Raster File Format . <br>
Standard_EXPORT   AlienImage_SUNRFFormat Format() const;

//! convert a SunRFAlienData object to a Image object. <br>
Standard_EXPORT   Handle_Image_Image ToImage() const;

//! convert a Image object to a SunRFAlienData object. <br>
Standard_EXPORT   void FromImage(const Handle(Image_Image)& anImage) ;

//! convert a Image object to a SunRFAlienData object. <br>
Standard_EXPORT   void FromPseudoColorImage(const Handle(Image_PseudoColorImage)& anImage) ;

//! convert a Image object to a SunRFAlienData object. <br>
Standard_EXPORT   void FromColorImage(const Handle(Image_ColorImage)& anImage) ;

//! Read a Image row from a file and store <br>
//!           TheRowSize byte at aAddress <br>
//!           returns True if Success. <br>
Standard_EXPORT   Standard_Boolean ReadPixelRow(OSD_File& afile,const Standard_Address aAddress,const Standard_Integer TheRowSize) ;

//! Write a Image row to a file from TheRowSize byte at <br>
//!           aAddress <br>
//!           returns True if Success. <br>
Standard_EXPORT   Standard_Boolean WritePixelRow(OSD_File& afile,const Standard_Address aAddress,const Standard_Integer TheRowSize) const;




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
AlienImage_SUNRFFileHeader myHeader;
Standard_Address myData;
Standard_Address myRedData;
Standard_Address myGreenData;
Standard_Address myBlueData;


private: 

 // Methods PRIVATE
 // 

//! convert a AlienImage object to a Image object. <br>
Standard_EXPORT   Handle_Image_PseudoColorImage ToPseudoColorImage() const;

//! convert a AlienImage object to a Image object. <br>
Standard_EXPORT   Handle_Image_ColorImage ToColorImage() const;


 // Fields PRIVATE
 //
Standard_Integer myDataSize;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
