// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOPTools_ComparePave_HeaderFile
#define _BOPTools_ComparePave_HeaderFile

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class BOPTools_Pave;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//! <br>
//! Auxiliary class for sorting paves along the edge <br>
//! in acoordance with increasing order of parameter <br>
class BOPTools_ComparePave  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Empty constructor <br>
//! Default comparing tolerance value=1.e-12 <br>
Standard_EXPORT BOPTools_ComparePave();


//! Constructor that use comparing tolerance value as parameter. <br>
Standard_EXPORT BOPTools_ComparePave(const Standard_Real aTol);


//! Returns True if <Left> is lower than <Right>. <br>
Standard_EXPORT   Standard_Boolean IsLower(const BOPTools_Pave& Left,const BOPTools_Pave& Right) const;


//! Returns True if <Left> is greater than <Right>. <br>
Standard_EXPORT   Standard_Boolean IsGreater(const BOPTools_Pave& Left,const BOPTools_Pave& Right) const;


//! Returns True when <Right> and <Left> are equal. <br>
Standard_EXPORT   Standard_Boolean IsEqual(const BOPTools_Pave& Left,const BOPTools_Pave& Right) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Real myTol;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
