// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BOP_SFSCorrector_HeaderFile
#define _BOP_SFSCorrector_HeaderFile

#ifndef _BOP_PShellFaceSet_HeaderFile
#include <BOP_PShellFaceSet.hxx>
#endif
#ifndef _BOP_ShellFaceSet_HeaderFile
#include <BOP_ShellFaceSet.hxx>
#endif
#ifndef _BOP_ListOfConnexityBlock_HeaderFile
#include <BOP_ListOfConnexityBlock.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class BOP_ShellFaceSet;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//!  the algorithm is to change the Shell Faces Set (SFS)contents. <br>
//!  The NewSFS will contain only shells <br>
//!  instead of shells and faces. <br>
//! <br>
class BOP_SFSCorrector  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Empty constructor; <br>
Standard_EXPORT BOP_SFSCorrector();


//! Modifier <br>
Standard_EXPORT   void SetSFS(const BOP_ShellFaceSet& aSFS) ;


//! Performs the algorithm of  two  steps <br>
//! 1. Make conexity blocks (  DoConnexityBlocks()  ) <br>
//! 2. Make corrections     (  DoCorrections()  ) <br>
Standard_EXPORT   void Do() ;


//! Selector <br>
Standard_EXPORT   Standard_Boolean IsDone() const;


//! Selector <br>
//! - 1 - Nothing is done because only constructor has been called <br>
Standard_EXPORT   Standard_Integer ErrorStatus() const;


//! Selector <br>
Standard_EXPORT   BOP_ShellFaceSet& SFS() ;


//! Selector <br>
//! Returns the resulting SFS <br>
Standard_EXPORT   BOP_ShellFaceSet& NewSFS() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


//! Internal Purpose <br>
Standard_EXPORT   void DoConnexityBlocks() ;


//! Internal Purpose <br>
Standard_EXPORT   void DoCorrections() ;


 // Fields PRIVATE
 //
BOP_PShellFaceSet mySFS;
BOP_ShellFaceSet myNewSFS;
BOP_ListOfConnexityBlock myConnexityBlocks;
Standard_Boolean myIsDone;
Standard_Integer myErrorStatus;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
