// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepBuilderAPI_MakeVertex_HeaderFile
#define _BRepBuilderAPI_MakeVertex_HeaderFile

#ifndef _BRepLib_MakeVertex_HeaderFile
#include <BRepLib_MakeVertex.hxx>
#endif
#ifndef _BRepBuilderAPI_MakeShape_HeaderFile
#include <BRepBuilderAPI_MakeShape.hxx>
#endif
class gp_Pnt;
class TopoDS_Vertex;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Describes functions to build BRepBuilder vertices directly <br>
//! from 3D geometric points. A vertex built using a <br>
//! MakeVertex object is only composed of a 3D point and <br>
//! a default precision value (Precision::Confusion()). <br>
//! Later on, 2D representations can be added, for example, <br>
//! when inserting a vertex in an edge. <br>
//! A MakeVertex object provides a framework for: <br>
//! -   defining and implementing the construction of a vertex, and <br>
//! -   consulting the result. <br>
class BRepBuilderAPI_MakeVertex  : public BRepBuilderAPI_MakeShape {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Constructs a vertex from point P. <br>
//! Example create a vertex from a 3D point. <br>
//! gp_Pnt P(0,0,10); <br>
//! TopoDS_Vertex V = BRepBuilderAPI_MakeVertex(P); <br>
Standard_EXPORT BRepBuilderAPI_MakeVertex(const gp_Pnt& P);

//! Returns the constructed vertex. <br>
Standard_EXPORT  const TopoDS_Vertex& Vertex() const;
Standard_EXPORT operator TopoDS_Vertex() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
BRepLib_MakeVertex myMakeVertex;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
