// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepClass3d_SolidClassifier_HeaderFile
#define _BRepClass3d_SolidClassifier_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _BRepClass3d_SolidExplorer_HeaderFile
#include <BRepClass3d_SolidExplorer.hxx>
#endif
#ifndef _BRepClass3d_SClassifier_HeaderFile
#include <BRepClass3d_SClassifier.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Standard_DomainError;
class TopoDS_Shape;
class gp_Pnt;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Provides an algorithm to classify a point in a solid. <br>
class BRepClass3d_SolidClassifier  : public BRepClass3d_SClassifier {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! empty constructor <br>
Standard_EXPORT BRepClass3d_SolidClassifier();


Standard_EXPORT   void Load(const TopoDS_Shape& S) ;

//! Constructor from a Shape. <br>
Standard_EXPORT BRepClass3d_SolidClassifier(const TopoDS_Shape& S);

//! Constructor to classify the point P with the <br>
//!          tolerance Tol on the solid S. <br>
Standard_EXPORT BRepClass3d_SolidClassifier(const TopoDS_Shape& S,const gp_Pnt& P,const Standard_Real Tol);

//! Classify the point P with the <br>
//!          tolerance Tol on the solid S. <br>
Standard_EXPORT   void Perform(const gp_Pnt& P,const Standard_Real Tol) ;

//! Classify an infinite point with the <br>
//!          tolerance Tol on the solid S. <br>
//!          Useful for compute the orientation of a solid. <br>
Standard_EXPORT   void PerformInfinitePoint(const Standard_Real Tol) ;


Standard_EXPORT   void Destroy() ;
~BRepClass3d_SolidClassifier()
{
  Destroy();
}






protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean aSolidLoaded;
BRepClass3d_SolidExplorer explorer;
Standard_Boolean isaholeinspace;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
