// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepOffsetAPI_MakeEvolved_HeaderFile
#define _BRepOffsetAPI_MakeEvolved_HeaderFile

#ifndef _BRepFill_Evolved_HeaderFile
#include <BRepFill_Evolved.hxx>
#endif
#ifndef _BRepBuilderAPI_MakeShape_HeaderFile
#include <BRepBuilderAPI_MakeShape.hxx>
#endif
#ifndef _GeomAbs_JoinType_HeaderFile
#include <GeomAbs_JoinType.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class TopoDS_Wire;
class TopoDS_Face;
class BRepFill_Evolved;
class TopTools_ListOfShape;
class TopoDS_Shape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Describes functions to build evolved shapes. <br>
//! An evolved shape is built from a planar spine (face or <br>
//! wire) and a profile (wire). The evolved shape is the <br>
//! unlooped sweep (pipe) of the profile along the spine. <br>
//! Self-intersections are removed. <br>
//! A MakeEvolved object provides a framework for: <br>
//! - defining the construction of an evolved shape, <br>
//! - implementing the construction algorithm, and <br>
//! - consulting the result. <br>
//!        Computes an Evolved by <br>
//!             1 - sweeping a profil along a spine. <br>
//!             2 - removing the self-intersections. <br>
//! <br>
//!  The profile is defined in a Referential R. The position of <br>
//!  the profile at the current point of the  spine is given by <br>
//!  confusing R  and the local  referential given by (  D0, D1 <br>
//!  and the normal of the Spine) <br>
//! <br>
//!  If the Boolean <AxeProf> is  true, R is  O,X,Y,Z <br>
//!  else R is defined as the local refential at the nearest <br>
//!  point of the profil to the spine. <br>
//! <br>
//!   if <Solid> is TRUE the Shape result  is completed to be a <br>
//!   solid or a compound of solids. <br>
class BRepOffsetAPI_MakeEvolved  : public BRepBuilderAPI_MakeShape {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT BRepOffsetAPI_MakeEvolved();


Standard_EXPORT BRepOffsetAPI_MakeEvolved(const TopoDS_Wire& Spine,const TopoDS_Wire& Profil,const GeomAbs_JoinType Join = GeomAbs_Arc,const Standard_Boolean AxeProf = Standard_True,const Standard_Boolean Solid = Standard_False,const Standard_Boolean ProfOnSpine = Standard_False,const Standard_Real Tol = 0.0000001);

//! These constructors construct an evolved shape by sweeping the profile <br>
//! Profile along the spine Spine. <br>
//!	The profile is defined in a coordinate system R. <br>
//! The coordinate system is determined by AxeProf: <br>
//! - if AxeProf is true, R is the global coordinate system, <br>
//! - if AxeProf is false, R is computed so that: <br>
//!   - its origin is given by the point on the spine which is <br>
//!    closest to the profile, <br>
//!   - its "X Axis" is given by the tangent to the spine at this point, and <br>
//! - its "Z Axis" is the normal to the plane which contains the spine. <br>
//!        The position of the profile at the current point of the <br>
//! spine is given by making R coincident with the local <br>
//! coordinate system given by the current point, the <br>
//! tangent vector and the normal to the spine. <br>
//! Join defines the type of pipe generated by the salient <br>
//! vertices of the spine. The default type is GeomAbs_Arc <br>
//! where the vertices generate revolved pipes about the <br>
//! axis passing along the vertex and the normal to the <br>
//! plane of the spine. At present, this is the only <br>
//! construction type implemented. <br>
Standard_EXPORT BRepOffsetAPI_MakeEvolved(const TopoDS_Face& Spine,const TopoDS_Wire& Profil,const GeomAbs_JoinType Join = GeomAbs_Arc,const Standard_Boolean AxeProf = Standard_True,const Standard_Boolean Solid = Standard_False,const Standard_Boolean ProfOnSpine = Standard_False,const Standard_Real Tol = 0.0000001);


Standard_EXPORT  const BRepFill_Evolved& Evolved() const;

//! Builds the resulting shape (redefined from MakeShape). <br>
Standard_EXPORT virtual  void Build() ;

//! Returns   the  shapes  created  from   a  subshape <br>
//!          <SpineShape>  of     the  spine   and   a subshape <br>
//!          <ProfShape> on the profile. <br>
Standard_EXPORT  const TopTools_ListOfShape& GeneratedShapes(const TopoDS_Shape& SpineShape,const TopoDS_Shape& ProfShape) const;

//! Return the face Top if <Solid> is True in the constructor. <br>
Standard_EXPORT  const TopoDS_Shape& Top() const;

//! Return the face Bottom  if <Solid> is True in the constructor. <br>
Standard_EXPORT  const TopoDS_Shape& Bottom() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
BRepFill_Evolved myEvolved;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
