// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepPrim_FaceBuilder_HeaderFile
#define _BRepPrim_FaceBuilder_HeaderFile

#ifndef _TopoDS_Vertex_HeaderFile
#include <TopoDS_Vertex.hxx>
#endif
#ifndef _TopoDS_Edge_HeaderFile
#include <TopoDS_Edge.hxx>
#endif
#ifndef _TopoDS_Face_HeaderFile
#include <TopoDS_Face.hxx>
#endif
#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Standard_ConstructionError;
class Standard_OutOfRange;
class BRep_Builder;
class Geom_Surface;
class TopoDS_Face;
class TopoDS_Edge;
class TopoDS_Vertex;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! The  FaceBuilder is an algorithm   to build a BRep <br>
//!          Face from a Geom Surface. <br>
//! <br>
//!          The  face covers  the  whole surface or  the  area <br>
//!          delimited by UMin, UMax, VMin, VMax <br>
class BRepPrim_FaceBuilder  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT BRepPrim_FaceBuilder();


Standard_EXPORT BRepPrim_FaceBuilder(const BRep_Builder& B,const Handle(Geom_Surface)& S);


Standard_EXPORT BRepPrim_FaceBuilder(const BRep_Builder& B,const Handle(Geom_Surface)& S,const Standard_Real UMin,const Standard_Real UMax,const Standard_Real VMin,const Standard_Real VMax);


Standard_EXPORT   void Init(const BRep_Builder& B,const Handle(Geom_Surface)& S) ;


Standard_EXPORT   void Init(const BRep_Builder& B,const Handle(Geom_Surface)& S,const Standard_Real UMin,const Standard_Real UMax,const Standard_Real VMin,const Standard_Real VMax) ;


Standard_EXPORT  const TopoDS_Face& Face() const;
Standard_EXPORT operator TopoDS_Face();

//! Returns the edge of index <I> <br>
//!          1 - Edge VMin <br>
//!          2 - Edge UMax <br>
//!          3 - Edge VMax <br>
//!          4 - Edge UMin <br>
//! <br>
Standard_EXPORT  const TopoDS_Edge& Edge(const Standard_Integer I) const;

//! Returns the vertex of index <I> <br>
//!          1 - Vertex UMin,VMin <br>
//!          2 - Vertex UMax,VMin <br>
//!          3 - Vertex UMax,VMax <br>
//!          4 - Vertex UMin,VMax <br>
//! <br>
Standard_EXPORT  const TopoDS_Vertex& Vertex(const Standard_Integer I) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopoDS_Vertex myVertex[4];
TopoDS_Edge myEdges[4];
TopoDS_Face myFace;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
